/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public final class YamlArrayAdapter
implements JsonArrayValueAdapter {
    @NotNull
    private final YAMLSequence myArray;
    @NotNull
    private final NotNullLazyValue<List<JsonValueAdapter>> myChildAdapters;

    public YamlArrayAdapter(@NotNull YAMLSequence array) {
        if (array == null) {
            YamlArrayAdapter.$$$reportNull$$$0(0);
        }
        this.myChildAdapters = NotNullLazyValue.lazy(this::computeChildAdapters);
        this.myArray = array;
    }

    @NotNull
    public List<JsonValueAdapter> getElements() {
        List list = (List)this.myChildAdapters.getValue();
        if (list == null) {
            YamlArrayAdapter.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        PsiElement tag = this.myArray.getTag();
        return tag == null || "!!seq".equals(tag.getText());
    }

    public boolean isStringLiteral() {
        return false;
    }

    public boolean isNumberLiteral() {
        return false;
    }

    public boolean isBooleanLiteral() {
        return false;
    }

    @NotNull
    public PsiElement getDelegate() {
        YAMLSequence yAMLSequence = this.myArray;
        if (yAMLSequence == null) {
            YamlArrayAdapter.$$$reportNull$$$0(2);
        }
        return yAMLSequence;
    }

    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @NotNull
    public JsonArrayValueAdapter getAsArray() {
        YamlArrayAdapter yamlArrayAdapter = this;
        if (yamlArrayAdapter == null) {
            YamlArrayAdapter.$$$reportNull$$$0(3);
        }
        return yamlArrayAdapter;
    }

    @NotNull
    private List<JsonValueAdapter> computeChildAdapters() {
        List items = this.myArray.getItems();
        ArrayList<JsonValueAdapter> adapters = new ArrayList<JsonValueAdapter>(items.size());
        for (YAMLSequenceItem item : items) {
            YAMLValue value = item.getValue();
            if (value == null) {
                JsonValueAdapter emptyAdapter = YamlPropertyAdapter.createEmptyValueAdapter(item.getFirstChild(), true);
                if (emptyAdapter == null) continue;
                adapters.add(emptyAdapter);
                continue;
            }
            adapters.add(YamlPropertyAdapter.createValueAdapterByType(value));
        }
        ArrayList<JsonValueAdapter> arrayList = adapters;
        if (arrayList == null) {
            YamlArrayAdapter.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlArrayAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlArrayAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeChildAdapters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

