/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SettingsSyncStateHolder;
import com.intellij.settingsSync.config.SettingsSyncPanelFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0014J\b\u0010\u0018\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "parent", "Ljavax/swing/JComponent;", "remoteSettings", "Lcom/intellij/settingsSync/SettingsSyncState;", "(Ljavax/swing/JComponent;Lcom/intellij/settingsSync/SettingsSyncState;)V", "configPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "dialogResult", "Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog$Result;", "remoteSettingsExist", "", "syncSettings", "getSyncSettings", "()Lcom/intellij/settingsSync/SettingsSyncState;", "applyAndClose", "", "result", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "getResult", "EnableSyncAction", "GetSettingsFromAccountAction", "Result", "SyncLocalSettingsAction", "intellij.settingsSync"})
public final class EnableSettingsSyncDialog
extends DialogWrapper {
    private DialogPanel configPanel;
    @Nullable
    private Result dialogResult;
    @NotNull
    private final SettingsSyncState syncSettings;
    private final boolean remoteSettingsExist;

    public EnableSettingsSyncDialog(@NotNull JComponent parent, @Nullable SettingsSyncState remoteSettings) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super((Component)parent, false);
        SettingsSyncState settingsSyncState = remoteSettings;
        if (settingsSyncState == null) {
            settingsSyncState = new SettingsSyncStateHolder(null, 1, null);
        }
        this.syncSettings = settingsSyncState;
        this.remoteSettingsExist = remoteSettings != null;
        this.setTitle(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]));
        this.init();
    }

    @NotNull
    public final SettingsSyncState getSyncSettings() {
        return this.syncSettings;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.configPanel = SettingsSyncPanelFactory.INSTANCE.createPanel(SettingsSyncBundle.INSTANCE.message("enable.dialog.select.what.to.sync", new Object[0]), this.syncSettings);
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        dialogPanel.reset();
        DialogPanel dialogPanel2 = this.configPanel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        if (this.remoteSettingsExist) {
            Action[] actionArray2 = new Action[3];
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
            actionArray2[1] = new SyncLocalSettingsAction();
            actionArray2[2] = new GetSettingsFromAccountAction();
            actionArray = actionArray2;
        } else {
            EnableSyncAction enableSyncAction = new EnableSyncAction();
            enableSyncAction.putValue("DefaultAction", true);
            Action[] actionArray3 = new Action[2];
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
            actionArray3[1] = enableSyncAction;
            actionArray = actionArray3;
        }
        return actionArray;
    }

    private final void applyAndClose(Result result2) {
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        this.dialogResult = result2;
        this.close(0, true);
    }

    @Nullable
    public final Result getResult() {
        return this.dialogResult;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog$EnableSyncAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.settingsSync"})
    public final class EnableSyncAction
    extends AbstractAction {
        public EnableSyncAction() {
            super(SettingsSyncBundle.INSTANCE.message("enable.dialog.enable.sync.action", new Object[0]));
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            EnableSettingsSyncDialog.this.applyAndClose(Result.PUSH_LOCAL);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog$GetSettingsFromAccountAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.settingsSync"})
    public final class GetSettingsFromAccountAction
    extends AbstractAction {
        public GetSettingsFromAccountAction() {
            super(SettingsSyncBundle.INSTANCE.message("enable.dialog.get.settings.from.account", new Object[0]));
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            EnableSettingsSyncDialog.this.applyAndClose(Result.GET_FROM_SERVER);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog$Result;", "", "(Ljava/lang/String;I)V", "PUSH_LOCAL", "GET_FROM_SERVER", "intellij.settingsSync"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result PUSH_LOCAL = new Result();
        public static final /* enum */ Result GET_FROM_SERVER = new Result();
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.PUSH_LOCAL, Result.GET_FROM_SERVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog$SyncLocalSettingsAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/settingsSync/config/EnableSettingsSyncDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.settingsSync"})
    public final class SyncLocalSettingsAction
    extends AbstractAction {
        public SyncLocalSettingsAction() {
            super(SettingsSyncBundle.INSTANCE.message("enable.dialog.sync.local.settings", new Object[0]));
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            EnableSettingsSyncDialog.this.applyAndClose(Result.PUSH_LOCAL);
        }
    }
}

