/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers;

import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledEditorColorScheme;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.mappings.ThemesMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.mappings.SchemesMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.GeneralSettingsParserKt;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "associatedScheme", "", "Lcom/intellij/ide/startup/importSettings/models/BundledLookAndFeel;", "Lcom/intellij/ide/startup/importSettings/models/BundledEditorColorScheme;", "currentLaf", "Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "process", "", "file", "Ljava/io/File;", "processThemeAndScheme", "root", "Lorg/jdom/Element;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nGeneralSettingsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralSettingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n*S KotlinDebug\n*F\n+ 1 GeneralSettingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser\n*L\n45#1:74,2\n*E\n"})
public final class GeneralSettingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private ILookAndFeel currentLaf;
    @NotNull
    private final Map<BundledLookAndFeel, BundledEditorColorScheme> associatedScheme;
    @NotNull
    private static final String KEY = "key";
    @NotNull
    private static final String VALUE = "value";
    @NotNull
    private static final String THEME = "MonoDevelop.Ide.UserInterfaceTheme";
    @NotNull
    private static final String SCHEME = "ColorScheme";
    @NotNull
    private static final String SCHEME_DARK = "ColorScheme-Dark";

    public GeneralSettingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        ILookAndFeel iLookAndFeel = this.settings.getLaf();
        if (iLookAndFeel == null) {
            iLookAndFeel = KnownLafs.INSTANCE.getLight();
        }
        this.currentLaf = iLookAndFeel;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KnownLafs.INSTANCE.getLight(), (Object)KnownColorSchemes.INSTANCE.getLight()), TuplesKt.to((Object)KnownLafs.INSTANCE.getDarcula(), (Object)KnownColorSchemes.INSTANCE.getDarcula())};
        this.associatedScheme = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            GeneralSettingsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processThemeAndScheme(root);
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processThemeAndScheme(Element root) {
        try {
            List list = root.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            block9: for (Object element$iv : $this$forEach$iv) {
                Element element = (Element)element$iv;
                boolean bl = false;
                try {
                    BundledEditorColorScheme bundledEditorColorScheme;
                    BundledLookAndFeel bundledLookAndFeel;
                    Map<BundledLookAndFeel, BundledEditorColorScheme> map;
                    String value;
                    block12: {
                        String string;
                        String string2;
                        List list2;
                        Element element2 = element;
                        List list3 = list2 = element2 != null ? element2.getAttributes() : null;
                        if (list3 == null) continue;
                        Intrinsics.checkNotNull((Object)list3);
                        List attributes = list2;
                        if (attributes.size() != 2) continue;
                        Object object = (Attribute)attributes.get(0);
                        boolean bl2 = object != null && (object = object.getName()) != null ? ((String)object).equals(KEY) : false;
                        if (!bl2) continue;
                        Object object2 = (Attribute)attributes.get(1);
                        boolean bl3 = object2 != null && (object2 = object2.getName()) != null ? ((String)object2).equals(VALUE) : false;
                        if (!bl3) continue;
                        Attribute attribute = (Attribute)attributes.get(0);
                        String string3 = string2 = attribute != null ? attribute.getValue() : null;
                        if (string3 == null) continue;
                        Intrinsics.checkNotNull((Object)string3);
                        String settingId = string2;
                        Attribute attribute2 = (Attribute)attributes.get(1);
                        String string4 = string = attribute2 != null ? attribute2.getValue() : null;
                        if (string4 == null) continue;
                        Intrinsics.checkNotNull((Object)string4);
                        value = string;
                        string = settingId;
                        switch (string.hashCode()) {
                            case 1274568571: {
                                if (!string.equals(SCHEME_DARK)) {
                                    continue block9;
                                }
                                break block12;
                            }
                            case -1660902712: {
                                if (string.equals(SCHEME)) break;
                                continue block9;
                            }
                            case -288411309: {
                                if (!string.equals(THEME)) continue block9;
                                BundledLookAndFeel bundledLookAndFeel2 = ThemesMappings.INSTANCE.themeMap(value);
                                if (bundledLookAndFeel2 == null) {
                                    continue block9;
                                }
                                this.currentLaf = bundledLookAndFeel2;
                                continue block9;
                            }
                        }
                        map = this.associatedScheme;
                        bundledLookAndFeel = KnownLafs.INSTANCE.getLight();
                        if (SchemesMappings.INSTANCE.schemeMap(value) == null) continue;
                        map.put(bundledLookAndFeel, bundledEditorColorScheme);
                        continue;
                    }
                    map = this.associatedScheme;
                    bundledLookAndFeel = KnownLafs.INSTANCE.getDarcula();
                    if (SchemesMappings.INSTANCE.schemeMap(value) == null) continue;
                    map.put(bundledLookAndFeel, bundledEditorColorScheme);
                }
                catch (Throwable t) {
                    GeneralSettingsParserKt.access$getLogger$p().warn(t);
                }
            }
            this.settings.setLaf(this.currentLaf);
            this.settings.setSyntaxScheme(this.associatedScheme.get(this.currentLaf));
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser$Companion;", "", "()V", "KEY", "", "SCHEME", "SCHEME_DARK", "THEME", "VALUE", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

