/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdclient/editorActions/FrontendEscapeHandlerAction;", "Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
public final class FrontendEscapeHandlerAction
extends FrontendEditorActionHandler {
    public FrontendEscapeHandlerAction(@NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super("EditorEscape", baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project2);
        if (ideBackend == null) {
            return false;
        }
        IdeBackend backend = ideBackend;
        Boolean backendResult = backend.isEscapeAvailable();
        if (backendResult != null) {
            return backendResult != false && super.backendIsEnabledForCaret(editor2, caret, dataContext);
        }
        String string = this.getFrontendId();
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        return BackendActionDelegationKt.backendUpdate(string, anActionEvent);
    }
}

