/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.LocalStatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.logger.StatisticsEventLogThrottleWriter;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.runtime.product.ProductMode;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 .2\u00020\u0001:\u0001.B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u000fH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u0004\u0018\u00010'J\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020\u000bH\u0016J\u0006\u0010+\u001a\u00020\u000bJ\b\u0010,\u001a\u00020\u000bH&J\b\u0010-\u001a\u00020\u000bH&R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "", "recorderId", "", "version", "", "sendFrequencyMs", "", "maxFileSizeInBytes", "(Ljava/lang/String;IJI)V", "sendLogsOnIdeClose", "", "isCharsEscapingRequired", "(Ljava/lang/String;IJIZZ)V", "actualLogger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getActualLogger", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "actualLogger$delegate", "Lkotlin/Lazy;", "()Z", "localLogger", "getLocalLogger", "localLogger$delegate", "logger", "getLogger", "getRecorderId", "()Ljava/lang/String;", "getSendFrequencyMs", "()J", "getSendLogsOnIdeClose", "getVersion", "()I", "createEventsMergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "createLocalLogger", "createLogger", "detectClionNova", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "isLoggingAlwaysActive", "isLoggingEnabled", "isRecordEnabled", "isSendEnabled", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogger.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,201:1\n13#2:202\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogger.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider\n*L\n51#1:202\n*E\n"})
public abstract class StatisticsEventLoggerProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    private final int version;
    private final long sendFrequencyMs;
    private final int maxFileSizeInBytes;
    private final boolean sendLogsOnIdeClose;
    private final boolean isCharsEscapingRequired;
    @NotNull
    private final Lazy localLogger$delegate;
    @NotNull
    private final Lazy actualLogger$delegate;
    @NotNull
    private static final ExtensionPointName<StatisticsEventLoggerProvider> EP_NAME = new ExtensionPointName("com.intellij.statistic.eventLog.eventLoggerProvider");
    public static final int DEFAULT_MAX_FILE_SIZE_BYTES = 204800;
    private static final long DEFAULT_SEND_FREQUENCY_MS = TimeUnit.HOURS.toMillis(1L);
    @NotNull
    private static final Logger LOG;

    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes, boolean sendLogsOnIdeClose, boolean isCharsEscapingRequired) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderId = recorderId;
        this.version = version;
        this.sendFrequencyMs = sendFrequencyMs;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.sendLogsOnIdeClose = sendLogsOnIdeClose;
        this.isCharsEscapingRequired = isCharsEscapingRequired;
        this.localLogger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StatisticsEventLogger>(this){
            final /* synthetic */ StatisticsEventLoggerProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final StatisticsEventLogger invoke() {
                return StatisticsEventLoggerProvider.access$createLocalLogger(this.this$0);
            }
        }));
        this.actualLogger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StatisticsEventLogger>(this){
            final /* synthetic */ StatisticsEventLoggerProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final StatisticsEventLogger invoke() {
                return StatisticsEventLoggerProvider.access$createLogger(this.this$0);
            }
        }));
    }

    public /* synthetic */ StatisticsEventLoggerProvider(String string, int n, long l, int n2, boolean bl, boolean bl2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            bl2 = true;
        }
        this(string, n, l, n2, bl, bl2);
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getSendFrequencyMs() {
        return this.sendFrequencyMs;
    }

    public final boolean getSendLogsOnIdeClose() {
        return this.sendLogsOnIdeClose;
    }

    public final boolean isCharsEscapingRequired() {
        return this.isCharsEscapingRequired;
    }

    @Deprecated(message="Use primary constructor instead")
    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this(recorderId, version, sendFrequencyMs, maxFileSizeInBytes, false, false, 32, null);
    }

    private final StatisticsEventLogger getLocalLogger() {
        Lazy lazy = this.localLogger$delegate;
        return (StatisticsEventLogger)lazy.getValue();
    }

    private final StatisticsEventLogger getActualLogger() {
        Lazy lazy = this.actualLogger$delegate;
        return (StatisticsEventLogger)lazy.getValue();
    }

    @NotNull
    public StatisticsEventLogger getLogger() {
        return this.isLoggingEnabled() ? this.getActualLogger() : this.getLocalLogger();
    }

    public abstract boolean isRecordEnabled();

    public abstract boolean isSendEnabled();

    public final boolean isLoggingEnabled() {
        return this.isRecordEnabled() || this.isLoggingAlwaysActive();
    }

    public boolean isLoggingAlwaysActive() {
        return false;
    }

    @Nullable
    public final EventLogFile getActiveLogFile() {
        return this.getLogger().getActiveLogFile();
    }

    @NotNull
    public final EventLogFilesProvider getLogFilesProvider() {
        return this.getLogger().getLogFilesProvider();
    }

    @NotNull
    public StatisticsEventMergeStrategy createEventsMergeStrategy() {
        return new FilteredEventMergeStrategy(SetsKt.emptySet());
    }

    private final StatisticsEventLogger createLogger() {
        Application app = ApplicationManager.getApplication();
        boolean isEap = app != null && app.isEAP();
        boolean isHeadless = app != null && app.isHeadlessEnvironment();
        String ideMode = AppMode.isRemoteDevHost() ? "RDH" : null;
        String currentProductModeId = ProductLoadingStrategy.Companion.getStrategy().getCurrentModeId();
        String productMode = !Intrinsics.areEqual((Object)currentProductModeId, (Object)ProductMode.LOCAL_IDE.getId()) ? currentProductModeId : (this.detectClionNova() ? "nova" : null);
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        EventLogRecorderConfiguration config = eventLogConfiguration.getOrCreate(this.recorderId);
        StatisticsEventLogFileWriter writer = new StatisticsEventLogFileWriter(this.recorderId, this, this.maxFileSizeInBytes, isEap, eventLogConfiguration.getBuild());
        EventLogConfigOptionsService configService = EventLogConfigOptionsService.getInstance();
        Intrinsics.checkNotNull((Object)configService);
        StatisticsEventLogThrottleWriter throttledWriter = new StatisticsEventLogThrottleWriter(configService, this.recorderId, String.valueOf(this.version), writer);
        String string = config.getSessionId();
        String string2 = eventLogConfiguration.getBuild();
        String string3 = String.valueOf(config.getBucket());
        String string4 = String.valueOf(this.version);
        StatisticsEventLogWriter statisticsEventLogWriter = throttledWriter;
        UsageStatisticsPersistenceComponent usageStatisticsPersistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)usageStatisticsPersistenceComponent, (String)"getInstance(...)");
        StatisticsFileEventLogger logger = new StatisticsFileEventLogger(this.recorderId, string, isHeadless, string2, string3, string4, statisticsEventLogWriter, usageStatisticsPersistenceComponent, this.createEventsMergeStrategy(), ideMode, productMode);
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)logger);
        return logger;
    }

    private final StatisticsEventLogger createLocalLogger() {
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        LocalStatisticsFileEventLogger logger = new LocalStatisticsFileEventLogger(this.recorderId, eventLogConfiguration.getBuild(), String.valueOf(this.version), this.createEventsMergeStrategy());
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)logger);
        return logger;
    }

    private final boolean detectClionNova() {
        return Intrinsics.areEqual((Object)System.getProperty("idea.suppressed.plugins.set.selector"), (Object)"radler");
    }

    @NotNull
    public static final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
        return Companion.getEP_NAME();
    }

    public static final /* synthetic */ StatisticsEventLogger access$createLocalLogger(StatisticsEventLoggerProvider $this) {
        return $this.createLocalLogger();
    }

    public static final /* synthetic */ StatisticsEventLogger access$createLogger(StatisticsEventLoggerProvider $this) {
        return $this.createLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StatisticsEventLoggerProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider$Companion;", "", "()V", "DEFAULT_MAX_FILE_SIZE_BYTES", "", "DEFAULT_SEND_FREQUENCY_MS", "", "getDEFAULT_SEND_FREQUENCY_MS", "()J", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "parseFileSize", "maxFileSize", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        public final long getDEFAULT_SEND_FREQUENCY_MS() {
            return DEFAULT_SEND_FREQUENCY_MS;
        }

        public final int parseFileSize(@NotNull String maxFileSize) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)maxFileSize, (String)"maxFileSize");
            int length = maxFileSize.length();
            if (length < 3) {
                LOG.warn("maxFileSize should contain measurement unit: " + maxFileSize);
                return 204800;
            }
            String string = maxFileSize.substring(0, length - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            try {
                n2 = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Unable to parse maxFileSize for FUS log file: " + maxFileSize);
                return 204800;
            }
            int size = n2;
            String string2 = maxFileSize.substring(length - 2, length);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            switch (string2) {
                case "KB": {
                    n = 1024;
                    break;
                }
                case "MB": {
                    n = 0x100000;
                    break;
                }
                case "GB": {
                    n = 0x40000000;
                    break;
                }
                default: {
                    LOG.warn("Unable to parse measurement unit of maxFileSize for FUS log file: " + maxFileSize);
                    return 204800;
                }
            }
            int multiplier = n;
            return size * multiplier;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

