/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.comment;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.net.URL;
import java.util.Date;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabId;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequest;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDraftNote;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition;
import org.jetbrains.plugins.gitlab.mergerequest.ui.emoji.GitLabReactionsViewModel;
import org.jetbrains.plugins.gitlab.ui.GitLabUIUtil;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabDiscussionStateContainer;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabMergeRequestDiscussionViewModelKt;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteAdminActionsViewModel;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteAdminActionsViewModelImpl;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteViewModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010(R\u0019\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0017R\u0016\u0010,\u001a\u0004\u0018\u00010-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestStandaloneDraftNoteViewModelBase;", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "note", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDraftNote;", "mr", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDraftNote;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;)V", "actionsVm", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteAdminActionsViewModel;", "getActionsVm", "()Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteAdminActionsViewModel;", "author", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getAuthor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "body", "Lkotlinx/coroutines/flow/StateFlow;", "", "getBody", "()Lkotlinx/coroutines/flow/StateFlow;", "bodyHtml", "getBodyHtml", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "cs", "discussionState", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabDiscussionStateContainer;", "getDiscussionState", "id", "Lorg/jetbrains/plugins/gitlab/api/GitLabId;", "getId", "()Lorg/jetbrains/plugins/gitlab/api/GitLabId;", "isDraft", "", "()Z", "position", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "getPosition", "reactionsVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/emoji/GitLabReactionsViewModel;", "getReactionsVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/emoji/GitLabReactionsViewModel;", "serverUrl", "Ljava/net/URL;", "getServerUrl", "()Ljava/net/URL;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestDiscussionViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestDiscussionViewModel.kt\norg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestStandaloneDraftNoteViewModelBase\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,130:1\n44#2,4:131\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestDiscussionViewModel.kt\norg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestStandaloneDraftNoteViewModelBase\n*L\n109#1:131,4\n*E\n"})
public final class GitLabMergeRequestStandaloneDraftNoteViewModelBase
implements GitLabNoteViewModel {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GitLabId id;
    @NotNull
    private final GitLabUserDTO author;
    @Nullable
    private final Date createdAt;
    private final boolean isDraft;
    @NotNull
    private final URL serverUrl;
    @Nullable
    private final GitLabNoteAdminActionsViewModel actionsVm;
    @Nullable
    private final GitLabReactionsViewModel reactionsVm;
    @NotNull
    private final StateFlow<String> body;
    @NotNull
    private final StateFlow<String> bodyHtml;
    @NotNull
    private final StateFlow<GitLabDiscussionStateContainer> discussionState;
    @NotNull
    private final StateFlow<GitLabNotePosition> position;

    public GitLabMergeRequestStandaloneDraftNoteViewModelBase(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabMergeRequestDraftNote note, @NotNull GitLabMergeRequest mr) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (CoroutineContext)((CoroutineContext)new CoroutineExceptionHandler(key){

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable e = exception;
                boolean bl = false;
                GitLabMergeRequestDiscussionViewModelKt.access$getLOG$p().warn(e);
            }
        }), (boolean)false, (int)2, null);
        this.id = note.getId();
        this.author = note.getAuthor();
        this.createdAt = note.getCreatedAt();
        this.isDraft = true;
        this.serverUrl = mr.getGlProject().getServerPath().toURL();
        this.actionsVm = note.getCanAdmin() ? (GitLabNoteAdminActionsViewModel)new GitLabNoteAdminActionsViewModelImpl(this.cs, project, note) : null;
        this.body = note.getBody();
        this.bodyHtml = CoroutineUtilKt.mapStateInNow(this.getBody(), (CoroutineScope)this.cs, (Function1)((Function1)new Function1<String, String>(project, mr){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitLabMergeRequest $mr;
            {
                this.$project = $project;
                this.$mr = $mr;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GitLabUIUtil.INSTANCE.convertToHtml$intellij_vcs_gitlab(this.$project, this.$mr.getGitRepository(), this.$mr.getGlProject().getProjectPath(), it);
            }
        }));
        this.discussionState = (StateFlow)StateFlowKt.MutableStateFlow((Object)GitLabDiscussionStateContainer.Companion.getDEFAULT());
        this.position = note.getPosition();
    }

    @Override
    @NotNull
    public GitLabId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public GitLabUserDTO getAuthor() {
        return this.author;
    }

    @Override
    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public boolean isDraft() {
        return this.isDraft;
    }

    @Override
    @NotNull
    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Override
    @Nullable
    public GitLabNoteAdminActionsViewModel getActionsVm() {
        return this.actionsVm;
    }

    @Override
    @Nullable
    public GitLabReactionsViewModel getReactionsVm() {
        return this.reactionsVm;
    }

    @Override
    @NotNull
    public StateFlow<String> getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public StateFlow<String> getBodyHtml() {
        return this.bodyHtml;
    }

    @Override
    @NotNull
    public StateFlow<GitLabDiscussionStateContainer> getDiscussionState() {
        return this.discussionState;
    }

    @NotNull
    public final StateFlow<GitLabNotePosition> getPosition() {
        return this.position;
    }
}

