/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefPsiNavigationUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.jcef.ProcessLinksExtension;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.accessor.MarkdownLinkOpener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000eH\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;)V", "handler", "org/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension$handler$1", "Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension$handler$1;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "", "getScripts", "()Ljava/util/List;", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "openLink", "link", "Provider", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nProcessLinksExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessLinksExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n23#2:67\n*S KotlinDebug\n*F\n+ 1 ProcessLinksExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension\n*L\n40#1:67\n*E\n"})
public final class ProcessLinksExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final handler.1 handler;
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final ResourceProvider resourceProvider;

    public ProcessLinksExtension(@NotNull MarkdownHtmlPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        this.handler = new BrowserPipe.Handler(this){
            final /* synthetic */ ProcessLinksExtension this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean processMessageReceived(@NotNull String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return ProcessLinksExtension.access$openLink(this.this$0, ProcessLinksExtension.access$getPanel$p(this.this$0), data);
            }
        };
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe("openLink", this.handler);
        }
        Disposer.register((Disposable)this, () -> ProcessLinksExtension._init_$lambda$0(this));
        this.scripts = CollectionsKt.listOf((Object)"processLinks/processLinks.js");
        this.resourceProvider = this;
    }

    private final boolean openLink(MarkdownHtmlPanel panel2, String link) {
        if (!Registry.is((String)"markdown.open.link.in.external.browser")) {
            return true;
        }
        if (JBCefPsiNavigationUtils.INSTANCE.navigateTo(link)) {
            return true;
        }
        if (panel2 instanceof MarkdownHtmlPanelEx && Intrinsics.areEqual((Object)((MarkdownHtmlPanelEx)panel2).getUserData(MarkdownHtmlPanelEx.Companion.getDO_NOT_USE_LINK_OPENER()), (Object)true)) {
            Object $this$openLink_u24lambda_u241;
            ProcessLinksExtension processLinksExtension = this;
            try {
                $this$openLink_u24lambda_u241 = processLinksExtension;
                boolean bl = false;
                BrowserUtil.browse((String)link);
                $this$openLink_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                $this$openLink_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            ProcessLinksExtension $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProcessLinksExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LoggerKt.getOrLogException((Object)$this$openLink_u24lambda_u241, (Logger)logger);
            return false;
        }
        MarkdownLinkOpener.Companion.getInstance().openLink(panel2.getProject(), link);
        return false;
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getScripts().contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(this.getClass()), resourceName, null, 4, null);
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(ProcessLinksExtension this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.removeSubscription("openLink", this$0.handler);
        }
    }

    public static final /* synthetic */ boolean access$openLink(ProcessLinksExtension $this, MarkdownHtmlPanel panel2, String link) {
        return $this.openLink(panel2, link);
    }

    public static final /* synthetic */ MarkdownHtmlPanel access$getPanel$p(ProcessLinksExtension $this) {
        return $this.panel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @NotNull
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new ProcessLinksExtension(panel2);
        }
    }
}

