/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u001a\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "", "indent", "", "markerLength", "(II)V", "getIndent", "()I", "getMarkerLength", "changeLineIndent", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "line", "newIndent", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "subItem", "subItemIndent", "toString", "", "with", "intellij.markdown"})
public final class ListItemIndentInfo {
    private final int indent;
    private final int markerLength;

    public ListItemIndentInfo(int indent, int markerLength) {
        this.indent = indent;
        this.markerLength = markerLength;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final int getMarkerLength() {
        return this.markerLength;
    }

    public final int subItemIndent() {
        return this.indent + this.markerLength;
    }

    @NotNull
    public final ListItemIndentInfo subItem(int markerLength) {
        return new ListItemIndentInfo(this.subItemIndent(), markerLength);
    }

    @NotNull
    public final ListItemIndentInfo with(int indent, int markerLength) {
        return new ListItemIndentInfo(indent, markerLength);
    }

    public static /* synthetic */ ListItemIndentInfo with$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = listItemIndentInfo.indent;
        }
        if ((n3 & 2) != 0) {
            n2 = listItemIndentInfo.markerLength;
        }
        return listItemIndentInfo.with(n, n2);
    }

    @Nullable
    public final Replacement changeLineIndent(int line, int newIndent, @NotNull Document document, @Nullable PsiFile file) {
        boolean lineIsBlank;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange oldIndentRange = ListUtils.INSTANCE.getLineIndentRange(document, line);
        String fullIndentStr = ListUtils.INSTANCE.getLineIndentSpaces(document, line, file);
        Integer realIndent = ListUtils.INSTANCE.getLineIndentInnerSpacesLength(document, line, file);
        boolean bl = lineIsBlank = oldIndentRange.getEndOffset() == document.getLineEndOffset(line);
        if (realIndent == null || fullIndentStr == null || realIndent < this.indent || lineIsBlank) {
            return null;
        }
        String newFullIndent = newIndent == this.indent ? fullIndentStr : (newIndent > this.indent ? fullIndentStr + StringsKt.repeat((CharSequence)" ", (int)(newIndent - this.indent)) : StringsKt.dropLast((String)fullIndentStr, (int)(this.indent - newIndent)));
        return new Replacement(oldIndentRange, newFullIndent);
    }

    public static /* synthetic */ Replacement changeLineIndent$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, Document document, PsiFile psiFile, int n3, Object object) {
        if ((n3 & 8) != 0) {
            psiFile = null;
        }
        return listItemIndentInfo.changeLineIndent(n, n2, document, psiFile);
    }

    public final int component1() {
        return this.indent;
    }

    public final int component2() {
        return this.markerLength;
    }

    @NotNull
    public final ListItemIndentInfo copy(int indent, int markerLength) {
        return new ListItemIndentInfo(indent, markerLength);
    }

    public static /* synthetic */ ListItemIndentInfo copy$default(ListItemIndentInfo listItemIndentInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = listItemIndentInfo.indent;
        }
        if ((n3 & 2) != 0) {
            n2 = listItemIndentInfo.markerLength;
        }
        return listItemIndentInfo.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "ListItemIndentInfo(indent=" + this.indent + ", markerLength=" + this.markerLength + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.indent);
        result2 = result2 * 31 + Integer.hashCode(this.markerLength);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListItemIndentInfo)) {
            return false;
        }
        ListItemIndentInfo listItemIndentInfo = (ListItemIndentInfo)other;
        if (this.indent != listItemIndentInfo.indent) {
            return false;
        }
        return this.markerLength == listItemIndentInfo.markerLength;
    }
}

