/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;

public class PrimitiveConstant
extends PooledConstant {
    public int index;
    public Object value;
    public boolean isArray;

    public PrimitiveConstant(int type, Object value) {
        super(type);
        this.value = value;
        this.initConstant();
    }

    public PrimitiveConstant(int type, int index) {
        super(type);
        this.index = index;
    }

    private void initConstant() {
        if (this.type == 7) {
            String className = this.getString();
            this.isArray = !className.isEmpty() && className.charAt(0) == '[';
        }
    }

    public String getString() {
        return (String)this.value;
    }

    @Override
    public void resolveConstant(ConstantPool pool) {
        if (this.type == 7 || this.type == 8 || this.type == 16 || this.type == 19 || this.type == 20) {
            this.value = pool.getPrimitiveConstant(this.index).getString();
            this.initConstant();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveConstant)) {
            return false;
        }
        PrimitiveConstant cn = (PrimitiveConstant)o;
        return this.type == cn.type && this.isArray == cn.isArray && this.value.equals(cn.value);
    }
}

