/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureStorage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.capture.org.objectweb.asm.ClassReader;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.ClassWriter;
import org.jetbrains.capture.org.objectweb.asm.FieldVisitor;
import org.jetbrains.capture.org.objectweb.asm.Label;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;
import org.jetbrains.capture.org.objectweb.asm.Type;

public final class CaptureAgent {
    private static Instrumentation ourInstrumentation;
    private static final Set<Class> mySkipped;
    private static final Map<String, List<InstrumentPoint>> myInstrumentPoints;
    private static final KeyProvider FIRST_PARAM;
    static final KeyProvider THIS_KEY_PROVIDER;
    public static final String CONSTRUCTOR = "<init>";

    public static void init(Properties properties, Instrumentation instrumentation) {
        ourInstrumentation = instrumentation;
        try {
            CaptureAgent.applyProperties(properties);
            for (Class aClass : instrumentation.getAllLoadedClasses()) {
                List<InstrumentPoint> points = myInstrumentPoints.get(Type.getInternalName(aClass));
                if (points == null) continue;
                for (InstrumentPoint point : points) {
                    if (point.myCapture) continue;
                    mySkipped.add(aClass);
                }
            }
            instrumentation.addTransformer(new CaptureTransformer(), true);
            CaptureAgent.setupJboss();
            if (CaptureStorage.DEBUG) {
                System.out.println("Capture agent: ready");
            }
        }
        catch (Throwable e) {
            System.err.println("Critical error in IDEA Async Stack Traces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
            e.printStackTrace();
        }
    }

    private static void setupJboss() {
        String modulesKey = "jboss.modules.system.pkgs";
        String property = System.getProperty(modulesKey, "");
        if (!property.isEmpty()) {
            property = property + ",";
        }
        property = property + "com.intellij.rt";
        System.setProperty(modulesKey, property);
    }

    private static void applyProperties(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("disabled", "false"))) {
            CaptureStorage.setEnabled(false);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            CaptureAgent.addPoint((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void invokeStorageMethod(MethodVisitor mv, String name) {
        Method method = null;
        for (Method m : CaptureStorage.class.getMethods()) {
            if (!name.equals(m.getName())) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new IllegalStateException("Unable to find Storage method " + name);
        }
        mv.visitMethodInsn(184, Type.getInternalName(CaptureStorage.class), name, Type.getMethodDescriptor(method), false);
    }

    public static void addCapturePoints(String capturePoints) throws UnmodifiableClassException, IOException {
        if (CaptureStorage.DEBUG) {
            System.out.println("Capture agent: adding points " + capturePoints);
        }
        Properties properties = new Properties();
        properties.load(new StringReader(capturePoints));
        HashSet<String> classNames = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            InstrumentPoint point = CaptureAgent.addPoint((String)entry.getKey(), (String)entry.getValue());
            if (point == null) continue;
            classNames.add(point.myClassName.replaceAll("/", "\\."));
        }
        ArrayList<Class> classes = new ArrayList<Class>(classNames.size());
        for (Class aClass : ourInstrumentation.getAllLoadedClasses()) {
            if (!classNames.contains(aClass.getName())) continue;
            classes.add(aClass);
        }
        if (!classes.isEmpty()) {
            if (CaptureStorage.DEBUG) {
                System.out.println("Capture agent: retransforming " + classes);
            }
            ourInstrumentation.retransformClasses(classes.toArray(new Class[0]));
        }
    }

    private static InstrumentPoint addPoint(String propertyKey, String propertyValue) {
        if (propertyKey.startsWith("capture")) {
            return CaptureAgent.addPoint(true, propertyValue);
        }
        if (propertyKey.startsWith("insert")) {
            return CaptureAgent.addPoint(false, propertyValue);
        }
        return null;
    }

    private static InstrumentPoint addPoint(boolean capture, String line) {
        String[] split = line.split(" ");
        KeyProvider keyProvider = CaptureAgent.createKeyProvider(Arrays.copyOfRange(split, 3, split.length));
        return CaptureAgent.addCapturePoint(capture, split[0], split[1], split[2], keyProvider);
    }

    private static InstrumentPoint addCapturePoint(boolean capture, String className, String methodName, String methodDesc, KeyProvider keyProvider) {
        List<InstrumentPoint> points = myInstrumentPoints.get(className);
        if (points == null) {
            points = new ArrayList<InstrumentPoint>(1);
            myInstrumentPoints.put(className, points);
        }
        InstrumentPoint point = new InstrumentPoint(capture, className, methodName, methodDesc, keyProvider);
        points.add(point);
        return point;
    }

    private static KeyProvider createKeyProvider(String[] line) {
        if ("this".equals(line[0])) {
            return THIS_KEY_PROVIDER;
        }
        if (CaptureAgent.isNumber(line[0])) {
            try {
                return new ParamKeyProvider(Integer.parseInt(line[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new FieldKeyProvider(line[0], line[1]);
    }

    private static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void addCapture(String className, String methodName, KeyProvider key) {
        CaptureAgent.addCapturePoint(true, className, methodName, "*", key);
    }

    private static void addInsert(String className, String methodName, KeyProvider key) {
        CaptureAgent.addCapturePoint(false, className, methodName, "*", key);
    }

    private static KeyProvider param(int idx) {
        return new ParamKeyProvider(idx);
    }

    static {
        mySkipped = new HashSet<Class>();
        myInstrumentPoints = new HashMap<String, List<InstrumentPoint>>();
        FIRST_PARAM = CaptureAgent.param(0);
        THIS_KEY_PROVIDER = new KeyProvider(){

            @Override
            public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
                if (isStatic) {
                    throw new IllegalStateException("This is not available in a static method " + methodDisplayName);
                }
                mv.visitVarInsn(25, 0);
            }
        };
        CaptureAgent.addCapture("java/awt/event/InvocationEvent", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/awt/event/InvocationEvent", "dispatch", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/lang/Thread", "start", THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/lang/Thread", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/FutureTask", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/FutureTask", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/FutureTask", "runAndReset", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/CompletableFuture$AsyncSupply", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/CompletableFuture$AsyncSupply", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/CompletableFuture$AsyncRun", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/CompletableFuture$AsyncRun", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/CompletableFuture$UniAccept", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/CompletableFuture$UniRun", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/CompletableFuture$UniRun", "tryFire", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("java/util/concurrent/ForkJoinTask", "fork", THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("java/util/concurrent/ForkJoinTask", "doExec", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", FIRST_PARAM);
        CaptureAgent.addInsert("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", FIRST_PARAM);
        CaptureAgent.addCapture("scala/concurrent/impl/Future$PromiseCompletingRunnable", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("scala/concurrent/impl/CallbackRunnable", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("scala/concurrent/impl/CallbackRunnable", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("scala/concurrent/impl/Promise$Transformation", CONSTRUCTOR, THIS_KEY_PROVIDER);
        CaptureAgent.addInsert("scala/concurrent/impl/Promise$Transformation", "run", THIS_KEY_PROVIDER);
        CaptureAgent.addCapture("akka/actor/ScalaActorRef", "$bang", FIRST_PARAM);
        CaptureAgent.addCapture("akka/actor/RepointableActorRef", "$bang", FIRST_PARAM);
        CaptureAgent.addCapture("akka/actor/LocalActorRef", "$bang", FIRST_PARAM);
        CaptureAgent.addCapture("akka/actor/ActorRef", "$bang", FIRST_PARAM);
        CaptureAgent.addInsert("akka/actor/Actor$class", "aroundReceive", CaptureAgent.param(2));
        CaptureAgent.addInsert("akka/actor/ActorCell", "receiveMessage", FIRST_PARAM);
        CaptureAgent.addCapture("com/sun/glass/ui/InvokeLaterDispatcher", "invokeLater", FIRST_PARAM);
        CaptureAgent.addInsert("com/sun/glass/ui/InvokeLaterDispatcher$Future", "run", new FieldKeyProvider("com/sun/glass/ui/InvokeLaterDispatcher$Future", "runnable"));
        if (Boolean.getBoolean("debugger.agent.enable.coroutines") && !Boolean.getBoolean("kotlinx.coroutines.debug.enable.creation.stack.trace")) {
            CaptureAgent.addCapture("kotlinx/coroutines/debug/internal/DebugProbesImpl$CoroutineOwner", CONSTRUCTOR, THIS_KEY_PROVIDER);
            CaptureAgent.addInsert("kotlin/coroutines/jvm/internal/BaseContinuationImpl", "resumeWith", new CoroutineOwnerKeyProvider());
        }
    }

    private static class ParamKeyProvider
    implements KeyProvider {
        private final int myIdx;

        ParamKeyProvider(int idx) {
            this.myIdx = idx;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
            int index;
            int n = index = isStatic ? 0 : 1;
            if (this.myIdx >= argumentTypes.length) {
                throw new IllegalStateException("Argument with id " + this.myIdx + " is not available, method " + methodDisplayName + " has only " + argumentTypes.length);
            }
            int sort = argumentTypes[this.myIdx].getSort();
            if (sort != 10 && sort != 9) {
                throw new IllegalStateException("Argument with id " + this.myIdx + " in method " + methodDisplayName + " must be an object");
            }
            for (int i = 0; i < this.myIdx; ++i) {
                index += argumentTypes[i].getSize();
            }
            mv.visitVarInsn(25, index);
        }
    }

    private static class CoroutineOwnerKeyProvider
    implements KeyProvider {
        private CoroutineOwnerKeyProvider() {
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
            mv.visitVarInsn(25, 0);
            CaptureAgent.invokeStorageMethod(mv, "coroutineOwner");
        }
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String myClassName;
        private final String myFieldName;

        FieldKeyProvider(String className, String fieldName) {
            this.myClassName = className;
            this.myFieldName = fieldName;
        }

        @Override
        public void loadKey(MethodVisitor mv, boolean isStatic, Type[] argumentTypes, String methodDisplayName, CaptureInstrumentor instrumentor) {
            String desc = (String)instrumentor.myFields.get(this.myFieldName);
            if (desc == null) {
                throw new IllegalStateException("Field " + this.myFieldName + " was not found");
            }
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.myClassName, this.myFieldName, desc);
        }
    }

    private static interface KeyProvider {
        public void loadKey(MethodVisitor var1, boolean var2, Type[] var3, String var4, CaptureInstrumentor var5);
    }

    private static class InstrumentPoint {
        static final String ANY_DESC = "*";
        final boolean myCapture;
        final String myClassName;
        final String myMethodName;
        final String myMethodDesc;
        final KeyProvider myKeyProvider;

        InstrumentPoint(boolean capture, String className, String methodName, String methodDesc, KeyProvider keyProvider) {
            this.myCapture = capture;
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodDesc = methodDesc;
            this.myKeyProvider = keyProvider;
        }

        boolean matchesMethod(String name, String desc) {
            if (!this.myMethodName.equals(name)) {
                return false;
            }
            return this.myMethodDesc.equals(ANY_DESC) || this.myMethodDesc.equals(desc);
        }
    }

    private static class CaptureInstrumentor
    extends ClassVisitor {
        private final List<? extends InstrumentPoint> myInstrumentPoints;
        private final Map<String, String> myFields = new HashMap<String, String>();
        private String mySuperName;
        private boolean myIsInterface;

        CaptureInstrumentor(int api, ClassVisitor cv, List<? extends InstrumentPoint> instrumentPoints) {
            super(api, cv);
            this.myInstrumentPoints = instrumentPoints;
        }

        private static String getNewName(String name) {
            return name + "$$$capture";
        }

        private static String getMethodDisplayName(String className, String methodName, String desc) {
            return className + "." + methodName + desc;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.mySuperName = superName;
            this.myIsInterface = (access & 0x200) != 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.myFields.put(name, desc);
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(final int access, String name, final String desc, String signature, String[] exceptions) {
            if ((access & 0x40) == 0) {
                for (final InstrumentPoint instrumentPoint : this.myInstrumentPoints) {
                    if (!instrumentPoint.matchesMethod(name, desc)) continue;
                    final String methodDisplayName = CaptureInstrumentor.getMethodDisplayName(instrumentPoint.myClassName, name, desc);
                    if (CaptureStorage.DEBUG) {
                        System.out.println("Capture agent: instrumented " + (instrumentPoint.myCapture ? "capture" : "insert") + " point at " + methodDisplayName);
                    }
                    if (instrumentPoint.myCapture) {
                        if (CaptureAgent.CONSTRUCTOR.equals(name) && instrumentPoint.myKeyProvider == THIS_KEY_PROVIDER) {
                            return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){
                                boolean captured;
                                {
                                    super(arg0, arg1);
                                    this.captured = false;
                                }

                                @Override
                                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                                    if (opcode == 183 && !this.captured && owner.equals(CaptureInstrumentor.this.mySuperName) && name.equals(CaptureAgent.CONSTRUCTOR)) {
                                        CaptureInstrumentor.this.capture(this.mv, instrumentPoint.myKeyProvider, (access & 8) != 0, Type.getMethodType(desc).getArgumentTypes(), methodDisplayName);
                                        this.captured = true;
                                    }
                                }
                            };
                        }
                        return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                            @Override
                            public void visitCode() {
                                CaptureInstrumentor.this.capture(this.mv, instrumentPoint.myKeyProvider, (access & 8) != 0, Type.getMethodType(desc).getArgumentTypes(), methodDisplayName);
                                super.visitCode();
                            }
                        };
                    }
                    if (CaptureAgent.CONSTRUCTOR.equals(name)) {
                        throw new IllegalStateException("Unable to create insert point at " + methodDisplayName + ". Constructors are not yet supported.");
                    }
                    this.generateWrapper(access, name, desc, signature, exceptions, instrumentPoint, methodDisplayName);
                    return super.visitMethod(access, CaptureInstrumentor.getNewName(name), desc, signature, exceptions);
                }
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private void generateWrapper(int access, String name, String desc, String signature, String[] exceptions, InstrumentPoint insertPoint, String methodDisplayName) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Label start = new Label();
            mv.visitLabel(start);
            boolean isStatic = (access & 8) != 0;
            Type[] argumentTypes = Type.getMethodType(desc).getArgumentTypes();
            this.insertEnter(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitVarInsn(25, 0);
            int index = isStatic ? 0 : 1;
            for (Type t : argumentTypes) {
                mv.visitVarInsn(t.getOpcode(21), index);
                index += t.getSize();
            }
            mv.visitMethodInsn(isStatic ? 184 : 183, insertPoint.myClassName, CaptureInstrumentor.getNewName(insertPoint.myMethodName), desc, this.myIsInterface);
            Label end = new Label();
            mv.visitLabel(end);
            this.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(Type.getReturnType(desc).getOpcode(172));
            Label catchLabel = new Label();
            mv.visitLabel(catchLabel);
            mv.visitTryCatchBlock(start, end, catchLabel, null);
            this.insertExit(mv, insertPoint.myKeyProvider, isStatic, argumentTypes, methodDisplayName);
            mv.visitInsn(191);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void capture(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "capture", methodDisplayName);
        }

        private void insertEnter(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertEnter", methodDisplayName);
        }

        private void insertExit(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String methodDisplayName) {
            this.storageCall(mv, keyProvider, isStatic, argumentTypes, "insertExit", methodDisplayName);
        }

        private void storageCall(MethodVisitor mv, KeyProvider keyProvider, boolean isStatic, Type[] argumentTypes, String storageMethodName, String methodDisplayName) {
            keyProvider.loadKey(mv, isStatic, argumentTypes, methodDisplayName, this);
            CaptureAgent.invokeStorageMethod(mv, storageMethodName);
        }
    }

    private static class CaptureTransformer
    implements ClassFileTransformer {
        private CaptureTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            List classPoints;
            if (!(className == null || classBeingRedefined != null && mySkipped.contains(classBeingRedefined) || (classPoints = (List)myInstrumentPoints.get(className)) == null)) {
                try {
                    ClassReader reader = new ClassReader(classfileBuffer);
                    ClassWriter writer = new ClassWriter(reader, 2);
                    reader.accept(new CaptureInstrumentor(589824, writer, classPoints), 0);
                    byte[] bytes = writer.toByteArray();
                    if (CaptureStorage.DEBUG) {
                        try (FileOutputStream stream = new FileOutputStream("instrumented_" + className.replaceAll("/", "_") + ".class");){
                            stream.write(bytes);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return bytes;
                }
                catch (Exception e) {
                    System.out.println("Capture agent: failed to instrument " + className);
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

