/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = JBColor.namedColor((String)"VersionControl.Log.Commit.currentBranchBackground", (Color)new JBColor(new Color(228, 250, 255), new Color(63, 71, 73)));
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final Map<VirtualFile, Boolean> myIsHighlighted;

    CurrentBranchHighlighter(@NotNull VcsLogData logData) {
        if (logData == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(0);
        }
        this.myIsHighlighted = new HashMap<VirtualFile, Boolean>();
        this.myLogData = logData;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId2, @NotNull VcsShortCommitDetails details, int column, boolean isSelected) {
        if (details == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(1);
        }
        if (isSelected) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(2);
            }
            return vcsCommitStyle;
        }
        if (!this.myIsHighlighted.getOrDefault(details.getRoot(), false).booleanValue()) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(3);
            }
            return vcsCommitStyle;
        }
        Predicate<Integer> condition = this.myLogData.getContainingBranchesGetter().getContainedInCurrentBranchCondition(details.getRoot());
        if (condition.test(commitId2)) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
            if (vcsCommitStyle == null) {
                CurrentBranchHighlighter.$$$reportNull$$$0(4);
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(5);
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            CurrentBranchHighlighter.$$$reportNull$$$0(6);
        }
        String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch(dataPack.getFilters(), dataPack.getRefs());
        this.myIsHighlighted.clear();
        boolean isHeadFilter = "HEAD".equals(singleFilteredBranch);
        for (VirtualFile root : dataPack.getLogProviders().keySet()) {
            String currentBranch = ((VcsLogProvider)dataPack.getLogProviders().get(root)).getCurrentBranch(root);
            this.myIsHighlighted.put(root, !isHeadFilter && currentBranch != null && !currentBranch.equals(singleFilteredBranch));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NonNls
        @NotNull
        public static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            if (logData == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (logUi2 == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new CurrentBranchHighlighter(logData);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsLogBundle.message("vcs.log.action.highlight.current.branch", new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logUi";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/CurrentBranchHighlighter$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

