/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryColorManager;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.CurrentBranchHighlighter;
import com.intellij.vcs.log.ui.highlighters.MyCommitsHighlighter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root, @NotNull String logId, @NotNull VcsLogFilterCollection initialFilters, @NotNull VcsLogDiffHandler vcsLogDiffHandler) {
        if (logData == null) {
            FileHistoryUi.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(1);
        }
        if (refresher == null) {
            FileHistoryUi.$$$reportNull$$$0(2);
        }
        if (path == null) {
            FileHistoryUi.$$$reportNull$$$0(3);
        }
        if (root == null) {
            FileHistoryUi.$$$reportNull$$$0(4);
        }
        if (logId == null) {
            FileHistoryUi.$$$reportNull$$$0(5);
        }
        if (initialFilters == null) {
            FileHistoryUi.$$$reportNull$$$0(6);
        }
        if (vcsLogDiffHandler == null) {
            FileHistoryUi.$$$reportNull$$$0(7);
        }
        super(logId, logData, new FileHistoryColorManager(root, path), refresher);
        assert (!path.isDirectory());
        this.myPath = path;
        this.myRevision = revision;
        this.myUiProperties = uiProperties;
        this.myFileHistoryModel = new FileHistoryModel(logData, vcsLogDiffHandler, root){

            @Override
            @NotNull
            protected VisiblePack getVisiblePack() {
                VisiblePack visiblePack = FileHistoryUi.this.myVisiblePack;
                if (visiblePack == null) {
                    1.$$$reportNull$$$0(0);
                }
                return visiblePack;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryUi$1", "getVisiblePack"));
            }
        };
        this.myFilterUi = new FileHistoryFilterUi(path, revision, root, uiProperties, logData, initialFilters, filters -> refresher.onFiltersChange((VcsLogFilterCollection)filters));
        this.myFileHistoryPanel = new FileHistoryPanel(this, this.myFileHistoryModel, this.myFilterUi, logData, path, root, this.myColorManager, this);
        this.getTable().addHighlighter(((MyCommitsHighlighter.Factory)LOG_HIGHLIGHTER_FACTORY_EP.findExtensionOrFail(MyCommitsHighlighter.Factory.class)).createHighlighter(this.getLogData(), this));
        if (this.myRevision != null) {
            this.getTable().addHighlighter(new RevisionHistoryHighlighter(this.myLogData.getStorage(), this.myRevision, root));
        } else {
            this.getTable().addHighlighter(((CurrentBranchHighlighter.Factory)LOG_HIGHLIGHTER_FACTORY_EP.findExtensionOrFail(CurrentBranchHighlighter.Factory.class)).createHighlighter(this.getLogData(), this));
        }
        this.myUiProperties.addChangeListener(new MyPropertiesChangeListener(), this);
    }

    @NotNull
    public static String getFileHistoryLogId(@NotNull FilePath path, @Nullable Hash revision) {
        if (path == null) {
            FileHistoryUi.$$$reportNull$$$0(8);
        }
        String string = path.getPath() + (String)(revision == null ? "" : ":" + revision.asString());
        if (string == null) {
            FileHistoryUi.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            FileHistoryUi.$$$reportNull$$$0(10);
        }
        super.setVisiblePack(pack);
        this.myFilterUi.setVisiblePack(pack);
        if (pack.canRequestMore()) {
            this.requestMore(EmptyRunnable.INSTANCE);
        }
    }

    @Deprecated
    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (hash == null) {
            FileHistoryUi.$$$reportNull$$$0(11);
        }
        return this.myFileHistoryModel.getPathInCommit(hash);
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId2, boolean commitExists, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId2 == null) {
            FileHistoryUi.$$$reportNull$$$0(12);
        }
        if (rowGetter == null) {
            FileHistoryUi.$$$reportNull$$$0(13);
        }
        if (!commitExists) {
            super.handleCommitNotFound(commitId2, false, rowGetter);
            return;
        }
        boolean hasBranchFilter = this.getFilterUi().hasBranchFilter();
        String text = VcsLogBundle.message(hasBranchFilter ? "file.history.commit.not.found.in.branch" : "file.history.commit.not.found", FileHistoryUi.getCommitPresentation(commitId2), this.myPath.getName());
        ArrayList<NotificationAction> actions2 = new ArrayList<NotificationAction>();
        if (hasBranchFilter && this.getFilterUi().isBranchFilterEnabled()) {
            actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("file.history.commit.not.found.view.and.show.all.branches.link", new Object[0]), () -> {
                this.getFilterUi().clearFilters();
                VcsLogUtil.invokeOnChange(this, () -> this.jumpTo(commitId2, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true));
            }));
        }
        actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("file.history.commit.not.found.view.in.log.link", new Object[0]), () -> VcsLogContentUtil.runInMainLog(this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> ui2.jumpTo(commitId2, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true)))));
        VcsNotifier.getInstance((Project)this.myProject).notifyWarning("vcs.log.commit.not.found", "", text, (NotificationAction[])actions2.toArray(NotificationAction[]::new));
    }

    public boolean matches(@NotNull FilePath targetPath, @Nullable Hash targetRevision) {
        if (targetPath == null) {
            FileHistoryUi.$$$reportNull$$$0(14);
        }
        return this.myPath.equals(targetPath) && Objects.equals(this.myRevision, targetRevision);
    }

    @NotNull
    public FileHistoryFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            FileHistoryUi.$$$reportNull$$$0(15);
        }
        return fileHistoryFilterUi;
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        ((FileHistoryColorManager)this.myColorManager).update(this.myVisiblePack);
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myFileHistoryPanel.getGraphTable().rootColumnUpdated();
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            FileHistoryUi.$$$reportNull$$$0(16);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        FileHistoryPanel fileHistoryPanel = this.myFileHistoryPanel;
        if (fileHistoryPanel == null) {
            FileHistoryUi.$$$reportNull$$$0(17);
        }
        return fileHistoryPanel;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myFileHistoryPanel.getToolbar();
        if (jComponent == null) {
            FileHistoryUi.$$$reportNull$$$0(18);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(19);
        }
        return fileHistoryUiProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialFilters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsLogDiffHandler";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileHistoryLogId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileHistoryLogId";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathInCommit";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static class RevisionHistoryHighlighter
    implements VcsLogHighlighter {
        @NotNull
        private final JBColor myBgColor;
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Hash myRevision;
        @NotNull
        private final VirtualFile myRoot;
        private Predicate<Integer> myCondition;
        @NotNull
        private VcsLogDataPack myVisiblePack;

        RevisionHistoryHighlighter(@NotNull VcsLogStorage storage, @NotNull Hash revision, @NotNull VirtualFile root) {
            if (storage == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(1);
            }
            if (root == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(2);
            }
            this.myBgColor = JBColor.namedColor((String)"VersionControl.FileHistory.Commit.selectedBranchBackground", (Color)new JBColor(new Color(0xFFFEE4), new Color(4802879)));
            this.myVisiblePack = VisiblePack.EMPTY;
            this.myStorage = storage;
            this.myRevision = revision;
            this.myRoot = root;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId2, @NotNull VcsShortCommitDetails commitDetails, int column, boolean isSelected) {
            if (commitDetails == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(3);
            }
            if (isSelected) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(4);
                }
                return vcsCommitStyle;
            }
            if (this.myCondition == null) {
                this.myCondition = this.getCondition();
            }
            if (this.myCondition.test(commitId2)) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)this.myBgColor);
                if (vcsCommitStyle == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(5);
                }
                return vcsCommitStyle;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(6);
            }
            return vcsCommitStyle;
        }

        @NotNull
        private Predicate<Integer> getCondition() {
            if (!(this.myVisiblePack instanceof VisiblePack)) {
                Predicate predicate = Predicates.alwaysFalse();
                if (predicate == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(7);
                }
                return predicate;
            }
            DataPackBase dataPack = ((VisiblePack)this.myVisiblePack).getDataPack();
            if (!(dataPack instanceof DataPack)) {
                Predicate predicate = Predicates.alwaysFalse();
                if (predicate == null) {
                    RevisionHistoryHighlighter.$$$reportNull$$$0(8);
                }
                return predicate;
            }
            Set<Integer> heads = Collections.singleton(this.myStorage.getCommitIndex(this.myRevision, this.myRoot));
            Predicate predicate = ((DataPack)dataPack).getPermanentGraph().getContainedInBranchCondition(heads);
            if (predicate == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(9);
            }
            return predicate;
        }

        public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
            if (dataPack == null) {
                RevisionHistoryHighlighter.$$$reportNull$$$0(10);
            }
            this.myVisiblePack = dataPack;
            this.myCondition = this.myVisiblePack.getFilters().get(VcsLogFilterCollection.REVISION_FILTER) != null ? Predicates.alwaysFalse() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitDetails";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi$RevisionHistoryHighlighter";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyle";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStyle";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyPropertiesChangeListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (CommonUiProperties.COLUMN_ID_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof TableColumnWidthProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((TableColumnWidthProperty)property).getColumn());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
        }
    }
}

