/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.dialog;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/ui/dialog/GithubUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "getData", "", "dataId", "getDimensionServiceKey", "intellij.vcs.github"})
public final class GithubUntrackedFilesDialog
extends SelectFilesDialog
implements DataProvider {
    @NotNull
    private final Project myProject;
    @Nullable
    private CommitMessage myCommitMessagePanel;

    public GithubUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter(untrackedFiles, (String)"untrackedFiles");
        super(myProject, untrackedFiles, null, null, true, false);
        this.myProject = myProject;
        this.setTitle(GithubBundle.message("untracked.files.dialog.title", new Object[0]));
        this.setOKButtonText(CommonBundle.getAddButtonText());
        this.setCancelButtonText(CommonBundle.getCancelButtonText());
        this.init();
    }

    @NotNull
    public final String getCommitMessage() {
        CommitMessage commitMessage = this.myCommitMessagePanel;
        Intrinsics.checkNotNull((Object)commitMessage);
        String string = commitMessage.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        return string;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent tree = super.createCenterPanel();
        CommitMessage commitMessage = new CommitMessage(this.myProject);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)commitMessage));
        commitMessage.setCommitMessage("Initial commit");
        this.myCommitMessagePanel = commitMessage;
        Splitter splitter = new Splitter(true);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(tree);
        splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
        splitter.setProportion(0.7f);
        return (JComponent)splitter;
    }

    @Nullable
    public Object getData(@NonNls @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId) ? this.myCommitMessagePanel : null;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.UntrackedFilesDialog";
    }
}

