/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.OnEnterRule;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesRegistryImpl
implements PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = new HashSet<Preferences>();
    @NotNull
    private final IntSet myLeftHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myLeftSmartTypingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightSmartTypingBraces = new IntOpenHashSet();

    public PreferencesRegistryImpl() {
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    public synchronized void addPreferences(Preferences preferences) {
        this.fillHighlightingBraces(preferences.getHighlightingPairs());
        this.fillSmartTypingBraces(preferences.getSmartTypingPairs());
        this.myPreferences.add(preferences);
    }

    @Deprecated(forRemoval=true)
    public synchronized void fillFromPList(@NotNull CharSequence scopeName, @NotNull Plist plist2) {
        if (scopeName == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(0);
        }
        if (plist2 == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(1);
        }
        Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(plist2.getPlistValue("highlightPairs"));
        Set<TextMateBracePair> rawSmartTypingPairs = PreferencesReadUtil.readPairs(plist2.getPlistValue("smartTypingPairs"));
        Set<TextMateAutoClosingPair> smartTypingPairs = rawSmartTypingPairs != null ? rawSmartTypingPairs.stream().map(p -> new TextMateAutoClosingPair(p.getLeft(), p.getRight(), null)).collect(Collectors.toSet()) : null;
        IndentationRules indentationRules = PreferencesReadUtil.loadIndentationRules(plist2);
        Set<OnEnterRule> onEnterRules = Collections.emptySet();
        this.fillHighlightingBraces(highlightingPairs);
        this.fillSmartTypingBraces(smartTypingPairs);
        if (highlightingPairs != null || smartTypingPairs != null || !indentationRules.isEmpty().booleanValue()) {
            this.myPreferences.add(new Preferences(scopeName, highlightingPairs, smartTypingPairs, Collections.emptySet(), null, indentationRules, onEnterRules));
        }
    }

    private synchronized void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                if (!pair.getLeft().isEmpty()) {
                    this.myLeftHighlightingBraces.add((int)pair.getLeft().charAt(0));
                }
                if (pair.getRight().isEmpty()) continue;
                this.myRightHighlightingBraces.add((int)pair.getRight().charAt(pair.getRight().length() - 1));
            }
        }
    }

    private void fillSmartTypingBraces(Collection<TextMateAutoClosingPair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateAutoClosingPair pair : smartTypingPairs) {
                if (!pair.getLeft().isEmpty()) {
                    this.myLeftSmartTypingBraces.add((int)pair.getLeft().charAt(pair.getLeft().length() - 1));
                }
                if (pair.getRight().isEmpty()) continue;
                this.myRightSmartTypingBraces.add((int)pair.getRight().charAt(pair.getRight().length() - 1));
            }
        }
    }

    @Override
    public synchronized boolean isPossibleLeftHighlightingBrace(char firstLeftBraceChar) {
        return this.myLeftHighlightingBraces.contains((int)firstLeftBraceChar) || firstLeftBraceChar != ' ' && this.myLeftSmartTypingBraces.contains((int)firstLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightHighlightingBrace(char lastRightBraceChar) {
        return this.myRightHighlightingBraces.contains((int)lastRightBraceChar) || lastRightBraceChar != ' ' && this.myRightSmartTypingBraces.contains((int)lastRightBraceChar);
    }

    @Override
    public synchronized boolean isPossibleLeftSmartTypingBrace(char lastLeftBraceChar) {
        return this.myLeftSmartTypingBraces.contains((int)lastLeftBraceChar);
    }

    @Override
    public synchronized boolean isPossibleRightSmartTypingBrace(char lastRightBraceChar) {
        return this.myRightSmartTypingBraces.contains((int)lastRightBraceChar);
    }

    @Override
    @NotNull
    public synchronized List<Preferences> getPreferences(@NotNull TextMateScope scope) {
        if (scope == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(2);
        }
        List<Preferences> list = new TextMateScopeComparator<Preferences>(scope, Preferences::getScopeSelector).sortAndFilter(this.myPreferences);
        if (list == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public synchronized void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillFromPList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

