/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateBundleToLoad;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.TextMateServiceImplKt;
import org.jetbrains.plugins.textmate.configuration.TextMateBuiltinBundlesSettings;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001d\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"bundledBundlePath", "Ljava/nio/file/Path;", "getBundledBundlePath", "()Ljava/nio/file/Path;", "discoverBuiltinBundles", "", "Lorg/jetbrains/plugins/textmate/TextMateBundleToLoad;", "builtinBundlesSettings", "Lorg/jetbrains/plugins/textmate/configuration/TextMateBuiltinBundlesSettings;", "fireFileTypesChangedEvent", "", "reason", "", "Lorg/jetbrains/annotations/NonNls;", "update", "Ljava/lang/Runnable;", "intellij.textmate"})
public final class TextMateServiceImplKt {
    private static final Path getBundledBundlePath() {
        Path path = PluginPathManager.getPluginHome((String)"textmate").toPath().resolve("lib/bundles").normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }

    private static final void fireFileTypesChangedEvent(String reason, Runnable update) {
        ApplicationManager.getApplication().invokeLater(() -> TextMateServiceImplKt.fireFileTypesChangedEvent$lambda$1(reason, update), ModalityState.nonModal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<TextMateBundleToLoad> discoverBuiltinBundles(@NotNull TextMateBuiltinBundlesSettings builtinBundlesSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)builtinBundlesSettings), (String)"builtinBundlesSettings");
        List<TextMateBundleToLoad> builtinBundles = builtinBundlesSettings.getBuiltinBundles();
        if (!((Collection)builtinBundles).isEmpty()) {
            return builtinBundles;
        }
        Path builtinBundlesPath = TextMateServiceImplKt.getBundledBundlePath();
        try {
            AutoCloseable autoCloseable = Files.list(builtinBundlesPath);
            Throwable throwable = null;
            try {
                Stream files = (Stream)autoCloseable;
                boolean bl = false;
                List<TextMateBundleToLoad> bundles2 = files.filter(arg_0 -> TextMateServiceImplKt.discoverBuiltinBundles$lambda$4$lambda$2(discoverBuiltinBundles.1.bundles.1.INSTANCE, arg_0)).map(arg_0 -> TextMateServiceImplKt.discoverBuiltinBundles$lambda$4$lambda$3(discoverBuiltinBundles.1.bundles.2.INSTANCE, arg_0)).toList();
                Intrinsics.checkNotNull(bundles2);
                builtinBundlesSettings.setBuiltinBundles(bundles2);
                List<TextMateBundleToLoad> list = bundles2;
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            TextMateService.LOG.warn("Couldn't list builtin textmate bundles at " + builtinBundlesPath, e);
            return CollectionsKt.emptyList();
        }
    }

    private static final void fireFileTypesChangedEvent$lambda$1$lambda$0(String $reason, Runnable $update) {
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        Intrinsics.checkNotNullParameter((Object)$update, (String)"$update");
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Intrinsics.checkNotNull((Object)fileTypeManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl");
        FileTypeManagerImpl fileTypeManager2 = (FileTypeManagerImpl)fileTypeManager;
        fileTypeManager2.makeFileTypesChange($reason, $update);
    }

    private static final void fireFileTypesChangedEvent$lambda$1(String $reason, Runnable $update) {
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        Intrinsics.checkNotNullParameter((Object)$update, (String)"$update");
        ApplicationManager.getApplication().runWriteAction(() -> TextMateServiceImplKt.fireFileTypesChangedEvent$lambda$1$lambda$0($reason, $update));
    }

    private static final boolean discoverBuiltinBundles$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TextMateBundleToLoad discoverBuiltinBundles$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TextMateBundleToLoad)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$fireFileTypesChangedEvent(String reason, Runnable update) {
        TextMateServiceImplKt.fireFileTypesChangedEvent(reason, update);
    }
}

