/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.testIntegration;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassActionBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GroovyTestGenerator
implements TestGenerator {
    @Nullable
    public PsiElement generateTest(Project project, CreateTestDialog d) {
        return (PsiElement)WriteAction.compute(() -> {
            PsiClass test = (PsiClass)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> {
                try {
                    IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                    GrTypeDefinition targetClass = CreateClassActionBase.createClassByType(d.getTargetDirectory(), d.getClassName(), PsiManager.getInstance((Project)project), null, "Groovy Class.groovy", true);
                    if (targetClass == null) {
                        return null;
                    }
                    GroovyTestGenerator.addSuperClass(targetClass, project, d.getSuperClassName());
                    Editor editor = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiClass)targetClass);
                    GroovyTestGenerator.addTestMethods(editor, targetClass, d.getSelectedTestFrameworkDescriptor(), d.getSelectedMethods(), d.shouldGeneratedBefore(), d.shouldGeneratedAfter());
                    return targetClass;
                }
                catch (IncorrectOperationException e1) {
                    GroovyTestGenerator.showErrorLater(project, d.getClassName());
                    return null;
                }
            });
            if (test == null) {
                return null;
            }
            JavaCodeStyleManager.getInstance((Project)test.getProject()).shortenClassReferences((PsiElement)test);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)test);
            return test;
        });
    }

    public String toString() {
        return GroovyBundle.message("language.groovy", new Object[0]);
    }

    private static void addSuperClass(@NotNull GrTypeDefinition targetClass, @NotNull Project project, @Nullable String superClassName) throws IncorrectOperationException {
        if (targetClass == null) {
            GroovyTestGenerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GroovyTestGenerator.$$$reportNull$$$0(1);
        }
        if (superClassName == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiClass superClass = GroovyTestGenerator.findClass(project, superClassName);
        GrCodeReferenceElement superClassRef = superClass != null ? factory.createCodeReferenceElementFromClass(superClass) : factory.createCodeReference(superClassName);
        GrExtendsClause extendsClause = targetClass.getExtendsClause();
        if (extendsClause == null) {
            extendsClause = (GrExtendsClause)targetClass.addAfter(factory.createExtendsClause(), targetClass.getNameIdentifierGroovy());
        }
        extendsClause.add(superClassRef);
    }

    @Nullable
    private static PsiClass findClass(Project project, String fqName) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope);
    }

    private static void addTestMethods(Editor editor, PsiClass targetClass, TestFramework descriptor2, Collection<? extends MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        HashSet existingNames = new HashSet();
        if (generateBefore) {
            GroovyTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.SET_UP, descriptor2, targetClass, editor, null, existingNames);
        }
        if (generateAfter) {
            GroovyTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEAR_DOWN, descriptor2, targetClass, editor, null, existingNames);
        }
        for (MemberInfo memberInfo : methods) {
            GroovyTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEST, descriptor2, targetClass, editor, ((PsiMember)memberInfo.getMember()).getName(), existingNames);
        }
    }

    private static void showErrorLater(Project project, String targetClassName) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)JavaBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{targetClassName}), (String)JavaBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
    }

    private static void generateMethod(@NotNull TestIntegrationUtils.MethodKind methodKind, TestFramework descriptor2, PsiClass targetClass, Editor editor, @Nullable String name, Set<? super String> existingNames) {
        if (methodKind == null) {
            GroovyTestGenerator.$$$reportNull$$$0(2);
        }
        GroovyPsiElementFactory f = GroovyPsiElementFactory.getInstance(targetClass.getProject());
        PsiMethod method = (PsiMethod)targetClass.add((PsiElement)f.createMethod("dummy", (PsiType)PsiTypes.voidType()));
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TestIntegrationUtils.runTestMethodTemplate((TestIntegrationUtils.MethodKind)methodKind, (TestFramework)descriptor2, (Editor)editor, (PsiClass)targetClass, (PsiMethod)method, (String)name, (boolean)true, existingNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodKind";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/testIntegration/GroovyTestGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addSuperClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

