/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrFieldNameSuggester;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyFieldValidator;
import org.jetbrains.plugins.groovy.refactoring.ui.GrTypeComboBox;

public class GrIntroduceFieldDialog
extends DialogWrapper
implements GrIntroduceDialog<GrIntroduceFieldSettings>,
GrIntroduceFieldSettings {
    private JPanel myContentPane;
    private NameSuggestionsField myNameField;
    private JRadioButton myPrivateRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myPropertyRadioButton;
    private JRadioButton myCurrentMethodRadioButton;
    private JRadioButton myFieldDeclarationRadioButton;
    private JRadioButton myClassConstructorSRadioButton;
    private JBRadioButton mySetUpMethodRadioButton;
    private JCheckBox myDeclareFinalCheckBox;
    private JCheckBox myReplaceAllOccurrencesCheckBox;
    private GrTypeComboBox myTypeComboBox;
    private JLabel myNameLabel;
    private JLabel myTypeLabel;
    private final boolean myIsStatic;
    private final boolean isInvokedInAlwaysInvokedConstructor;
    private final boolean hasLHSUsages;
    private final String myInvokedOnLocalVar;
    private final boolean myCanBeInitializedOutsideBlock;
    private final GrIntroduceContext myContext;

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public GrIntroduceFieldDialog(GrIntroduceContext context) {
        super(context.getProject(), true);
        this.myContext = context;
        this.$$$setupUI$$$();
        PsiClass clazz = (PsiClass)context.getScope();
        PsiClass scope = clazz instanceof GroovyScriptClass ? clazz.getContainingFile() : clazz;
        this.myIsStatic = GrIntroduceFieldHandler.shouldBeStatic(context.getPlace(), (PsiElement)scope);
        this.initVisibility();
        ButtonGroup initialization = new ButtonGroup();
        ArrayList<JRadioButton> inits = new ArrayList<JRadioButton>();
        inits.add(this.myCurrentMethodRadioButton);
        inits.add(this.myFieldDeclarationRadioButton);
        inits.add(this.myClassConstructorSRadioButton);
        if (TestFrameworks.getInstance().isTestClass(clazz)) {
            inits.add((JRadioButton)this.mySetUpMethodRadioButton);
        } else {
            this.mySetUpMethodRadioButton.setVisible(false);
        }
        for (JRadioButton init : inits) {
            initialization.add(init);
        }
        RadioUpDownListener.installOn((JRadioButton[])inits.toArray(new JRadioButton[0]));
        if (clazz instanceof GroovyScriptClass) {
            this.myClassConstructorSRadioButton.setEnabled(false);
        }
        this.myCanBeInitializedOutsideBlock = GrIntroduceFieldDialog.canBeInitializedOutsideBlock(context, clazz);
        GrMember container = GrIntroduceFieldHandler.getContainer(context.getPlace(), (PsiElement)scope);
        if (container == null) {
            this.myCurrentMethodRadioButton.setEnabled(false);
        }
        if (this.myCurrentMethodRadioButton.isEnabled()) {
            this.myCurrentMethodRadioButton.setSelected(true);
        } else {
            this.myFieldDeclarationRadioButton.setSelected(true);
        }
        String string = this.myInvokedOnLocalVar = context.getVar() == null ? GrIntroduceFieldDialog.getInvokedOnLocalVar(context.getExpression()) : context.getVar().getName();
        if (this.myInvokedOnLocalVar != null) {
            this.myReplaceAllOccurrencesCheckBox.setText(GroovyBundle.message("replace.all.occurrences.and.remove.variable.0", this.myInvokedOnLocalVar));
            if (context.getVar() != null) {
                this.myReplaceAllOccurrencesCheckBox.setEnabled(false);
                this.myReplaceAllOccurrencesCheckBox.setSelected(true);
            }
        } else if (context.getOccurrences().length == 1) {
            this.myReplaceAllOccurrencesCheckBox.setSelected(false);
            this.myReplaceAllOccurrencesCheckBox.setVisible(false);
        }
        this.myNameField.addDataChangedListener(() -> this.validateOKAction());
        ItemListener l = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GrIntroduceFieldDialog.this.myNameField.requestFocusInWindow();
                GrIntroduceFieldDialog.this.checkErrors();
                if (GrIntroduceFieldDialog.this.myReplaceAllOccurrencesCheckBox.isSelected()) {
                    PsiElement anchor = GrIntroduceHandlerBase.findAnchor(GrIntroduceFieldDialog.this.myContext.getOccurrences(), GrIntroduceFieldDialog.this.myContext.getScope());
                    if (anchor != null && anchor != GrIntroduceFieldDialog.this.myContext.getScope() && anchor != ((GrTypeDefinition)GrIntroduceFieldDialog.this.myContext.getScope()).getBody()) {
                        GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(true);
                    } else if (GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.isEnabled()) {
                        GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(false);
                        GrIntroduceFieldDialog.this.myFieldDeclarationRadioButton.setSelected(true);
                    }
                } else if (!GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.isEnabled()) {
                    GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(true);
                }
            }
        };
        this.myPrivateRadioButton.addItemListener(l);
        this.myProtectedRadioButton.addItemListener(l);
        this.myPublicRadioButton.addItemListener(l);
        this.myPropertyRadioButton.addItemListener(l);
        this.myCurrentMethodRadioButton.addItemListener(l);
        this.myFieldDeclarationRadioButton.addItemListener(l);
        this.myClassConstructorSRadioButton.addItemListener(l);
        this.myDeclareFinalCheckBox.addItemListener(l);
        this.myReplaceAllOccurrencesCheckBox.addItemListener(l);
        this.myTypeComboBox.addItemListener(l);
        this.isInvokedInAlwaysInvokedConstructor = container instanceof PsiMethod && GrIntroduceFieldDialog.allOccurrencesInOneMethod(this.myContext.getOccurrences(), (PsiElement)scope) && GrIntroduceFieldDialog.isAlwaysInvokedConstructor((PsiMethod)container, clazz);
        this.hasLHSUsages = GrIntroduceFieldDialog.hasLhsUsages(this.myContext);
        this.setTitle(IntroduceFieldHandler.getRefactoringNameText());
        this.init();
        this.checkErrors();
    }

    private void checkErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.myCurrentMethodRadioButton.isSelected() && this.myDeclareFinalCheckBox.isSelected() && !this.isInvokedInAlwaysInvokedConstructor) {
            errors.add(GroovyRefactoringBundle.message("final.field.cant.be.initialized.in.cur.method", new Object[0]));
        }
        if (this.myDeclareFinalCheckBox.isSelected() && this.myReplaceAllOccurrencesCheckBox.isSelected() && this.myInvokedOnLocalVar != null && this.hasLHSUsages) {
            errors.add(GroovyRefactoringBundle.message("Field.cannot.be.final.because.replaced.variable.has.lhs.usages", new Object[0]));
        }
        if (!this.myCanBeInitializedOutsideBlock) {
            if (this.myFieldDeclarationRadioButton.isSelected()) {
                errors.add(GroovyRefactoringBundle.message("field.cannot.be.initialized.in.field.declaration", new Object[0]));
            } else if (this.myClassConstructorSRadioButton.isSelected()) {
                errors.add(GroovyRefactoringBundle.message("field.cannot.be.initialized.in.constructor(s)", new Object[0]));
            }
        }
        if (errors.isEmpty()) {
            this.setErrorText(null);
        } else {
            this.setErrorText(GrIntroduceFieldDialog.errorString(errors));
        }
    }

    @NlsSafe
    @NotNull
    private static String errorString(List<String> errors) {
        String string = StringUtil.join(errors, (String)"\n");
        if (string == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static boolean hasLhsUsages(@NotNull GrIntroduceContext context) {
        if (context == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(1);
        }
        if (context.getVar() == null && !(context.getExpression() instanceof GrReferenceExpression)) {
            return false;
        }
        return GrIntroduceHandlerBase.hasLhs(context.getOccurrences());
    }

    private void initVisibility() {
        ButtonGroup visibility = new ButtonGroup();
        visibility.add(this.myPrivateRadioButton);
        visibility.add(this.myProtectedRadioButton);
        visibility.add(this.myPublicRadioButton);
        visibility.add(this.myPropertyRadioButton);
        if (this.myContext.getScope() instanceof GroovyScriptClass) {
            this.myPropertyRadioButton.setSelected(true);
            this.myPrivateRadioButton.setEnabled(false);
            this.myProtectedRadioButton.setEnabled(false);
            this.myPublicRadioButton.setEnabled(false);
            this.myPropertyRadioButton.setEnabled(false);
        } else {
            this.myPrivateRadioButton.setSelected(true);
        }
        RadioUpDownListener.installOn((JRadioButton[])new JRadioButton[]{this.myPrivateRadioButton, this.myProtectedRadioButton, this.myPublicRadioButton, this.myPropertyRadioButton});
    }

    private static boolean isAlwaysInvokedConstructor(@Nullable PsiMethod method, @NotNull PsiClass clazz) {
        if (clazz == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(2);
        }
        if (method == null) {
            return false;
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return true;
        }
        GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)method);
        if (invocation != null && invocation.isThisCall()) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            GrConstructorInvocation inv;
            if (constructor == method || (inv = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor)) != null && !inv.isSuperCall()) continue;
            return false;
        }
        return true;
    }

    private static boolean allOccurrencesInOneMethod(PsiElement @NotNull [] occurrences, PsiElement scope) {
        if (occurrences == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(3);
        }
        if (occurrences.length == 0) {
            return true;
        }
        GrMember container = GrIntroduceFieldHandler.getContainer(occurrences[0], scope);
        if (container == null) {
            return false;
        }
        for (int i2 = 1; i2 < occurrences.length; ++i2) {
            GrMember other = GrIntroduceFieldHandler.getContainer(occurrences[i2], scope);
            if (other == container) continue;
            return false;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myTypeLabel.setLabelFor((Component)((Object)this.myTypeComboBox));
        return this.myContentPane;
    }

    @Override
    public GrIntroduceFieldSettings getSettings() {
        return this;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggestNames() {
        LinkedHashSet<String> linkedHashSet = new GrFieldNameSuggester(this.myContext, new GroovyFieldValidator(this.myContext), false).suggestNames();
        if (linkedHashSet == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    private void createUIComponents() {
        GrExpression expression = this.myContext.getExpression();
        GrVariable var = this.myContext.getVar();
        StringPartInfo stringPart = this.myContext.getStringPart();
        ArrayList<String> list = new ArrayList<String>();
        if (var != null) {
            list.add(var.getName());
        }
        list.addAll(this.suggestNames());
        this.myNameField = new NameSuggestionsField(ArrayUtilRt.toStringArray(list), this.myContext.getProject(), (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myTypeComboBox = expression != null ? GrTypeComboBox.createTypeComboBoxFromExpression(expression) : (stringPart != null ? GrTypeComboBox.createTypeComboBoxFromExpression(stringPart.getLiteral()) : GrTypeComboBox.createTypeComboBoxWithDefType(var.getDeclaredType(), var));
        GrTypeComboBox.registerUpDownHint((JComponent)this.myNameField, this.myTypeComboBox);
    }

    @Override
    public boolean declareFinal() {
        return this.myDeclareFinalCheckBox.isSelected();
    }

    @Override
    @NotNull
    public GrIntroduceFieldSettings.Init initializeIn() {
        if (this.myCurrentMethodRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.CUR_METHOD;
            if (init == null) {
                GrIntroduceFieldDialog.$$$reportNull$$$0(5);
            }
            return init;
        }
        if (this.myFieldDeclarationRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.FIELD_DECLARATION;
            if (init == null) {
                GrIntroduceFieldDialog.$$$reportNull$$$0(6);
            }
            return init;
        }
        if (this.myClassConstructorSRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.CONSTRUCTOR;
            if (init == null) {
                GrIntroduceFieldDialog.$$$reportNull$$$0(7);
            }
            return init;
        }
        if (this.mySetUpMethodRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.SETUP_METHOD;
            if (init == null) {
                GrIntroduceFieldDialog.$$$reportNull$$$0(8);
            }
            return init;
        }
        throw new IncorrectOperationException("no initialization place is selected");
    }

    @Override
    @NotNull
    public String getVisibilityModifier() {
        if (this.myPrivateRadioButton.isSelected()) {
            return "private";
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return "protected";
        }
        if (this.myPublicRadioButton.isSelected()) {
            return "public";
        }
        if (this.myPropertyRadioButton.isSelected()) {
            return "packageLocal";
        }
        throw new IncorrectOperationException("no visibility selected");
    }

    @Override
    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public boolean removeLocalVar() {
        return this.myInvokedOnLocalVar != null && this.myReplaceAllOccurrencesCheckBox.isSelected();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myNameField.getEnteredName();
        if (string == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean replaceAllOccurrences() {
        return this.myReplaceAllOccurrencesCheckBox.isSelected();
    }

    @Override
    public PsiType getSelectedType() {
        return this.myTypeComboBox.getSelectedType();
    }

    @Nullable
    private static String getInvokedOnLocalVar(GrExpression expression) {
        PsiElement resolved;
        if (expression instanceof GrReferenceExpression && PsiUtil.isLocalVariable(resolved = ((GrReferenceExpression)expression).resolve())) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    private static boolean canBeInitializedOutsideBlock(@NotNull GrIntroduceContext context, @NotNull PsiClass clazz) {
        if (context == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(10);
        }
        if (clazz == null) {
            GrIntroduceFieldDialog.$$$reportNull$$$0(11);
        }
        StringPartInfo part = context.getStringPart();
        GrExpression expression = context.getExpression();
        if (expression != null) {
            PsiElement resolved;
            if ((expression = (GrExpression)PsiUtil.skipParentheses(expression, false)) == null) {
                return false;
            }
            if (expression instanceof GrReferenceExpression && PsiUtil.isLocalVariable(resolved = ((GrReferenceExpression)expression).resolve()) && (expression = ((GrVariable)resolved).getInitializerGroovy()) == null) {
                return false;
            }
            ExpressionChecker visitor2 = new ExpressionChecker(clazz, expression);
            expression.accept(visitor2);
            return visitor2.isResult();
        }
        if (part != null) {
            for (GrStringInjection injection : part.getInjections()) {
                GrExpression scope;
                GrExpression grExpression = scope = injection.getExpression() != null ? injection.getExpression() : injection.getClosableBlock();
                assert (scope != null);
                ExpressionChecker visitor3 = new ExpressionChecker(clazz, scope);
                scope.accept(visitor3);
                if (visitor3.isResult()) continue;
                return visitor3.isResult();
            }
            return true;
        }
        return false;
    }

    private void validateOKAction() {
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier(this.getName()));
    }

    protected void doOKAction() {
        PsiClass clazz = (PsiClass)this.myContext.getScope();
        String name = this.getName();
        String message = RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{name, clazz.getQualifiedName()});
        if (clazz.findFieldByName(name, true) != null && Messages.showYesNoDialog((Project)this.myContext.getProject(), (String)message, (String)IntroduceFieldHandler.getRefactoringNameText(), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JBRadioButton jBRadioButton;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("type.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("name.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        GrTypeComboBox grTypeComboBox = this.myTypeComboBox;
        jPanel2.add((Component)((Object)grTypeComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("initialize.in.border.title"), (int)0, (int)0, null, null));
        this.myCurrentMethodRadioButton = jRadioButton7 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("initialize.in.current.method.choice"));
        jPanel4.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFieldDeclarationRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("initialize.in.field.declaration.choice"));
        jPanel4.add((Component)jRadioButton6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClassConstructorSRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("initialize.in.class.constructor.choice"));
        jPanel4.add((Component)jRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySetUpMethodRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setHorizontalAlignment(10);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("initialize.in.setup.method.choice"));
        jPanel4.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("visibility.border.title"), (int)0, (int)0, null, null));
        this.myPrivateRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("visibility.private.choice"));
        jPanel5.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("visibility.protected.choice"));
        jPanel5.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("visibility.public.choice"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPropertyRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("visibility.property.choice"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDeclareFinalCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("declare.final.checkbox"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myReplaceAllOccurrencesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GroovyRefactoringBundle", GrIntroduceFieldDialog.class).getString("replace.all.occurrences.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "errorString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeIn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasLhsUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysInvokedConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allOccurrencesInOneMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeInitializedOutsideBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static final class ExpressionChecker
    extends GroovyRecursiveElementVisitor {
        private final PsiClass myClass;
        private final PsiElement myScope;
        private boolean result;

        private ExpressionChecker(@NotNull PsiClass aClass, @NotNull PsiElement scope) {
            if (aClass == null) {
                ExpressionChecker.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                ExpressionChecker.$$$reportNull$$$0(1);
            }
            this.result = true;
            this.myClass = aClass;
            this.myScope = scope;
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
            if (refExpr == null) {
                ExpressionChecker.$$$reportNull$$$0(2);
            }
            super.visitReferenceExpression(refExpr);
            PsiElement resolved = refExpr.resolve();
            if (!(resolved instanceof GrVariable)) {
                return;
            }
            if (resolved instanceof GrField && this.myClass.getManager().areElementsEquivalent((PsiElement)this.myClass, (PsiElement)((GrField)resolved).getContainingClass())) {
                return;
            }
            if (resolved instanceof PsiParameter && PsiTreeUtil.isAncestor((PsiElement)this.myScope, (PsiElement)((PsiParameter)resolved).getDeclarationScope(), (boolean)false)) {
                return;
            }
            this.result = false;
        }

        private boolean isResult() {
            return this.result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refExpr";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog$ExpressionChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

