/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.LazyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.PsiCallParameterImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u001b0\u0010j\u0002`\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\u001d\u001a\u00020\u0004R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/impl/MethodSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiSubstitutor;Lcom/intellij/psi/PsiElement;)V", "isVararg", "", "()Z", "isVararg$delegate", "Lkotlin/Lazy;", "parameters", "", "getParameters", "()Ljava/util/List;", "parameters$delegate", "returnType", "Lcom/intellij/psi/PsiType;", "getReturnType", "()Lcom/intellij/psi/PsiType;", "applyTo", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "originalMethod", "intellij.groovy.psi"})
public final class MethodSignature
implements CallSignature<PsiCallParameter> {
    @NotNull
    private final PsiMethod method;
    @NotNull
    private final PsiSubstitutor substitutor;
    @NotNull
    private final Lazy isVararg$delegate;
    @NotNull
    private final Lazy parameters$delegate;

    public MethodSignature(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.method = method;
        this.substitutor = substitutor2;
        this.isVararg$delegate = LazyKt.lazyPub((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ MethodSignature this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return PsiUtilKt.isEffectivelyVarArgs(MethodSignature.access$getMethod$p(this.this$0));
            }
        }));
        this.parameters$delegate = LazyKt.lazyPub((Function0)((Function0)new Function0<List<? extends PsiCallParameterImpl>>(this, context){
            final /* synthetic */ MethodSignature this$0;
            final /* synthetic */ PsiElement $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PsiCallParameterImpl> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PsiParameter[] psiParameterArray = MethodSignature.access$getMethod$p(this.this$0).getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                Object[] objectArray = psiParameterArray;
                MethodSignature methodSignature = this.this$0;
                PsiElement psiElement = this.$context;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void psi;
                    PsiParameter psiParameter = (PsiParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)psi);
                    collection.add(new PsiCallParameterImpl((PsiParameter)psi, MethodSignature.access$getSubstitutor$p(methodSignature), psiElement));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @Override
    public boolean isVararg() {
        Lazy lazy = this.isVararg$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public List<PsiCallParameter> getParameters() {
        Lazy lazy = this.parameters$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        if (this.method.isConstructor()) {
            PsiClass psiClass = this.method.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            PsiClass clazz = psiClass;
            return (PsiType)GroovyPsiElementFactory.getInstance(this.method.getProject()).createType(clazz, PsiSubstitutor.EMPTY);
        }
        return this.substitutor.substitute(PsiUtil.getSmartReturnType(this.method));
    }

    @Override
    @NotNull
    public ArgumentMapping<PsiCallParameter> applyTo(@NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ArgumentsKt.argumentMapping(this, arguments2, context);
    }

    @NotNull
    public final PsiMethod originalMethod() {
        return this.method;
    }

    public static final /* synthetic */ PsiMethod access$getMethod$p(MethodSignature $this) {
        return $this.method;
    }

    public static final /* synthetic */ PsiSubstitutor access$getSubstitutor$p(MethodSignature $this) {
        return $this.substitutor;
    }
}

