/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends GroovyFix {
    private final CreateFieldFix myFix;
    private final SmartPsiElementPointer<GrNamedArgument> myNamedArgumentPointer;

    public CreateFieldFromConstructorLabelFix(@NotNull GrTypeDefinition targetClass, @NotNull GrNamedArgument namedArgument) {
        if (targetClass == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(0);
        }
        if (namedArgument == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(1);
        }
        this.myFix = new CreateFieldFix(targetClass);
        this.myNamedArgumentPointer = SmartPointersKt.createSmartPointer((PsiElement)namedArgument);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiElement parent2;
        if (project == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(3);
        }
        PsiClass targetClass = this.myFix.getTargetClass();
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        String name = this.getFieldName();
        if (name == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        PsiField representation = fix.getFieldRepresentation(targetClass.getProject(), ArrayUtilRt.EMPTY_STRING_ARRAY, name, (PsiElement)targetClass, true);
        PsiElement psiElement = parent2 = representation == null ? null : representation.getParent();
        if (parent2 == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }
        String className = targetClass.getName();
        String classKind = targetClass.isInterface() ? "interface" : (targetClass.isEnum() ? "enum" : (targetClass.isAnnotationType() ? "@interface" : (targetClass.isRecord() ? "record" : (targetClass instanceof GrTypeDefinition && ((GrTypeDefinition)targetClass).isTrait() ? "trait" : "class"))));
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, classKind + " " + className, "", parent2.getText());
    }

    @Nullable
    private String getFieldName() {
        GrNamedArgument namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement();
        if (namedArgument == null) {
            return null;
        }
        GrArgumentLabel label = namedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    private static TypeConstraint[] calculateTypeConstrains(@NotNull GrNamedArgument namedArgument) {
        if (namedArgument == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(6);
        }
        GrExpression expression = namedArgument.getExpression();
        PsiType type2 = null;
        if (expression != null) {
            type2 = expression.getType();
        }
        if (type2 != null) {
            return new TypeConstraint[]{SupertypeConstraint.create(type2, type2)};
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("create.field.from.usage", this.getFieldName());
        if (string == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.create.field", new Object[0]);
        if (string == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrNamedArgument namedArgument;
        if (project == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            CreateFieldFromConstructorLabelFix.$$$reportNull$$$0(10);
        }
        if ((namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement()) == null) {
            return;
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            return;
        }
        this.myFix.doFix(project, ArrayUtilRt.EMPTY_STRING_ARRAY, fieldName, CreateFieldFromConstructorLabelFix.calculateTypeConstrains(namedArgument), namedArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgument";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromConstructorLabelFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeConstrains";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

