/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatter;

public abstract class ComponentFormatterTemplate
implements ComponentFormatter {
    @Override
    @Nonnull
    @RunsInCurrentThread
    public final String format(@Nonnull Component c) {
        this.checkTypeOf(c);
        return this.doFormat(c);
    }

    @Nonnull
    @RunsInCurrentThread
    protected abstract String doFormat(@Nonnull Component var1);

    private void checkTypeOf(@Nonnull Component c) {
        Preconditions.checkNotNull(c);
        if (!this.targetType().isAssignableFrom(c.getClass())) {
            String msg = String.format("This formatter only supports components of type %s", this.targetType().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    protected String getRealClassName(Component c) {
        return this.getRealClassName(c.getClass());
    }

    private String getRealClassName(Class<?> type) {
        if (type.isAnonymousClass()) {
            return type.getName() + "(" + this.getRealClassName(type.getSuperclass()) + ")";
        }
        return type.getName();
    }
}

