/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellWriter;
import org.assertj.swing.core.ComponentFoundCondition;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JTableCancelCellEditingTask;
import org.assertj.swing.driver.JTableCellEditorQuery;
import org.assertj.swing.driver.JTableCellPreconditions;
import org.assertj.swing.driver.JTableLocation;
import org.assertj.swing.driver.JTableStopCellEditingTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;

public abstract class AbstractJTableCellWriter
implements JTableCellWriter {
    protected final Robot robot;
    private final JTableLocation location = new JTableLocation();
    private TableCellEditor cellEditor;
    private static final long EDITOR_LOOKUP_TIMEOUT = 5000L;

    public AbstractJTableCellWriter(@Nonnull Robot robot) {
        this.robot = robot;
    }

    @Override
    @RunsInEDT
    public void cancelCellEditing(@Nonnull JTable table, int row, int column) {
        if (this.cellEditor == null) {
            this.doCancelCellEditing(table, row, column);
            return;
        }
        this.doCancelCellEditing();
    }

    @RunsInEDT
    private void doCancelCellEditing(@Nonnull JTable table, int row, int column) {
        JTableCancelCellEditingTask.cancelEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doCancelCellEditing() {
        JTableCancelCellEditingTask.cancelEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void stopCellEditing(@Nonnull JTable table, int row, int column) {
        if (this.cellEditor == null) {
            this.doStopCellEditing(table, row, column);
            return;
        }
        this.doStopCellEditing();
    }

    @RunsInEDT
    private void doStopCellEditing(@Nonnull JTable table, int row, int column) {
        JTableStopCellEditingTask.checkStateAndStopEditing(table, row, column);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void doStopCellEditing() {
        JTableStopCellEditingTask.stopEditing(this.cellEditor);
        this.robot.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    protected static TableCellEditor cellEditor(@Nonnull JTable table, int row, int column) {
        return GuiActionRunner.execute(() -> table.getCellEditor(row, column));
    }

    @RunsInCurrentThread
    protected static void scrollToCell(JTable table, int row, int column, JTableLocation location) {
        table.scrollRectToVisible(location.cellBounds(table, row, column));
    }

    @Override
    @Nullable
    @RunsInEDT
    public Component editorForCell(@Nonnull JTable table, int row, int column) {
        return AbstractJTableCellWriter.cellEditorComponent(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private static Component cellEditorComponent(@Nonnull JTable table, int row, int column) {
        return GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
            return JTableCellEditorQuery.cellEditorIn(table, row, column);
        });
    }

    @Nonnull
    @RunsInCurrentThread
    protected static <T extends Component> T editor(@Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        AbstractJTableCellWriter.validate(table, row, column);
        Component editor2 = JTableCellEditorQuery.cellEditorIn(table, row, column);
        if (supportedType.isInstance(editor2)) {
            return (T)((Component)supportedType.cast(editor2));
        }
        throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
    }

    @Nonnull
    @RunsInEDT
    protected static Point cellLocation(@Nonnull JTable table, int row, int column, @Nonnull JTableLocation location) {
        Point result2 = GuiActionRunner.execute(() -> {
            AbstractJTableCellWriter.validate(table, row, column);
            AbstractJTableCellWriter.scrollToCell(table, row, column, location);
            return location.pointAt(table, row, column);
        });
        return Preconditions.checkNotNull(result2);
    }

    @RunsInCurrentThread
    protected static void validate(@Nonnull JTable table, int row, int column) {
        JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
        ComponentPreconditions.checkEnabledAndShowing(table);
        JTableCellPreconditions.validateCellIsEditable(table, row, column);
    }

    @Nullable
    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(@Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        return this.waitForEditorActivation(new TypeMatcher(supportedType, true), table, row, column, supportedType);
    }

    @Nullable
    @RunsInEDT
    protected final <T extends Component> T waitForEditorActivation(@Nonnull ComponentMatcher matcher, @Nonnull JTable table, int row, int column, @Nonnull Class<T> supportedType) {
        ComponentFoundCondition condition = new ComponentFoundCondition("", this.robot.finder(), matcher, (Container)table);
        try {
            Pause.pause((Condition)condition, 5000L);
        }
        catch (WaitTimedOutError e) {
            throw AbstractJTableCellWriter.cannotFindOrActivateEditor(row, column);
        }
        return (T)((Component)supportedType.cast(condition.found()));
    }

    @Nonnull
    protected static ActionFailedException cannotFindOrActivateEditor(int row, int column) {
        String msg = Strings.concat("Unable to find or activate editor for cell [", String.valueOf(row), ",", String.valueOf(column), "]");
        throw ActionFailedException.actionFailure(msg);
    }

    @Nullable
    protected final TableCellEditor cellEditor() {
        return this.cellEditor;
    }

    protected final void cellEditor(@Nullable TableCellEditor newCellEditor) {
        this.cellEditor = newCellEditor;
    }

    @Nonnull
    protected final JTableLocation location() {
        return this.location;
    }
}

