/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyCycle;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.impl.collect.NodeStack;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

final class DefaultDependencyCycle
implements DependencyCycle {
    private final List<Dependency> dependencies;
    private final int cycleEntry;

    DefaultDependencyCycle(NodeStack nodes, int cycleEntry, Dependency dependency) {
        int offset = cycleEntry > 0 && nodes.get(0).getDependency() == null ? 1 : 0;
        Dependency[] dependencies = new Dependency[nodes.size() - offset + 1];
        int n2 = dependencies.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            DependencyNode node = nodes.get(i2 + offset);
            dependencies[i2] = node.getDependency();
            if (dependencies[i2] != null) continue;
            dependencies[i2] = new Dependency(node.getArtifact(), null);
        }
        dependencies[dependencies.length - 1] = dependency;
        this.dependencies = Collections.unmodifiableList(Arrays.asList(dependencies));
        this.cycleEntry = cycleEntry;
    }

    @Override
    public List<Dependency> getPrecedingDependencies() {
        return this.dependencies.subList(0, this.cycleEntry);
    }

    @Override
    public List<Dependency> getCyclicDependencies() {
        return this.dependencies.subList(this.cycleEntry, this.dependencies.size());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        int n2 = this.dependencies.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                buffer.append(" -> ");
            }
            buffer.append(ArtifactIdUtils.toVersionlessId(this.dependencies.get(i2).getArtifact()));
        }
        return buffer.toString();
    }
}

