/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;

public class NewChangelistDialog
extends DialogWrapper {
    private NewEditChangelistPanel myPanel;
    private final Project myProject;

    public NewChangelistDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(VcsBundle.message((String)"changes.dialog.newchangelist.title", (Object[])new Object[0]));
        this.createUIComponents();
        this.myPanel.init(null);
        this.setSize(JBUI.scale((int)500), JBUI.scale((int)230));
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        VcsConfiguration.getInstance((Project)this.myProject).MAKE_NEW_CHANGELIST_ACTIVE = this.isNewChangelistActive();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public String getName() {
        return this.myPanel.getChangeListName();
    }

    public String getDescription() {
        return this.myPanel.getDescription();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "VCS.EditChangelistDialog";
    }

    public boolean isNewChangelistActive() {
        return this.myPanel.getMakeActiveCheckBox().isSelected();
    }

    public NewEditChangelistPanel getPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected void nameChanged(@NlsContexts.DialogMessage String errorMessage) {
                NewChangelistDialog.this.setOKActionEnabled(errorMessage == null);
                NewChangelistDialog.this.setErrorText(errorMessage, (JComponent)((Object)NewChangelistDialog.this.myPanel));
            }
        };
    }

    protected String getHelpId() {
        return "new_changelist_dialog";
    }
}

