/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.wsl;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.net.URI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\u00020\u00032\u0006\u0010 \u001a\u00020\u0007H\u0002R#\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/wsl/WslBuildLayoutParameters;", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "(Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "gradleHome", "Lcom/intellij/execution/target/value/TargetValue;", "getGradleHome", "()Lcom/intellij/execution/target/value/TargetValue;", "gradleHome$delegate", "Lkotlin/Lazy;", "gradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "Lorg/jetbrains/annotations/Nullable;", "gradleUserHome", "getGradleUserHome", "gradleUserHome$delegate", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradleVersion$delegate", "findGradleHome", "findGradleUserHomeDir", "guessGradleVersion", "getTargetValueForLocalPath", "windowsPath", "getTargetValueForRemotePath", "wslPath", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nWslBuildLayoutParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/wsl/WslBuildLayoutParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class WslBuildLayoutParameters
implements BuildLayoutParameters {
    @NotNull
    private final WSLDistribution wslDistribution;
    @NotNull
    private final Project project;
    @Nullable
    private final String projectPath;
    @Nullable
    private final GradleProjectSettings gradleProjectSettings;
    @NotNull
    private final Lazy gradleHome$delegate;
    @NotNull
    private final Lazy gradleVersion$delegate;
    @NotNull
    private final Lazy gradleUserHome$delegate;

    /*
     * WARNING - void declaration
     */
    public WslBuildLayoutParameters(@NotNull WSLDistribution wslDistribution, @NotNull Project project2, @Nullable String projectPath) {
        GradleProjectSettings gradleProjectSettings;
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.wslDistribution = wslDistribution;
        this.project = project2;
        this.projectPath = projectPath;
        WslBuildLayoutParameters wslBuildLayoutParameters = this;
        String string2 = this.projectPath;
        if (string2 != null) {
            void it;
            String string3 = string2;
            WslBuildLayoutParameters wslBuildLayoutParameters2 = wslBuildLayoutParameters;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.project).getLinkedProjectSettings((String)it);
            wslBuildLayoutParameters = wslBuildLayoutParameters2;
        } else {
            gradleProjectSettings = null;
        }
        wslBuildLayoutParameters.gradleProjectSettings = gradleProjectSettings;
        this.gradleHome$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetValue<String>>(this){
            final /* synthetic */ WslBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final TargetValue<String> invoke() {
                return WslBuildLayoutParameters.access$findGradleHome(this.this$0);
            }
        }));
        this.gradleVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GradleVersion>(this){
            final /* synthetic */ WslBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final GradleVersion invoke() {
                return WslBuildLayoutParameters.access$guessGradleVersion(this.this$0);
            }
        }));
        this.gradleUserHome$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetValue<String>>(this){
            final /* synthetic */ WslBuildLayoutParameters this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TargetValue<String> invoke() {
                return WslBuildLayoutParameters.access$findGradleUserHomeDir(this.this$0, WslBuildLayoutParameters.access$getWslDistribution$p(this.this$0));
            }
        }));
    }

    @Override
    @Nullable
    public TargetValue<String> getGradleHome() {
        Lazy lazy = this.gradleHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    @Override
    @Nullable
    public GradleVersion getGradleVersion() {
        Lazy lazy = this.gradleVersion$delegate;
        return (GradleVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetValue<String> getGradleUserHome() {
        Lazy lazy = this.gradleUserHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    private final TargetValue<String> findGradleHome() {
        TargetValue<String> targetValue;
        Object object = this.gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        Object distributionType = object;
        if (distributionType == DistributionType.LOCAL) {
            TargetValue<String> targetValue2;
            String string2 = this.gradleProjectSettings.getGradleHome();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                targetValue2 = this.getTargetValueForRemotePath(this.wslDistribution, it);
            } else {
                targetValue2 = null;
            }
            return targetValue2;
        }
        String string3 = GradleLocalSettings.getInstance(this.project).getGradleHome(this.projectPath);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            targetValue = this.getTargetValueForLocalPath(this.wslDistribution, it);
        } else {
            targetValue = null;
        }
        return targetValue;
    }

    private final GradleVersion guessGradleVersion() {
        Object object = this.gradleProjectSettings;
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 1: {
                return GradleVersion.current();
            }
            case 2: {
                GradleVersion gradleVersion2;
                TargetValue<String> targetValue = this.getGradleHome();
                String string2 = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string2 != null) {
                    String $this$guessGradleVersion_u24lambda_u243 = string2;
                    boolean bl = false;
                    gradleVersion2 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u243);
                } else {
                    gradleVersion2 = null;
                }
                return gradleVersion2;
            }
            case 3: {
                GradleVersion gradleVersion3;
                TargetValue<String> targetValue = this.getGradleHome();
                String string3 = GradleInstallationManager.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string3 != null) {
                    String $this$guessGradleVersion_u24lambda_u244 = string3;
                    boolean bl = false;
                    v6 = GradleInstallationManager.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u244);
                } else {
                    v6 = gradleVersion3 = null;
                }
                if (gradleVersion3 == null) {
                    String path;
                    Object object2 = GradleUtil.getWrapperConfiguration(this.projectPath);
                    String string4 = object2 != null && (object2 = object2.getDistribution()) != null ? ((URI)object2).getRawPath() : (path = null);
                    if (path == null) break;
                    return GradleInstallationManager.parseDistributionVersion(path);
                }
                return gradleVersion3;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    private final TargetValue<String> findGradleUserHomeDir(WSLDistribution wslDistribution) {
        String serviceDirectoryPath;
        if (this.projectPath != null && (serviceDirectoryPath = GradleSettings.getInstance(this.project).getServiceDirectoryPath()) != null) {
            return this.getTargetValueForLocalPath(wslDistribution, serviceDirectoryPath);
        }
        String gradleUserHome2 = StringKt.nullize((String)wslDistribution.getEnvironmentVariable("GRADLE_USER_HOME"), (boolean)true);
        Object object = gradleUserHome2;
        if (object == null) {
            object = wslDistribution.getUserHome() + "/.gradle";
        }
        return this.getTargetValueForRemotePath(wslDistribution, (String)object);
    }

    private final TargetValue<String> getTargetValueForLocalPath(WSLDistribution $this$getTargetValueForLocalPath, String windowsPath) {
        String string2 = $this$getTargetValueForLocalPath.getWslPath(windowsPath);
        if (string2 == null) {
            string2 = windowsPath;
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String wslPath = string3;
        TargetValue targetValue = TargetValue.create((Object)windowsPath, (Promise)Promises.resolvedPromise((Object)wslPath));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
        return targetValue;
    }

    private final TargetValue<String> getTargetValueForRemotePath(WSLDistribution $this$getTargetValueForRemotePath, String wslPath) {
        String string2 = $this$getTargetValueForRemotePath.getWindowsPath(wslPath);
        if (string2 == null) {
            string2 = wslPath;
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String windowsPath = string3;
        TargetValue targetValue = TargetValue.create((Object)windowsPath, (Promise)Promises.resolvedPromise((Object)wslPath));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
        return targetValue;
    }

    public static final /* synthetic */ TargetValue access$findGradleHome(WslBuildLayoutParameters $this) {
        return $this.findGradleHome();
    }

    public static final /* synthetic */ GradleVersion access$guessGradleVersion(WslBuildLayoutParameters $this) {
        return $this.guessGradleVersion();
    }

    public static final /* synthetic */ TargetValue access$findGradleUserHomeDir(WslBuildLayoutParameters $this, WSLDistribution wslDistribution) {
        return $this.findGradleUserHomeDir(wslDistribution);
    }

    public static final /* synthetic */ WSLDistribution access$getWslDistribution$p(WslBuildLayoutParameters $this) {
        return $this.wslDistribution;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.BUNDLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.DEFAULT_WRAPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.WRAPPED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

