/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.statistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.internal.DefaultFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.internal.DefaultTaskFailureResult;
import org.gradle.tooling.events.task.internal.DefaultTaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.statistics.AggregatedTaskReport;
import org.jetbrains.plugins.gradle.service.execution.statistics.GradleTaskExecutionHandler;
import org.jetbrains.plugins.gradle.util.GradleTaskClassifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u0017*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u000b*\u00020\u0010H\u0002J\f\u0010\u001a\u001a\u00020\u000b*\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionListener;", "", "handler", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionHandler;", "(Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionHandler;)V", "flushed", "", "getHandler", "()Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionHandler;", "inflightTasks", "", "", "Lorg/jetbrains/plugins/gradle/service/execution/statistics/AggregatedTaskReport;", "addTaskFinish", "", "event", "Lorg/gradle/tooling/events/task/internal/DefaultTaskFinishEvent;", "flush", "isKnownTaskSource", "name", "route", "Lorg/gradle/tooling/events/ProgressEvent;", "duration", "", "Lorg/gradle/tooling/events/internal/DefaultFinishEvent;", "getClassifiedTaskName", "getTaskSource", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleTaskExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleTaskExecutionListener.kt\norg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1855#2,2:97\n1#3:99\n*S KotlinDebug\n*F\n+ 1 GradleTaskExecutionListener.kt\norg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionListener\n*L\n48#1:97,2\n*E\n"})
public final class GradleTaskExecutionListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleTaskExecutionHandler handler;
    @NotNull
    private final Map<String, AggregatedTaskReport> inflightTasks;
    private boolean flushed;
    @NotNull
    private static final String USER_DEFINED_TASK_NAME_REPLACEMENT = "other";
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String ORG_JETBRAINS_PACKAGE = "org.jetbrains.";
    @NotNull
    private static final String ORG_GRADLE_PACKAGE = "org.gradle.";
    @NotNull
    private static final String UP_TO_DATE = "UP-TO-DATE";
    @NotNull
    private static final String FROM_CACHE = "FROM-CACHE";

    public GradleTaskExecutionListener(@NotNull GradleTaskExecutionHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.inflightTasks = new HashMap();
    }

    @NotNull
    public final GradleTaskExecutionHandler getHandler() {
        return this.handler;
    }

    public final void route(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.flushed) {
            return;
        }
        if (event instanceof DefaultTaskFinishEvent) {
            this.addTaskFinish((DefaultTaskFinishEvent)event);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void flush() {
        void $this$forEach$iv;
        if (this.flushed) {
            return;
        }
        Iterable iterable = this.inflightTasks.values();
        GradleTaskExecutionHandler gradleTaskExecutionHandler = this.handler;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AggregatedTaskReport p0 = (AggregatedTaskReport)element$iv;
            boolean bl = false;
            gradleTaskExecutionHandler.onTaskExecuted(p0);
        }
        this.inflightTasks.clear();
        this.flushed = true;
    }

    private final void addTaskFinish(DefaultTaskFinishEvent event) {
        AggregatedTaskReport aggregatedTaskReport;
        String source = this.getTaskSource(event);
        Ref.ObjectRef taskName = new Ref.ObjectRef();
        taskName.element = USER_DEFINED_TASK_NAME_REPLACEMENT;
        Ref.ObjectRef taskSource = new Ref.ObjectRef();
        taskSource.element = UNKNOWN;
        if (this.isKnownTaskSource(source)) {
            taskName.element = this.getClassifiedTaskName(event);
            taskSource.element = source;
        }
        String accumulatorKey = "" + taskName.element + taskSource.element;
        AggregatedTaskReport $this$addTaskFinish_u24lambda_u241 = aggregatedTaskReport = this.inflightTasks.computeIfAbsent(accumulatorKey, arg_0 -> GradleTaskExecutionListener.addTaskFinish$lambda$0((Function1)new Function1<String, AggregatedTaskReport>((Ref.ObjectRef<String>)taskName, (Ref.ObjectRef<String>)taskSource){
            final /* synthetic */ Ref.ObjectRef<String> $taskName;
            final /* synthetic */ Ref.ObjectRef<String> $taskSource;
            {
                this.$taskName = $taskName;
                this.$taskSource = $taskSource;
                super(1);
            }

            @NotNull
            public final AggregatedTaskReport invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new AggregatedTaskReport((String)this.$taskName.element, (String)this.$taskSource.element, 0, 0L, 0, 0, 0L, 0L, 0, 508, null);
            }
        }, arg_0));
        boolean bl = false;
        String eventName = event.getDisplayName();
        long taskDuration = this.duration((DefaultFinishEvent)event);
        Intrinsics.checkNotNull((Object)eventName);
        if (StringsKt.contains$default((CharSequence)eventName, (CharSequence)UP_TO_DATE, (boolean)false, (int)2, null)) {
            $this$addTaskFinish_u24lambda_u241.setUpToDateCount($this$addTaskFinish_u24lambda_u241.getUpToDateCount() + 1);
            $this$addTaskFinish_u24lambda_u241.setUpToDateDuration($this$addTaskFinish_u24lambda_u241.getUpToDateDuration() + taskDuration);
        }
        if (StringsKt.contains$default((CharSequence)eventName, (CharSequence)FROM_CACHE, (boolean)false, (int)2, null)) {
            $this$addTaskFinish_u24lambda_u241.setFromCacheCount($this$addTaskFinish_u24lambda_u241.getFromCacheCount() + 1);
            $this$addTaskFinish_u24lambda_u241.setFromCacheDuration($this$addTaskFinish_u24lambda_u241.getFromCacheDuration() + taskDuration);
        }
        if (event.getResult() instanceof DefaultTaskFailureResult) {
            $this$addTaskFinish_u24lambda_u241.setFailed($this$addTaskFinish_u24lambda_u241.getFailed() + 1);
        }
        $this$addTaskFinish_u24lambda_u241.setSumDurationMs($this$addTaskFinish_u24lambda_u241.getSumDurationMs() + taskDuration);
        $this$addTaskFinish_u24lambda_u241.setCount($this$addTaskFinish_u24lambda_u241.getCount() + 1);
    }

    private final String getClassifiedTaskName(DefaultTaskFinishEvent $this$getClassifiedTaskName) {
        String string2 = ((TaskOperationDescriptor)$this$getClassifiedTaskName.getDescriptor()).getTaskPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTaskPath(...)");
        String[] stringArray = new String[]{":"};
        String it = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null))))).toString();
        boolean bl = false;
        return GradleTaskClassifier.classifyTaskName(it);
    }

    private final String getTaskSource(DefaultTaskFinishEvent $this$getTaskSource) {
        PluginIdentifier pluginIdentifier = ((TaskOperationDescriptor)$this$getTaskSource.getDescriptor()).getOriginPlugin();
        String string2 = pluginIdentifier != null ? pluginIdentifier.getDisplayName() : null;
        if (string2 == null) {
            string2 = UNKNOWN;
        }
        return string2;
    }

    private final long duration(DefaultFinishEvent<?, ?> $this$duration) {
        OperationResult $this$duration_u24lambda_u243 = $this$duration.getResult();
        boolean bl = false;
        return $this$duration_u24lambda_u243.getEndTime() - $this$duration_u24lambda_u243.getStartTime();
    }

    private final boolean isKnownTaskSource(String name2) {
        return name2 != null && (StringsKt.startsWith$default((String)name2, (String)ORG_GRADLE_PACKAGE, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)ORG_JETBRAINS_PACKAGE, (boolean)false, (int)2, null));
    }

    private static final AggregatedTaskReport addTaskFinish$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregatedTaskReport)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/statistics/GradleTaskExecutionListener$Companion;", "", "()V", "FROM_CACHE", "", "ORG_GRADLE_PACKAGE", "ORG_JETBRAINS_PACKAGE", "UNKNOWN", "UP_TO_DATE", "USER_DEFINED_TASK_NAME_REPLACEMENT", "intellij.gradle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

