/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleLocalProperties;
import org.jetbrains.plugins.gradle.properties.GradleLocalPropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradleLocalPropertiesFile;", "", "()V", "getGradleLocalPropertiesPath", "Ljava/nio/file/Path;", "externalProjectPath", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleLocalProperties;", "loadGradleLocalProperties", "propertiesPath", "intellij.gradle"})
public final class GradleLocalPropertiesFile {
    @NotNull
    public static final GradleLocalPropertiesFile INSTANCE = new GradleLocalPropertiesFile();

    private GradleLocalPropertiesFile() {
    }

    @NotNull
    public final GradleLocalProperties getProperties(@NotNull Path externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Path propertiesPath = this.getGradleLocalPropertiesPath(externalProjectPath2);
        return this.loadGradleLocalProperties(propertiesPath);
    }

    private final GradleLocalProperties loadGradleLocalProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return GradleLocalProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        return new GradleLocalPropertiesImpl(PropertyKt.getStringProperty(properties2, "java.home", propertiesPath));
    }

    private final Path getGradleLocalPropertiesPath(Path externalProjectPath2) {
        String[] stringArray = new String[]{"config.properties"};
        Path gradleLocalPath = externalProjectPath2.resolve(Paths.get(".gradle", stringArray));
        Path path = gradleLocalPath.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }
}

