/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.binary;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.kohsuke.rngom.ast.builder.Annotations;
import org.kohsuke.rngom.ast.builder.BuildException;
import org.kohsuke.rngom.ast.builder.CommentList;
import org.kohsuke.rngom.ast.builder.DataPatternBuilder;
import org.kohsuke.rngom.ast.builder.Div;
import org.kohsuke.rngom.ast.builder.ElementAnnotationBuilder;
import org.kohsuke.rngom.ast.builder.Grammar;
import org.kohsuke.rngom.ast.builder.GrammarSection;
import org.kohsuke.rngom.ast.builder.Include;
import org.kohsuke.rngom.ast.builder.IncludedGrammar;
import org.kohsuke.rngom.ast.builder.NameClassBuilder;
import org.kohsuke.rngom.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.ast.builder.Scope;
import org.kohsuke.rngom.ast.om.Location;
import org.kohsuke.rngom.ast.om.ParsedElementAnnotation;
import org.kohsuke.rngom.ast.om.ParsedNameClass;
import org.kohsuke.rngom.ast.om.ParsedPattern;
import org.kohsuke.rngom.ast.util.LocatorImpl;
import org.kohsuke.rngom.binary.Pattern;
import org.kohsuke.rngom.binary.RefPattern;
import org.kohsuke.rngom.binary.RestrictionViolationException;
import org.kohsuke.rngom.binary.SchemaPatternBuilder;
import org.kohsuke.rngom.dt.builtin.BuiltinDatatypeLibraryFactory;
import org.kohsuke.rngom.nc.NameClass;
import org.kohsuke.rngom.nc.NameClassBuilderImpl;
import org.kohsuke.rngom.parse.Context;
import org.kohsuke.rngom.parse.IllegalSchemaException;
import org.kohsuke.rngom.parse.Parseable;
import org.kohsuke.rngom.util.Localizer;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaBuilderImpl
implements SchemaBuilder,
ElementAnnotationBuilder,
CommentList {
    private final SchemaBuilderImpl parent;
    private boolean hadError = false;
    private final SchemaPatternBuilder pb;
    private final DatatypeLibraryFactory datatypeLibraryFactory;
    private final String inheritNs;
    private final ErrorHandler eh;
    private final OpenIncludes openIncludes;
    private final NameClassBuilder ncb = new NameClassBuilderImpl();
    static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    public ParsedPattern expandPattern(ParsedPattern _pattern) throws BuildException, IllegalSchemaException {
        Pattern pattern2 = (Pattern)_pattern;
        if (!this.hadError) {
            try {
                pattern2.checkRecursion(0);
                pattern2 = pattern2.expand(this.pb);
                pattern2.checkRestrictions(0, null, null);
                if (!this.hadError) {
                    return pattern2;
                }
            }
            catch (SAXParseException e) {
                this.error(e);
            }
            catch (SAXException e) {
                throw new BuildException(e);
            }
            catch (RestrictionViolationException e) {
                if (e.getName() != null) {
                    this.error(e.getMessageId(), e.getName().toString(), e.getLocator());
                }
                this.error(e.getMessageId(), e.getLocator());
            }
        }
        throw new IllegalSchemaException();
    }

    public SchemaBuilderImpl(ErrorHandler eh) {
        this(eh, new BuiltinDatatypeLibraryFactory(new DatatypeLibraryLoader()), new SchemaPatternBuilder());
    }

    public SchemaBuilderImpl(ErrorHandler eh, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder pb) {
        this.parent = null;
        this.eh = eh;
        this.datatypeLibraryFactory = datatypeLibraryFactory;
        this.pb = pb;
        this.inheritNs = "";
        this.openIncludes = null;
    }

    private SchemaBuilderImpl(String inheritNs, String uri, SchemaBuilderImpl parent) {
        this.parent = parent;
        this.eh = parent.eh;
        this.datatypeLibraryFactory = parent.datatypeLibraryFactory;
        this.pb = parent.pb;
        this.inheritNs = inheritNs;
        this.openIncludes = new OpenIncludes(uri, parent.openIncludes);
    }

    public NameClassBuilder getNameClassBuilder() {
        return this.ncb;
    }

    public ParsedPattern makeChoice(List patterns, Location loc, Annotations anno) throws BuildException {
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Pattern result2 = (Pattern)patterns.get(0);
        for (int i = 1; i < patterns.size(); ++i) {
            result2 = this.pb.makeChoice(result2, (Pattern)patterns.get(i));
        }
        return result2;
    }

    public ParsedPattern makeInterleave(List patterns, Location loc, Annotations anno) throws BuildException {
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Pattern result2 = (Pattern)patterns.get(0);
        for (int i = 1; i < patterns.size(); ++i) {
            result2 = this.pb.makeInterleave(result2, (Pattern)patterns.get(i));
        }
        return result2;
    }

    public ParsedPattern makeGroup(List patterns, Location loc, Annotations anno) throws BuildException {
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Pattern result2 = (Pattern)patterns.get(0);
        for (int i = 1; i < patterns.size(); ++i) {
            result2 = this.pb.makeGroup(result2, (Pattern)patterns.get(i));
        }
        return result2;
    }

    public ParsedPattern makeOneOrMore(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeOneOrMore((Pattern)p);
    }

    public ParsedPattern makeZeroOrMore(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeZeroOrMore((Pattern)p);
    }

    public ParsedPattern makeOptional(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeOptional((Pattern)p);
    }

    public ParsedPattern makeList(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeList((Pattern)p, (Locator)((Object)loc));
    }

    public ParsedPattern makeMixed(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeMixed((Pattern)p);
    }

    public ParsedPattern makeEmpty(Location loc, Annotations anno) {
        return this.pb.makeEmpty();
    }

    public ParsedPattern makeNotAllowed(Location loc, Annotations anno) {
        return this.pb.makeUnexpandedNotAllowed();
    }

    public ParsedPattern makeText(Location loc, Annotations anno) {
        return this.pb.makeText();
    }

    public ParsedPattern makeErrorPattern() {
        return this.pb.makeError();
    }

    public ParsedPattern makeAttribute(ParsedNameClass nc, ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeAttribute((NameClass)nc, (Pattern)p, (Locator)((Object)loc));
    }

    public ParsedPattern makeElement(ParsedNameClass nc, ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeElement((NameClass)nc, (Pattern)p, (Locator)((Object)loc));
    }

    public DataPatternBuilder makeDataPatternBuilder(String datatypeLibrary, String type2, Location loc) throws BuildException {
        DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
        if (dl == null) {
            this.error("unrecognized_datatype_library", datatypeLibrary, (Locator)((Object)loc));
        } else {
            try {
                return new DataPatternBuilderImpl(dl.createDatatypeBuilder(type2));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    this.error("unsupported_datatype_detail", datatypeLibrary, type2, detail, (Locator)((Object)loc));
                }
                this.error("unrecognized_datatype", datatypeLibrary, type2, (Locator)((Object)loc));
            }
        }
        return new DummyDataPatternBuilder();
    }

    public ParsedPattern makeValue(String datatypeLibrary, String type2, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
        block8: {
            DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
            if (dl == null) {
                this.error("unrecognized_datatype_library", datatypeLibrary, (Locator)((Object)loc));
            } else {
                try {
                    DatatypeBuilder dtb = dl.createDatatypeBuilder(type2);
                    try {
                        Datatype dt = dtb.createDatatype();
                        Object obj = dt.createValue(value, new ValidationContextImpl(context, ns));
                        if (obj != null) {
                            return this.pb.makeValue(dt, obj);
                        }
                        this.error("invalid_value", value, (Locator)((Object)loc));
                    }
                    catch (DatatypeException e) {
                        String detail = e.getMessage();
                        if (detail != null) {
                            this.error("datatype_requires_param_detail", detail, (Locator)((Object)loc));
                            break block8;
                        }
                        this.error("datatype_requires_param", (Locator)((Object)loc));
                    }
                }
                catch (DatatypeException e) {
                    this.error("unrecognized_datatype", datatypeLibrary, type2, (Locator)((Object)loc));
                }
            }
        }
        return this.pb.makeError();
    }

    public Grammar makeGrammar(Scope parent) {
        return new GrammarImpl(this, parent);
    }

    public ParsedPattern annotate(ParsedPattern p, Annotations anno) throws BuildException {
        return p;
    }

    public ParsedPattern annotateAfter(ParsedPattern p, ParsedElementAnnotation e) throws BuildException {
        return p;
    }

    public ParsedPattern commentAfter(ParsedPattern p, CommentList comments) throws BuildException {
        return p;
    }

    public ParsedPattern makeExternalRef(Parseable current, String uri, String ns, Scope scope, Location loc, Annotations anno) throws BuildException {
        OpenIncludes inc = this.openIncludes;
        while (inc != null) {
            if (inc.uri.equals(uri)) {
                this.error("recursive_include", uri, (Locator)((Object)loc));
                return this.pb.makeError();
            }
            inc = inc.parent;
        }
        try {
            return current.parseExternal(uri, new SchemaBuilderImpl(ns, uri, this), scope, ns);
        }
        catch (IllegalSchemaException e) {
            this.noteError();
            return this.pb.makeError();
        }
    }

    public Location makeLocation(String systemId, int lineNumber, int columnNumber) {
        return new LocatorImpl(systemId, lineNumber, columnNumber);
    }

    public Annotations makeAnnotations(CommentList comments, Context context) {
        return this;
    }

    public ElementAnnotationBuilder makeElementAnnotationBuilder(String ns, String localName, String prefix, Location loc, CommentList comments, Context context) {
        return this;
    }

    public CommentList makeCommentList() {
        return this;
    }

    public void addComment(String value, Location loc) throws BuildException {
    }

    @java.lang.Override
    public void addAttribute(String ns, String localName, String prefix, String value, Location loc) {
    }

    @java.lang.Override
    public void addElement(ParsedElementAnnotation ea) {
    }

    @java.lang.Override
    public void addComment(CommentList comments) throws BuildException {
    }

    @java.lang.Override
    public void addLeadingComment(CommentList comments) throws BuildException {
    }

    public ParsedElementAnnotation makeElementAnnotation() {
        return null;
    }

    public void addText(String value, Location loc, CommentList comments) throws BuildException {
    }

    @java.lang.Override
    public boolean usesComments() {
        return false;
    }

    private void error(SAXParseException message2) throws BuildException {
        this.noteError();
        try {
            if (this.eh != null) {
                this.eh.error(message2);
            }
        }
        catch (SAXException e) {
            throw new BuildException(e);
        }
    }

    private void warning(SAXParseException message2) throws BuildException {
        try {
            if (this.eh != null) {
                this.eh.warning(message2);
            }
        }
        catch (SAXException e) {
            throw new BuildException(e);
        }
    }

    private void error(String key2, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key2), loc));
    }

    private void error(String key2, String arg, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key2, arg), loc));
    }

    private void error(String key2, String arg1, String arg2, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key2, arg1, arg2), loc));
    }

    private void error(String key2, String arg1, String arg2, String arg3, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key2, new Object[]{arg1, arg2, arg3}), loc));
    }

    private void noteError() {
        if (!this.hadError && this.parent != null) {
            this.parent.noteError();
        }
        this.hadError = true;
    }

    private static class IncludeImpl
    implements Include,
    Div {
        private SchemaBuilderImpl sb;
        private Override overrides;
        private GrammarImpl grammar;

        private IncludeImpl(SchemaBuilderImpl sb, GrammarImpl grammar) {
            this.sb = sb;
            this.grammar = grammar;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, ParsedPattern pattern2, Location loc, Annotations anno) throws BuildException {
            RefPattern rp = this.grammar.lookup(name);
            this.overrides = new Override(rp, this.overrides);
            this.grammar.define(rp, combine, pattern2, loc);
        }

        public void endDiv(Location loc, Annotations anno) throws BuildException {
        }

        @java.lang.Override
        public void topLevelAnnotation(ParsedElementAnnotation ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentList comments) throws BuildException {
        }

        @java.lang.Override
        public Div makeDiv() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endInclude(Parseable current, String uri, String ns, Location loc, Annotations anno) throws BuildException {
            OpenIncludes inc = this.sb.openIncludes;
            while (inc != null) {
                if (inc.uri.equals(uri)) {
                    this.sb.error("recursive_include", uri, (Locator)((Object)loc));
                    return;
                }
                inc = inc.parent;
            }
            Override o = this.overrides;
            while (o != null) {
                o.replacementStatus = o.prp.getReplacementStatus();
                o.prp.setReplacementStatus((byte)1);
                o = o.next;
            }
            try {
                SchemaBuilderImpl isb = new SchemaBuilderImpl(ns, uri, this.sb);
                current.parseInclude(uri, isb, new GrammarImpl(isb, this.grammar), ns);
                Override o2 = this.overrides;
                while (o2 != null) {
                    if (o2.prp.getReplacementStatus() == 1) {
                        if (o2.prp.getName() == null) {
                            this.sb.error("missing_start_replacement", (Locator)((Object)loc));
                        } else {
                            this.sb.error("missing_define_replacement", o2.prp.getName(), (Locator)((Object)loc));
                        }
                    }
                    o2 = o2.next;
                }
                o = this.overrides;
            }
            catch (IllegalSchemaException e) {
                try {
                    this.sb.noteError();
                    o = this.overrides;
                }
                catch (Throwable throwable) {
                    Override o3 = this.overrides;
                    while (o3 != null) {
                        o3.prp.setReplacementStatus(o3.replacementStatus);
                        o3 = o3.next;
                    }
                    throw throwable;
                }
                while (o != null) {
                    o.prp.setReplacementStatus(o.replacementStatus);
                    o = o.next;
                }
            }
            while (o != null) {
                o.prp.setReplacementStatus(o.replacementStatus);
                o = o.next;
            }
        }

        @java.lang.Override
        public Include makeInclude() {
            return null;
        }
    }

    static class Override {
        RefPattern prp;
        Override next;
        byte replacementStatus;

        Override(RefPattern prp, Override next) {
            this.prp = prp;
            this.next = next;
        }
    }

    static class GrammarImpl
    implements Grammar,
    Div,
    IncludedGrammar {
        private final SchemaBuilderImpl sb;
        private final Hashtable defines;
        private final RefPattern startRef;
        private final Scope parent;

        private GrammarImpl(SchemaBuilderImpl sb, Scope parent) {
            this.sb = sb;
            this.parent = parent;
            this.defines = new Hashtable();
            this.startRef = new RefPattern(null);
        }

        protected GrammarImpl(SchemaBuilderImpl sb, GrammarImpl g) {
            this.sb = sb;
            this.parent = g.parent;
            this.startRef = g.startRef;
            this.defines = g.defines;
        }

        public ParsedPattern endGrammar(Location loc, Annotations anno) throws BuildException {
            Enumeration e = this.defines.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                RefPattern rp = (RefPattern)this.defines.get(name);
                if (rp.getPattern() != null) continue;
                this.sb.error("reference_to_undefined", name, rp.getRefLocator());
                rp.setPattern(this.sb.pb.makeError());
            }
            Pattern start2 = this.startRef.getPattern();
            if (start2 == null) {
                this.sb.error("missing_start_element", (Locator)((Object)loc));
                start2 = this.sb.pb.makeError();
            }
            return start2;
        }

        public void endDiv(Location loc, Annotations anno) throws BuildException {
        }

        public ParsedPattern endIncludedGrammar(Location loc, Annotations anno) throws BuildException {
            return null;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, ParsedPattern pattern2, Location loc, Annotations anno) throws BuildException {
            this.define(this.lookup(name), combine, pattern2, loc);
        }

        private void define(RefPattern rp, GrammarSection.Combine combine, ParsedPattern pattern2, Location loc) throws BuildException {
            switch (rp.getReplacementStatus()) {
                case 0: {
                    if (combine == null) {
                        if (rp.isCombineImplicit()) {
                            if (rp.getName() == null) {
                                this.sb.error("duplicate_start", (Locator)((Object)loc));
                            } else {
                                this.sb.error("duplicate_define", rp.getName(), (Locator)((Object)loc));
                            }
                        } else {
                            rp.setCombineImplicit();
                        }
                    } else {
                        byte combineType;
                        byte by = combineType = combine == COMBINE_CHOICE ? (byte)1 : 2;
                        if (rp.getCombineType() != 0 && rp.getCombineType() != combineType) {
                            if (rp.getName() == null) {
                                this.sb.error("conflict_combine_start", (Locator)((Object)loc));
                            } else {
                                this.sb.error("conflict_combine_define", rp.getName(), (Locator)((Object)loc));
                            }
                        }
                        rp.setCombineType(combineType);
                    }
                    Pattern p = (Pattern)pattern2;
                    if (rp.getPattern() == null) {
                        rp.setPattern(p);
                        break;
                    }
                    if (rp.getCombineType() == 2) {
                        rp.setPattern(this.sb.pb.makeInterleave(rp.getPattern(), p));
                        break;
                    }
                    rp.setPattern(this.sb.pb.makeChoice(rp.getPattern(), p));
                    break;
                }
                case 1: {
                    rp.setReplacementStatus((byte)2);
                    break;
                }
            }
        }

        @java.lang.Override
        public void topLevelAnnotation(ParsedElementAnnotation ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentList comments) throws BuildException {
        }

        private RefPattern lookup(String name) {
            if (name == "\u0000#start\u0000") {
                return this.startRef;
            }
            return this.lookup1(name);
        }

        private RefPattern lookup1(String name) {
            RefPattern p = (RefPattern)this.defines.get(name);
            if (p == null) {
                p = new RefPattern(name);
                this.defines.put(name, p);
            }
            return p;
        }

        @java.lang.Override
        public ParsedPattern makeRef(String name, Location loc, Annotations anno) throws BuildException {
            RefPattern p = this.lookup1(name);
            if (p.getRefLocator() == null && loc != null) {
                p.setRefLocator((Locator)((Object)loc));
            }
            return p;
        }

        @java.lang.Override
        public ParsedPattern makeParentRef(String name, Location loc, Annotations anno) throws BuildException {
            if (this.parent == null) {
                this.sb.error("parent_ref_outside_grammar", (Locator)((Object)loc));
                return this.sb.makeErrorPattern();
            }
            return this.parent.makeRef(name, loc, anno);
        }

        @java.lang.Override
        public Div makeDiv() {
            return this;
        }

        @java.lang.Override
        public Include makeInclude() {
            return new IncludeImpl(this.sb, this);
        }
    }

    private class DataPatternBuilderImpl
    implements DataPatternBuilder {
        private DatatypeBuilder dtb;

        DataPatternBuilderImpl(DatatypeBuilder dtb) {
            this.dtb = dtb;
        }

        public void addParam(String name, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
            try {
                this.dtb.addParameter(name, value, new ValidationContextImpl(context, ns));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                int pos = e.getIndex();
                String displayedParam = pos == -1 ? null : this.displayParam(value, pos);
                if (displayedParam != null) {
                    if (detail != null) {
                        SchemaBuilderImpl.this.error("invalid_param_detail_display", detail, displayedParam, (Locator)((Object)loc));
                    } else {
                        SchemaBuilderImpl.this.error("invalid_param_display", displayedParam, (Locator)((Object)loc));
                    }
                }
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_param_detail", detail, (Locator)((Object)loc));
                }
                SchemaBuilderImpl.this.error("invalid_param", (Locator)((Object)loc));
            }
        }

        String displayParam(String value, int pos) {
            if (pos < 0) {
                pos = 0;
            } else if (pos > value.length()) {
                pos = value.length();
            }
            return localizer.message("display_param", value.substring(0, pos), value.substring(pos));
        }

        public ParsedPattern makePattern(Location loc, Annotations anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeData(this.dtb.createDatatype());
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, (Locator)((Object)loc));
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", (Locator)((Object)loc));
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }

        public ParsedPattern makePattern(ParsedPattern except, Location loc, Annotations anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeDataExcept(this.dtb.createDatatype(), (Pattern)except, (Locator)((Object)loc));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, (Locator)((Object)loc));
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", (Locator)((Object)loc));
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }

        public void annotation(ParsedElementAnnotation ea) {
        }
    }

    private class ValidationContextImpl
    implements ValidationContext {
        private ValidationContext vc;
        private String ns;

        ValidationContextImpl(ValidationContext vc, String ns) {
            this.vc = vc;
            this.ns = ns.length() == 0 ? null : ns;
        }

        @java.lang.Override
        public String resolveNamespacePrefix(String prefix) {
            return prefix.length() == 0 ? this.ns : this.vc.resolveNamespacePrefix(prefix);
        }

        @java.lang.Override
        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        @java.lang.Override
        public boolean isUnparsedEntity(String entityName) {
            return this.vc.isUnparsedEntity(entityName);
        }

        @java.lang.Override
        public boolean isNotation(String notationName) {
            return this.vc.isNotation(notationName);
        }
    }

    private class DummyDataPatternBuilder
    implements DataPatternBuilder {
        private DummyDataPatternBuilder() {
        }

        public void addParam(String name, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
        }

        public ParsedPattern makePattern(Location loc, Annotations anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }

        public ParsedPattern makePattern(ParsedPattern except, Location loc, Annotations anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }

        public void annotation(ParsedElementAnnotation ea) {
        }
    }

    static class OpenIncludes {
        final String uri;
        final OpenIncludes parent;

        OpenIncludes(String uri, OpenIncludes parent) {
            this.uri = uri;
            this.parent = parent;
        }
    }
}

