/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteDb;
import org.jetbrains.sqlite.SqliteDbKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a*\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0000\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a \u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"BEGIN_TRANSACTION", "", "COMMIT", "ROLLBACK", "SQLITE_ALLOWED_TYPES", "", "Ljava/lang/Class;", "Ljava/io/Serializable;", "getSQLITE_ALLOWED_TYPES", "()Ljava/util/Set;", "savepointNameGenerator", "Ljava/util/concurrent/atomic/AtomicLong;", "bind", "", "statementPointer", "", "values", "", "db", "Lorg/jetbrains/sqlite/NativeDB;", "sqlBind", "pointer", "index", "", "v", "Lorg/jetbrains/sqlite/SqliteDb;", "step", "", "sql", "stepInBatch", "batchIndex", "intellij.platform.sqlite"})
public final class SqliteConnectionKt {
    @NotNull
    private static final byte[] BEGIN_TRANSACTION = StringsKt.encodeToByteArray((String)"begin transaction");
    @NotNull
    private static final byte[] COMMIT = StringsKt.encodeToByteArray((String)"commit");
    @NotNull
    private static final byte[] ROLLBACK = StringsKt.encodeToByteArray((String)"rollback");
    @NotNull
    private static final AtomicLong savepointNameGenerator = new AtomicLong();
    @NotNull
    private static final Set<Class<? extends Serializable>> SQLITE_ALLOWED_TYPES;

    public static final boolean step(long statementPointer, @NotNull byte[] sql2, @NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        int status = db.step(statementPointer) & 0xFF;
        return switch (status) {
            case 101 -> true;
            case 100 -> false;
            default -> {
                String v1 = db.errmsg();
                Intrinsics.checkNotNull((Object)v1);
                throw SqliteDbKt.newException(status, v1, sql2);
            }
        };
    }

    private static final void bind(long statementPointer, Object values, NativeDB db) {
        if (values == null) {
            return;
        }
        if (values instanceof Integer) {
            int status = db.bind_int(statementPointer, 1, ((Number)values).intValue());
            if (status != 0) {
                throw SqliteDb.newException$default(db, status, null, 2, null);
            }
        } else {
            Object[] cfr_ignored_0 = (Object[])values;
            Object[] objectArray = (Object[])values;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int index = i;
                Object value = objectArray[i];
                SqliteConnectionKt.sqlBind(statementPointer, index, value, db);
            }
        }
    }

    public static final void sqlBind(long pointer, int index, @Nullable Object v, @NotNull SqliteDb db) {
        int n;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        int position = index + 1;
        Object object = v;
        if (object == null) {
            n = db.bind_null(pointer, position);
        } else if (object instanceof Integer) {
            n = db.bind_int(pointer, position, ((Number)v).intValue());
        } else if (object instanceof Long) {
            n = db.bind_long(pointer, position, ((Number)v).longValue());
        } else if (object instanceof String) {
            n = db.bind_text(pointer, position, (String)v);
        } else if (object instanceof Short) {
            n = db.bind_int(pointer, position, ((Number)v).shortValue());
        } else if (object instanceof Float) {
            n = db.bind_double(pointer, position, ((Number)v).floatValue());
        } else if (object instanceof Double) {
            n = db.bind_double(pointer, position, ((Number)v).doubleValue());
        } else if (object instanceof byte[]) {
            n = db.bind_blob(pointer, position, (byte[])v);
        } else {
            throw new UnsupportedOperationException("Unexpected param type: " + v.getClass());
        }
        int status = n & 0xFF;
        if (status != 0) {
            throw SqliteDb.newException$default(db, status, null, 2, null);
        }
    }

    @NotNull
    public static final Set<Class<? extends Serializable>> getSQLITE_ALLOWED_TYPES() {
        return SQLITE_ALLOWED_TYPES;
    }

    public static final void stepInBatch(long statementPointer, @NotNull NativeDB db, int batchIndex) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        int status = db.step(statementPointer);
        if (status != 101) {
            db.reset(statementPointer);
            if (status == 100) {
                throw new IllegalStateException("batch entry " + batchIndex + ": query returns results");
            }
            throw SqliteDb.newException$default(db, status, null, 2, null);
        }
    }

    public static final /* synthetic */ AtomicLong access$getSavepointNameGenerator$p() {
        return savepointNameGenerator;
    }

    public static final /* synthetic */ void access$bind(long statementPointer, Object values, NativeDB db) {
        SqliteConnectionKt.bind(statementPointer, values, db);
    }

    public static final /* synthetic */ byte[] access$getBEGIN_TRANSACTION$p() {
        return BEGIN_TRANSACTION;
    }

    public static final /* synthetic */ byte[] access$getCOMMIT$p() {
        return COMMIT;
    }

    public static final /* synthetic */ byte[] access$getROLLBACK$p() {
        return ROLLBACK;
    }

    static {
        Object[] objectArray = new Class[]{Integer.TYPE, Integer.class, Long.TYPE, String.class, Short.TYPE, Float.TYPE, Double.TYPE, byte[].class};
        SQLITE_ALLOWED_TYPES = SetsKt.setOf((Object[])objectArray);
    }
}

