/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.psi.XmlPsiBundle;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDecl;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncNameImpl
extends RncElementImpl
implements RncName,
PsiReference,
EmptyResolveMessageProvider,
LocalQuickFixProvider {
    public RncNameImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public String getPrefix() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        return parts.length == 2 ? parts[0] : null;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        String[] parts = EscapeUtil.unescapeText(this.getNode()).split(":", 2);
        String string2 = parts.length == 1 ? parts[0] : parts[1];
        if (string2 == null) {
            RncNameImpl.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public void accept(@NotNull RncElementVisitor visitor) {
        if (visitor == null) {
            RncNameImpl.$$$reportNull$$$0(1);
        }
        visitor.visitName(this);
    }

    public PsiReference getReference() {
        return this.getPrefix() == null ? null : this;
    }

    @NotNull
    public PsiElement getElement() {
        RncNameImpl rncNameImpl = this;
        if (rncNameImpl == null) {
            RncNameImpl.$$$reportNull$$$0(2);
        }
        return rncNameImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)0, (int)this.getText().indexOf(58));
        if (textRange == null) {
            RncNameImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        MyResolver resolver = new MyResolver(this.getPrefix(), this.getKind());
        this.getContainingFile().processDeclarations((PsiScopeProcessor)resolver, ResolveState.initial(), (PsiElement)this, (PsiElement)this);
        return resolver.getResult();
    }

    private Kind getKind() {
        IElementType parent = this.getNode().getTreeParent().getElementType();
        if (parent == RncElementTypes.DATATYPE_PATTERN) {
            return Kind.DATATYPES;
        }
        return Kind.NAMESPACE;
    }

    @NotNull
    public String getCanonicalText() {
        String string2 = this.getRangeInElement().substring(this.getText());
        if (string2 == null) {
            RncNameImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            RncNameImpl.$$$reportNull$$$0(5);
        }
        ASTNode node = this.getNode();
        ASTNode child = RenameUtil.createPrefixedNode((PsiManager)this.getManager(), newElementName, this.getLocalPart());
        node.getTreeParent().replaceChild(node, child);
        return child.getPsi();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RncNameImpl.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            RncNameImpl.$$$reportNull$$$0(7);
        }
        return element instanceof RncElement && Comparing.equal((Object)this.resolve(), (Object)element);
    }

    public boolean isSoft() {
        String prefix = this.getPrefix();
        return "xsd".equals(prefix) || "xml".equals(prefix);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string2 = RelaxngBundle.message("relaxng.annotator.unresolved-namespace-prefix", new Object[0]);
        if (string2 == null) {
            RncNameImpl.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        if (this.getPrefix() != null) {
            return new LocalQuickFix[]{new CreateDeclFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPart";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyResolver
    implements PsiScopeProcessor {
        private final String myPrefix;
        private final Kind myKind;
        private PsiElement myResult;

        MyResolver(String prefix, Kind kind) {
            this.myPrefix = prefix;
            this.myKind = kind;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
            ASTNode node;
            if (element == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (substitutor == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            if ((node = element.getNode()) == null) {
                return true;
            }
            if (!(element instanceof RncDecl)) {
                return false;
            }
            IElementType type2 = node.getElementType();
            return !(this.myKind == Kind.NAMESPACE && type2 == RncElementTypes.NS_DECL ? this.checkDecl(element) : this.myKind == Kind.DATATYPES && type2 == RncElementTypes.DATATYPES_DECL && this.checkDecl(element));
        }

        private boolean checkDecl(PsiElement element) {
            if (this.myPrefix.equals(((RncDecl)element).getPrefix())) {
                this.myResult = element;
                return true;
            }
            return false;
        }

        public PsiElement getResult() {
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutor";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$MyResolver";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Kind {
        NAMESPACE,
        DATATYPES;

    }

    public static class CreateDeclFix
    implements LocalQuickFix {
        @NotNull
        @Nls
        private final String myName;

        public CreateDeclFix(RncNameImpl reference) {
            this.myName = RelaxngBundle.message("relaxng.quickfix.create-declaration.name", StringUtil.toLowerCase((String)reference.getKind().name()), reference.getPrefix());
        }

        @NotNull
        public String getName() {
            String string2 = this.myName;
            if (string2 == null) {
                CreateDeclFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = XmlPsiBundle.message("xml.quickfix.create.namespace.declaration.family", new Object[0]);
            if (string2 == null) {
                CreateDeclFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            RncGrammar rncGrammar;
            if (project2 == null) {
                CreateDeclFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateDeclFix.$$$reportNull$$$0(3);
            }
            RncNameImpl myReference = (RncNameImpl)descriptor.getPsiElement();
            String prefix = myReference.getPrefix();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)myReference.getProject());
            RncFile psiFile = (RncFile)factory.createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)(StringUtil.toLowerCase((String)myReference.getKind().name()) + " " + prefix + " = \"###\""));
            RncFile rncFile = (RncFile)myReference.getContainingFile();
            RncDecl[] declarations = rncFile.getDeclarations();
            RncDecl decl = psiFile.getDeclarations()[0];
            RncDecl e = declarations.length > 0 ? (RncDecl)rncFile.addAfter(decl, declarations[declarations.length - 1]) : ((rncGrammar = rncFile.getGrammar()) != null ? (RncDecl)rncFile.addBefore(decl, rncGrammar) : (RncDecl)rncFile.add(decl));
            ASTNode blockNode = e.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            PsiElement literal = e.getLastChild();
            assert (literal != null);
            ASTNode literalNode = literal.getNode();
            assert (literalNode != null);
            assert (literalNode.getElementType() == RncTokenTypes.LITERAL);
            int offset = literal.getTextRange().getStartOffset();
            literal.delete();
            VirtualFile virtualFile = myReference.getElement().getContainingFile().getVirtualFile();
            if (virtualFile != null && (editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile, offset), true)) != null) {
                RncDecl rncDecl = (RncDecl)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)e);
                TemplateManager manager = TemplateManager.getInstance((Project)project2);
                Template t = manager.createTemplate("", "");
                t.addTextSegment(" \"");
                ConstantNode expression = new ConstantNode("");
                t.addVariable("uri", (Expression)expression, (Expression)expression, true);
                t.addTextSegment("\"");
                t.addEndVariable();
                editor.getCaretModel().moveToOffset(rncDecl.getTextRange().getEndOffset());
                manager.startTemplate(editor, t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/RncNameImpl$CreateDeclFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

