/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dom.DomAttributeXmlDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildrenDescriptor
implements XmlElementDescriptor {
    protected final DomManager myManager;

    protected AbstractDomChildrenDescriptor(DomManager manager) {
        this.myManager = manager;
    }

    @Override
    public XmlElementDescriptor[] getElementsDescriptors(final XmlTag context) {
        final DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<XmlElementDescriptor> xmlElementDescriptors = new ArrayList<XmlElementDescriptor>();
        for (DomCollectionChildDescription domCollectionChildDescription : domElement.getGenericInfo().getCollectionChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor(domCollectionChildDescription, this.myManager));
        }
        for (DomFixedChildDescription domFixedChildDescription : domElement.getGenericInfo().getFixedChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor(domFixedChildDescription, this.myManager));
        }
        List<? extends CustomDomChildrenDescription> customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription customDomChildrenDescription : customs) {
            final CustomDomChildrenDescription.TagNameDescriptor tagNameDescriptor = customDomChildrenDescription.getTagNameDescriptor();
            if (tagNameDescriptor == null) continue;
            final XmlTag xmlTag = domElement.getXmlTag();
            for (final EvaluatedXmlName name : tagNameDescriptor.getCompletionVariants(domElement)) {
                AbstractDomChildrenDescriptor descriptor = new AbstractDomChildrenDescriptor(this.myManager){

                    @Override
                    public String getDefaultName() {
                        String prefix;
                        String ns;
                        String string2 = ns = xmlTag != null ? name.getNamespace(xmlTag, (XmlFile)xmlTag.getContainingFile()) : null;
                        if (ns != null && (prefix = xmlTag.getPrefixByNamespace(ns)) != null) {
                            return prefix + ":" + name.getXmlName().getLocalName();
                        }
                        return name.getXmlName().getLocalName();
                    }

                    @Nullable
                    public PsiElement getDeclaration() {
                        PomTarget target = tagNameDescriptor.findDeclaration(domElement, name);
                        return target == null ? null : PomService.convertToPsi((Project)context.getProject(), (PomTarget)target);
                    }
                };
                xmlElementDescriptors.add(descriptor);
            }
            xmlElementDescriptors.add(new AnyXmlElementDescriptor(this, this.getNSDescriptor()));
        }
        return xmlElementDescriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    @Override
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(final @NotNull XmlTag childTag, @Nullable XmlTag contextTag) {
        DomElement domElement;
        if (childTag == null) {
            AbstractDomChildrenDescriptor.$$$reportNull$$$0(0);
        }
        if ((domElement = this.myManager.getDomElement(childTag)) == null) {
            AbstractDomChildrenDescription description2;
            domElement = this.myManager.getDomElement(contextTag);
            if (domElement != null && (description2 = this.myManager.findChildrenDescription(childTag, domElement)) instanceof DomChildrenDescription) {
                return new DomElementXmlDescriptor((DomChildrenDescription)description2, this.myManager);
            }
            return null;
        }
        DomElement parent = domElement.getParent();
        if (parent == null) {
            return new DomElementXmlDescriptor(domElement);
        }
        final AbstractDomChildrenDescription description3 = domElement.getChildDescription();
        if (description3 instanceof CustomDomChildrenDescription) {
            final DomElement finalDomElement = domElement;
            return new AbstractDomChildrenDescriptor(this.myManager){

                @Override
                public String getDefaultName() {
                    return finalDomElement.getXmlElementName();
                }

                @Nullable
                public PsiElement getDeclaration() {
                    PomTarget target = ((CustomDomChildrenDescription)description3).getTagNameDescriptor().findDeclaration(finalDomElement);
                    if (target == description3) {
                        return childTag;
                    }
                    return target == null ? null : PomService.convertToPsi((Project)childTag.getProject(), (PomTarget)target);
                }
            };
        }
        if (!(description3 instanceof DomChildrenDescription)) {
            return null;
        }
        return new DomElementXmlDescriptor((DomChildrenDescription)description3, this.myManager);
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        List<DomAttributeChildDescription<?>> descriptions = domElement.getGenericInfo().getAttributeChildrenDescriptions();
        ArrayList<DomAttributeXmlDescriptor> descriptors = new ArrayList<DomAttributeXmlDescriptor>();
        for (DomAttributeChildDescription<?> description2 : descriptions) {
            descriptors.add(new DomAttributeXmlDescriptor(description2, this.myManager.getProject()));
        }
        List<? extends CustomDomChildrenDescription> customs = domElement.getGenericInfo().getCustomNameChildrenDescription();
        for (CustomDomChildrenDescription customDomChildrenDescription : customs) {
            CustomDomChildrenDescription.AttributeDescriptor descriptor = customDomChildrenDescription.getCustomAttributeDescriptor();
            if (descriptor == null) continue;
            for (EvaluatedXmlName variant : descriptor.getCompletionVariants(domElement)) {
                AttributeChildDescriptionImpl childDescription = new AttributeChildDescriptionImpl(variant.getXmlName(), (Type)((Object)String.class));
                descriptors.add(new DomAttributeXmlDescriptor(childDescription, this.myManager.getProject()));
            }
        }
        return descriptors.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return null;
        }
        for (DomAttributeChildDescription<?> description2 : domElement.getGenericInfo().getAttributeChildrenDescriptions()) {
            if (!attributeName.equals(DomAttributeXmlDescriptor.getQualifiedAttributeName(context, description2.getXmlName()))) continue;
            return new DomAttributeXmlDescriptor(description2, this.myManager.getProject());
        }
        return null;
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    @Override
    public XmlNSDescriptor getNSDescriptor() {
        return new XmlNSDescriptor(){

            @Override
            @Nullable
            public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
                if (tag == null) {
                    3.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Method getElementDescriptor not implemented in " + this.getClass());
            }

            @Override
            public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document2) {
                throw new UnsupportedOperationException("Method getRootElementsDescriptors not implemented in " + this.getClass());
            }

            @Override
            @Nullable
            public XmlFile getDescriptorFile() {
                return null;
            }

            @Nullable
            public PsiElement getDeclaration() {
                throw new UnsupportedOperationException("Method getDeclaration not implemented in " + this.getClass());
            }

            @NonNls
            public String getName(PsiElement context) {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            @NonNls
            public String getName() {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            public void init(PsiElement element) {
                throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
            }

            public Object @NotNull [] getDependencies() {
                throw new UnsupportedOperationException("Method getDependencies not implemented in " + this.getClass());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor$3", "getElementDescriptor"));
            }
        };
    }

    @Override
    public int getContentType() {
        return -1;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    public Object @NotNull [] getDependencies() {
        throw new UnsupportedOperationException("Method getDependencies not implemented in " + this.getClass());
    }

    @NonNls
    public String getName() {
        return this.getDefaultName();
    }

    @Override
    public String getQualifiedName() {
        return this.getDefaultName();
    }

    public String getName(PsiElement context) {
        return this.getDefaultName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTag", "com/intellij/xml/impl/dom/AbstractDomChildrenDescriptor", "getElementDescriptor"));
    }
}

