/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.webSymbols.webTypes.json.GenericJsContribution;
import com.intellij.webSymbols.webTypes.json.GenericJsContributions;
import com.intellij.webSymbols.webTypes.json.JsContributionsHost;
import com.intellij.webSymbols.webTypes.json.JsProperty;
import com.intellij.webSymbols.webTypes.json.TypedContribution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kind", "events", "properties", "symbols"})
public class JsSymbol
extends TypedContribution
implements JsContributionsHost {
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Kind of the symbol. Default is variable.")
    private Kind kind;
    @JsonProperty(value="events")
    @JsonPropertyDescription(value="DOM events")
    private List<GenericJsContribution> events = new ArrayList<GenericJsContribution>();
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="JavaScript properties of an object, HTML tag, framework component, etc.")
    private List<JsProperty> properties = new ArrayList<JsProperty>();
    @JsonProperty(value="symbols")
    @JsonPropertyDescription(value="Symbols available for JavaScript resolve. TypeScript resolve is not supported.")
    private List<JsSymbol> symbols = new ArrayList<JsSymbol>();
    @JsonIgnore
    private Map<String, GenericJsContributions> additionalProperties = new HashMap<String, GenericJsContributions>();

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="events")
    public List<GenericJsContribution> getEvents() {
        return this.events;
    }

    @Override
    @JsonProperty(value="events")
    public void setEvents(List<GenericJsContribution> events) {
        this.events = events;
    }

    @Override
    @JsonProperty(value="properties")
    public List<JsProperty> getProperties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="properties")
    public void setProperties(List<JsProperty> properties2) {
        this.properties = properties2;
    }

    @Override
    @JsonProperty(value="symbols")
    public List<JsSymbol> getSymbols() {
        return this.symbols;
    }

    @Override
    @JsonProperty(value="symbols")
    public void setSymbols(List<JsSymbol> symbols) {
        this.symbols = symbols;
    }

    @Override
    @JsonAnyGetter
    public Map<String, GenericJsContributions> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, GenericJsContributions value) {
        this.additionalProperties.put(name, value);
    }

    public static enum Kind {
        VARIABLE("Variable"),
        FUNCTION("Function"),
        NAMESPACE("Namespace"),
        CLASS("Class"),
        INTERFACE("Interface"),
        ENUM("Enum"),
        ALIAS("Alias"),
        MODULE("Module");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

