/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.webSymbols.webTypes.json.Css;
import com.intellij.webSymbols.webTypes.json.Deprecated;
import com.intellij.webSymbols.webTypes.json.DescriptionSections;
import com.intellij.webSymbols.webTypes.json.Experimental;
import com.intellij.webSymbols.webTypes.json.GenericContributionsHost;
import com.intellij.webSymbols.webTypes.json.Html;
import com.intellij.webSymbols.webTypes.json.Js;
import com.intellij.webSymbols.webTypes.json.NamePatternRoot;
import com.intellij.webSymbols.webTypes.json.Obsolete;
import com.intellij.webSymbols.webTypes.json.Reference;
import com.intellij.webSymbols.webTypes.json.RequiredContextBase;
import com.intellij.webSymbols.webTypes.json.SourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "description", "description-sections", "required-context", "doc-url", "icon", "source", "since", "deprecated", "deprecated-since", "obsolete", "obsolete-since", "experimental", "priority", "proximity", "virtual", "abstract", "extension", "extends", "pattern", "html", "css", "js", "exclusive-contributions"})
public abstract class BaseContribution
implements GenericContributionsHost {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Short description to be rendered in documentation popup. It will be rendered according to description-markup setting.")
    private String description;
    @JsonProperty(value="description-sections")
    @JsonPropertyDescription(value="Custom sections to be shown below description in the documentation popup.")
    private DescriptionSections descriptionSections;
    @JsonProperty(value="required-context")
    private RequiredContextBase requiredContext;
    @JsonProperty(value="doc-url")
    @JsonPropertyDescription(value="Link to online documentation.")
    private String docUrl;
    @JsonProperty(value="icon")
    @JsonPropertyDescription(value="Relative path to the icon representing the symbol or actual SVG of the icon.")
    private String icon;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="Allows to specify the source of the entity. For Vue.js component this may be for instance a class.")
    private SourceBase source;
    @JsonProperty(value="since")
    @JsonPropertyDescription(value="Version since this symbol is available.")
    private String since;
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Specifies whether the symbol is deprecated. Deprecated symbol usage is discouraged, but still supported. Value can be a boolean or a string message with explanation and migration information.")
    private Deprecated deprecated = null;
    @JsonProperty(value="deprecated-since")
    @JsonPropertyDescription(value="Version in which this symbol was first deprecated.")
    private String deprecatedSince;
    @JsonProperty(value="obsolete")
    @JsonPropertyDescription(value="Specifies whether the symbol is obsolete. Obsolete symbols are no longer supported. Value can be a boolean or a string message with explanation and migration information.")
    private Obsolete obsolete = null;
    @JsonProperty(value="obsolete-since")
    @JsonPropertyDescription(value="Version in which this symbol was first made obsolete.")
    private String obsoleteSince;
    @JsonProperty(value="experimental")
    @JsonPropertyDescription(value="Specifies whether the symbol is experimental. Value can be a boolean or a string message with explanation. Experimental symbols should be used with caution as the API might change.")
    private Experimental experimental = null;
    @JsonProperty(value="priority")
    private Priority priority;
    @JsonProperty(value="proximity")
    private Integer proximity;
    @JsonProperty(value="virtual")
    @JsonPropertyDescription(value="Mark contribution as virtual. Virtual contributions can be filtered out if needed in references. A virtual contribution meaning may differ by framework or kind contexts, but usually means something synthetic or something, which gets erased in the runtime by the framework. E.g. Vue or Angular attribute bindings are virtual. ")
    private Boolean virtual;
    @JsonProperty(value="abstract")
    @JsonPropertyDescription(value="Mark contribution as abstract. Such contributions serve only as super contributions for other contributions.")
    private Boolean _abstract;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Mark contribution as an extension. Such contributions do not define a new contribution on their own, but can provide additional properties or contributions to existing contributions.")
    private Boolean extension;
    @JsonProperty(value="extends")
    @JsonPropertyDescription(value="A reference to an element in Web-Types model.")
    private Reference _extends;
    @JsonProperty(value="pattern")
    private NamePatternRoot pattern;
    @JsonProperty(value="html")
    @JsonPropertyDescription(value="Contains contributions to HTML namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are 2 predefined kinds, which integrate directly with IDE - HTML elements and HTML attributes. There are also 2 deprecated kinds: tags (which is equivalent to 'elements') and 'events' (which was moved to JS namespace)")
    private Html html;
    @JsonProperty(value="css")
    @JsonPropertyDescription(value="Contains contributions to CSS namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are predefined kinds, which integrate directly with IDE - properties, classes, functions, pseudo-elements, pseudo-classes and parts.")
    private Css css;
    @JsonProperty(value="js")
    @JsonPropertyDescription(value="Contains contributions to JS namespace. It's property names represent symbol kinds, its property values contain list of contributions of particular kind. There are 2 predefined kinds, which integrate directly with IDE - properties and events.")
    private Js js;
    @JsonProperty(value="exclusive-contributions")
    @JsonPropertyDescription(value="Specify list of contribution kinds qualified with a namespace, for which during reference resolution this will be the final contribution host. E.g. if a special HTML element does not accept standard attributes, add:\n\"exclusive-contributions\": [\"/html/attributes\"].")
    private List<String> exclusiveContributions = new ArrayList<String>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description2) {
        this.description = description2;
    }

    @JsonProperty(value="description-sections")
    public DescriptionSections getDescriptionSections() {
        return this.descriptionSections;
    }

    @JsonProperty(value="description-sections")
    public void setDescriptionSections(DescriptionSections descriptionSections2) {
        this.descriptionSections = descriptionSections2;
    }

    @JsonProperty(value="required-context")
    public RequiredContextBase getRequiredContext() {
        return this.requiredContext;
    }

    @JsonProperty(value="required-context")
    public void setRequiredContext(RequiredContextBase requiredContext) {
        this.requiredContext = requiredContext;
    }

    @JsonProperty(value="doc-url")
    public String getDocUrl() {
        return this.docUrl;
    }

    @JsonProperty(value="doc-url")
    public void setDocUrl(String docUrl2) {
        this.docUrl = docUrl2;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon")
    public void setIcon(String icon2) {
        this.icon = icon2;
    }

    @JsonProperty(value="source")
    public SourceBase getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceBase source2) {
        this.source = source2;
    }

    @JsonProperty(value="since")
    public String getSince() {
        return this.since;
    }

    @JsonProperty(value="since")
    public void setSince(String since) {
        this.since = since;
    }

    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @JsonProperty(value="deprecated-since")
    public String getDeprecatedSince() {
        return this.deprecatedSince;
    }

    @JsonProperty(value="deprecated-since")
    public void setDeprecatedSince(String deprecatedSince) {
        this.deprecatedSince = deprecatedSince;
    }

    @JsonProperty(value="obsolete")
    public Obsolete getObsolete() {
        return this.obsolete;
    }

    @JsonProperty(value="obsolete")
    public void setObsolete(Obsolete obsolete) {
        this.obsolete = obsolete;
    }

    @JsonProperty(value="obsolete-since")
    public String getObsoleteSince() {
        return this.obsoleteSince;
    }

    @JsonProperty(value="obsolete-since")
    public void setObsoleteSince(String obsoleteSince) {
        this.obsoleteSince = obsoleteSince;
    }

    @JsonProperty(value="experimental")
    public Experimental getExperimental() {
        return this.experimental;
    }

    @JsonProperty(value="experimental")
    public void setExperimental(Experimental experimental) {
        this.experimental = experimental;
    }

    @JsonProperty(value="priority")
    public Priority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Priority priority2) {
        this.priority = priority2;
    }

    @JsonProperty(value="proximity")
    public Integer getProximity() {
        return this.proximity;
    }

    @JsonProperty(value="proximity")
    public void setProximity(Integer proximity2) {
        this.proximity = proximity2;
    }

    @JsonProperty(value="virtual")
    public Boolean getVirtual() {
        return this.virtual;
    }

    @JsonProperty(value="virtual")
    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    @JsonProperty(value="abstract")
    public Boolean getAbstract() {
        return this._abstract;
    }

    @JsonProperty(value="abstract")
    public void setAbstract(Boolean _abstract) {
        this._abstract = _abstract;
    }

    @JsonProperty(value="extension")
    public Boolean getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Boolean extension) {
        this.extension = extension;
    }

    @JsonProperty(value="extends")
    public Reference getExtends() {
        return this._extends;
    }

    @JsonProperty(value="extends")
    public void setExtends(Reference _extends) {
        this._extends = _extends;
    }

    @JsonProperty(value="pattern")
    public NamePatternRoot getPattern() {
        return this.pattern;
    }

    @JsonProperty(value="pattern")
    public void setPattern(NamePatternRoot pattern2) {
        this.pattern = pattern2;
    }

    @JsonProperty(value="html")
    public Html getHtml() {
        return this.html;
    }

    @JsonProperty(value="html")
    public void setHtml(Html html) {
        this.html = html;
    }

    @JsonProperty(value="css")
    public Css getCss() {
        return this.css;
    }

    @JsonProperty(value="css")
    public void setCss(Css css) {
        this.css = css;
    }

    @JsonProperty(value="js")
    public Js getJs() {
        return this.js;
    }

    @JsonProperty(value="js")
    public void setJs(Js js) {
        this.js = js;
    }

    @JsonProperty(value="exclusive-contributions")
    public List<String> getExclusiveContributions() {
        return this.exclusiveContributions;
    }

    @JsonProperty(value="exclusive-contributions")
    public void setExclusiveContributions(List<String> exclusiveContributions) {
        this.exclusiveContributions = exclusiveContributions;
    }

    public static enum Priority {
        LOWEST("lowest"),
        LOW("low"),
        NORMAL("normal"),
        HIGH("high"),
        HIGHEST("highest");

        private final String value;
        private static final Map<String, Priority> CONSTANTS;

        private Priority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Priority fromValue(String value) {
            Priority constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Priority>();
            for (Priority c : Priority.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

