/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlBuilderDriver {
    private final Stack<String> myNamespacesStack = new Stack();
    private final Stack<String> myPrefixesStack = new Stack();
    private final CharSequence myText;
    @NonNls
    private static final String XMLNS = "xmlns";
    @NonNls
    private static final String XMLNS_COLON = "xmlns:";

    public XmlBuilderDriver(CharSequence text2) {
        this.myText = text2;
    }

    protected CharSequence getText() {
        return this.myText;
    }

    public void addImplicitBinding(@NonNls @NotNull String prefix, @NonNls @NotNull String namespace) {
        if (prefix == null) {
            XmlBuilderDriver.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            XmlBuilderDriver.$$$reportNull$$$0(1);
        }
        this.myNamespacesStack.push((Object)namespace);
        this.myPrefixesStack.push((Object)prefix);
    }

    public void build(XmlBuilder builder2) {
        PsiBuilder b = this.createBuilderAndParse();
        FlyweightCapableTreeStructure structure = b.getLightTree();
        LighterASTNode root = (LighterASTNode)structure.getRoot();
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)root, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt instanceof IXmlTagElementType) {
                this.processTagNode(b, (FlyweightCapableTreeStructure<LighterASTNode>)structure, child, builder2);
                continue;
            }
            if (tt != XmlElementType.XML_PROLOG) continue;
            this.processPrologNode(b, builder2, (FlyweightCapableTreeStructure<LighterASTNode>)structure, child);
        }
        structure.disposeChildren(children, count);
    }

    private void processPrologNode(PsiBuilder psiBuilder, XmlBuilder builder2, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode prolog) {
        Ref prologChildren = new Ref(null);
        int prologChildrenCount = structure.getChildren((Object)prolog, prologChildren);
        for (int i = 0; i < prologChildrenCount; ++i) {
            LighterASTNode node = ((LighterASTNode[])prologChildren.get())[i];
            IElementType type2 = node.getTokenType();
            if (type2 == XmlElementType.XML_DOCTYPE) {
                this.processDoctypeNode(builder2, structure, node);
                break;
            }
            if (type2 != TokenType.ERROR_ELEMENT) continue;
            XmlBuilderDriver.processErrorNode(psiBuilder, node, builder2);
        }
    }

    private void processDoctypeNode(XmlBuilder builder2, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode doctype) {
        Ref tokens = new Ref(null);
        int tokenCount = structure.getChildren((Object)doctype, tokens);
        if (tokenCount > 0) {
            CharSequence publicId = null;
            boolean afterPublic = false;
            CharSequence systemId = null;
            boolean afterSystem = false;
            for (int i = 0; i < tokenCount; ++i) {
                LighterASTNode token = ((LighterASTNode[])tokens.get())[i];
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_PUBLIC) {
                    afterPublic = true;
                    continue;
                }
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_SYSTEM) {
                    afterSystem = true;
                    continue;
                }
                if (token.getTokenType() == TokenType.WHITE_SPACE || token.getTokenType() == XmlElementType.XML_COMMENT) continue;
                if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    if (afterPublic) {
                        publicId = this.getTokenText(token);
                    } else if (afterSystem) {
                        systemId = this.getTokenText(token);
                    }
                }
                afterSystem = false;
                afterPublic = false;
            }
            builder2.doctype(publicId, systemId, doctype.getStartOffset(), doctype.getEndOffset());
        }
    }

    private CharSequence getTokenText(LighterASTNode token) {
        return this.myText.subSequence(token.getStartOffset(), token.getEndOffset());
    }

    protected PsiBuilder createBuilderAndParse() {
        ParserDefinition xmlParserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)XMLLanguage.INSTANCE);
        assert (xmlParserDefinition != null);
        PsiBuilder b = PsiBuilderFactory.getInstance().createBuilder(xmlParserDefinition, xmlParserDefinition.createLexer(null), this.myText);
        new XmlParsing(b).parseDocument();
        return b;
    }

    private static void processErrorNode(PsiBuilder psiBuilder, LighterASTNode node, XmlBuilder builder2) {
        assert (node.getTokenType() == TokenType.ERROR_ELEMENT);
        String message2 = PsiBuilderImpl.getErrorMessage((LighterASTNode)node);
        assert (message2 != null);
        builder2.error(message2, node.getStartOffset(), node.getEndOffset());
    }

    private void processTagNode(PsiBuilder psiBuilder, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode node, XmlBuilder builder2) {
        String namespace;
        CharSequence localName;
        XmlBuilder.ProcessingOrder order;
        IElementType nodeTT = node.getTokenType();
        assert (nodeTT instanceof IXmlTagElementType);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        int stackFrameSize = this.myNamespacesStack.size();
        CharSequence tagName = "";
        int headerEndOffset = node.getEndOffset();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt instanceof IXmlAttributeElementType) {
                this.checkForXmlns(child, structure);
            }
            if (tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                headerEndOffset = child.getEndOffset();
                break;
            }
            if (tt != XmlTokenType.XML_NAME && tt != XmlTokenType.XML_TAG_NAME) continue;
            tagName = this.getTokenText(child);
        }
        boolean processAttrs = (order = builder2.startTag(localName = XmlUtil.getLocalName(tagName), namespace = this.getNamespace(tagName), node.getStartOffset(), node.getEndOffset(), headerEndOffset)) == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        boolean processTexts = order == XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            if (tt == TokenType.ERROR_ELEMENT) {
                XmlBuilderDriver.processErrorNode(psiBuilder, child, builder2);
            }
            if (tt instanceof IXmlTagElementType) {
                this.processTagNode(psiBuilder, structure, child, builder2);
            }
            if (processAttrs && tt instanceof IXmlAttributeElementType) {
                this.processAttributeNode(child, structure, builder2);
            }
            if (processTexts && tt == XmlElementType.XML_TEXT) {
                this.processTextNode(structure, child, builder2);
            }
            if (tt != XmlElementType.XML_ENTITY_REF) continue;
            builder2.entityRef(this.getTokenText(child), child.getStartOffset(), child.getEndOffset());
        }
        builder2.endTag(localName, namespace, node.getStartOffset(), node.getEndOffset());
        int framesToDrop = this.myNamespacesStack.size() - stackFrameSize;
        for (int i = 0; i < framesToDrop; ++i) {
            this.myNamespacesStack.pop();
            this.myPrefixesStack.pop();
        }
        structure.disposeChildren(children, count);
    }

    private void processTextNode(FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode node, XmlBuilder builder2) {
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            IElementType tt = child.getTokenType();
            int start2 = child.getStartOffset();
            int end = child.getEndOffset();
            CharSequence physical = this.getTokenText(child);
            if (XmlTokenType.COMMENTS.contains(tt)) continue;
            if (tt == XmlTokenType.XML_CDATA_START || tt == XmlTokenType.XML_CDATA_END) {
                builder2.textElement("", physical, start2, end);
                continue;
            }
            if (tt == XmlElementType.XML_CDATA) {
                this.processTextNode(structure, child, builder2);
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                builder2.textElement(new String(new char[]{XmlUtil.getCharFromEntityRef(physical.toString())}), physical, start2, end);
                continue;
            }
            builder2.textElement(physical, physical, start2, end);
        }
        structure.disposeChildren(children, count);
    }

    private void processAttributeNode(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure, XmlBuilder builder2) {
        builder2.attribute(this.getAttributeName(attrNode, structure), this.getAttributeValue(attrNode, structure), attrNode.getStartOffset(), attrNode.getEndOffset());
    }

    private String getNamespace(CharSequence tagName) {
        int pos = StringUtil.indexOf((CharSequence)tagName, (char)':');
        String namespacePrefix = pos == -1 ? "" : tagName.subSequence(0, pos).toString();
        for (int i = this.myPrefixesStack.size() - 1; i >= 0; --i) {
            if (!namespacePrefix.equals(this.myPrefixesStack.get(i))) continue;
            return (String)this.myNamespacesStack.get(i);
        }
        return "";
    }

    private void checkForXmlns(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        CharSequence name = this.getAttributeName(attrNode, structure);
        if (Comparing.equal((CharSequence)name, (CharSequence)XMLNS)) {
            this.myPrefixesStack.push((Object)"");
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        } else if (StringUtil.startsWith((CharSequence)name, (CharSequence)XMLNS_COLON)) {
            this.myPrefixesStack.push((Object)name.subSequence(XMLNS_COLON.length(), name.length()).toString());
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        }
    }

    private CharSequence getAttributeName(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        return this.findTextByTokenType(attrNode, structure, XmlTokenType.XML_NAME);
    }

    private CharSequence getAttributeValue(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        CharSequence fullValue = this.findTextByTokenType(attrNode, structure, XmlElementType.XML_ATTRIBUTE_VALUE);
        int start2 = 0;
        if (fullValue.length() > 0 && fullValue.charAt(0) == '\"') {
            ++start2;
        }
        int end = fullValue.length();
        if (fullValue.length() > start2 && fullValue.charAt(fullValue.length() - 1) == '\"') {
            --end;
        }
        return fullValue.subSequence(start2, end);
    }

    private CharSequence findTextByTokenType(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure, IElementType tt) {
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)attrNode, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        CharSequence name = "";
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children[i];
            if (child.getTokenType() != tt) continue;
            name = this.getTokenText(child);
            break;
        }
        structure.disposeChildren(children, count);
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "namespace";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/parsing/xml/XmlBuilderDriver";
        objectArray[2] = "addImplicitBinding";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

