/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonTrailingCommaRemover
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement rootPsi;
        if (element == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(1);
        }
        if ((rootPsi = element.getPsi()).getLanguage() != JsonLanguage.INSTANCE) {
            TextRange textRange = range;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        JsonCodeStyleSettings settings = (JsonCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)rootPsi.getContainingFile(), JsonCodeStyleSettings.class);
        if (settings.KEEP_TRAILING_COMMA) {
            TextRange textRange = range;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document2 = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document2 == null) {
            TextRange textRange = range;
            if (textRange == null) {
                JsonTrailingCommaRemover.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        DocumentUtil.executeInBulk((Document)document2, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
            Visitor visitor = new Visitor(document2);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document2);
        });
        TextRange textRange = range;
        if (textRange == null) {
            JsonTrailingCommaRemover.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/formatter/JsonTrailingCommaRemover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/formatter/JsonTrailingCommaRemover";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }

    private static final class Visitor
    extends JsonRecursiveElementVisitor {
        private final Document myDocument;
        private int myOffsetDelta;

        Visitor(Document document2) {
            this.myDocument = document2;
        }

        @Override
        public void visitArray(@NotNull JsonArray o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitArray(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_BRACKET) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ContainerUtil.getLastItem(o.getValueList())), (Object)o.getFirstChild()));
        }

        @Override
        public void visitObject(@NotNull JsonObject o) {
            if (o == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitObject(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_CURLY) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ContainerUtil.getLastItem(o.getPropertyList())), (Object)o.getFirstChild()));
        }

        private void deleteTrailingCommas(@Nullable PsiElement lastElementOrOpeningBrace) {
            PsiElement element;
            PsiElement psiElement = element = lastElementOrOpeningBrace != null ? lastElementOrOpeningBrace.getNextSibling() : null;
            while (element != null) {
                if (element.getNode().getElementType() == JsonElementTypes.COMMA || element instanceof PsiErrorElement && ",".equals(element.getText())) {
                    this.deleteNode(element.getNode());
                } else if (!(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) break;
                element = element.getNextSibling();
            }
        }

        private void deleteNode(@NotNull ASTNode node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            int length = node.getTextLength();
            this.myDocument.deleteString(node.getStartOffset() + this.myOffsetDelta, node.getStartOffset() + length + this.myOffsetDelta);
            this.myOffsetDelta -= length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArray";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

