/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;

public final class JarDestinationInfo
extends DestinationInfo {
    private static final Logger LOG = Logger.getInstance(JarDestinationInfo.class);
    private final String myPathInJar;
    private final JarInfo myJarInfo;

    public JarDestinationInfo(String pathInJar, JarInfo jarInfo, DestinationInfo jarDestination) {
        super(JarDestinationInfo.appendPathInJar(jarDestination.getOutputPath(), pathInJar), jarDestination.getOutputFilePath());
        LOG.assertTrue(!pathInJar.startsWith(".."), (Object)pathInJar);
        this.myPathInJar = StringUtil.startsWithChar((CharSequence)pathInJar, (char)'/') ? pathInJar : "/" + pathInJar;
        this.myJarInfo = jarInfo;
    }

    private static String appendPathInJar(String outputPath, String pathInJar) {
        LOG.assertTrue(outputPath.length() > 0 && outputPath.charAt(outputPath.length() - 1) != '/');
        return outputPath + "!/" + pathInJar;
    }

    public String getPathInJar() {
        return this.myPathInJar;
    }

    public JarInfo getJarInfo() {
        return this.myJarInfo;
    }

    public String toString() {
        return this.myPathInJar + "(" + this.getOutputPath() + ")";
    }
}

