/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Lists;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.hierarchy.ChildrenFinderStrategy;

final class WindowChildrenFinder
implements ChildrenFinderStrategy {
    WindowChildrenFinder() {
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        if (!(c instanceof Window)) {
            return Lists.emptyList();
        }
        return this.ownedWindows((Window)c);
    }

    @Nonnull
    @RunsInCurrentThread
    private Collection<Component> ownedWindows(Window w) {
        return this.windows(w.getOwnedWindows());
    }

    @Nonnull
    private Collection<Component> windows(@Nonnull Component[] windows) {
        if (Arrays.isNullOrEmpty(windows)) {
            return Lists.emptyList();
        }
        return Lists.newArrayList(windows);
    }
}

