/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.PrependingInputStream;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.SudoCliInteractionKt;
import com.intellij.ssh.SudoPromptFiniteStateMachineResult;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0014H\u0002JE\u0010#\u001a\u00020\u001c26\u0010$\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160'0&0%\"\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160'0&H\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/ssh/SudoPromptFiniteStateMachine;", "", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "hasPty", "", "runViaSudoInfo", "Lcom/intellij/ssh/RunViaSudoInfo;", "passwordProvider", "Lcom/intellij/ssh/PasswordStringProvider;", "(Ljava/io/OutputStream;Ljava/io/InputStream;ZLcom/intellij/ssh/RunViaSudoInfo;Lcom/intellij/ssh/PasswordStringProvider;)V", "getOutputStream", "()Ljava/io/OutputStream;", "prependingInputStream", "Lcom/intellij/ssh/PrependingInputStream;", "readBuffer", "", "readBufferSize", "", "state", "Lcom/intellij/ssh/SudoPromptFiniteStateMachine$State;", "successBoundaryBytes", "sudoPromptBytes", "doWork", "Lcom/intellij/ssh/SudoPromptFiniteStateMachineResult;", "expectChar", "", "b", "", "firstEqualBytes", "array1", "array2", "maxBytes", "matchBytesAndChooseNewState", "cases", "", "Lkotlin/Pair;", "Lkotlin/Function0;", "([Lkotlin/Pair;)V", "returnBufferBack", "State", "intellij.platform.ssh"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSudoCliInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudoCliInteraction.kt\ncom/intellij/ssh/SudoPromptFiniteStateMachine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1#2:300\n*E\n"})
public final class SudoPromptFiniteStateMachine {
    @NotNull
    private final OutputStream outputStream;
    private final boolean hasPty;
    @NotNull
    private final PasswordStringProvider passwordProvider;
    @NotNull
    private final byte[] sudoPromptBytes;
    @NotNull
    private final byte[] successBoundaryBytes;
    @NotNull
    private State state;
    @NotNull
    private final PrependingInputStream prependingInputStream;
    @NotNull
    private final byte[] readBuffer;
    private int readBufferSize;

    public SudoPromptFiniteStateMachine(@NotNull OutputStream outputStream2, @NotNull InputStream inputStream2, boolean hasPty, @NotNull RunViaSudoInfo runViaSudoInfo, @NotNull PasswordStringProvider passwordProvider) {
        Intrinsics.checkNotNullParameter((Object)outputStream2, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)inputStream2, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)runViaSudoInfo, (String)"runViaSudoInfo");
        Intrinsics.checkNotNullParameter((Object)passwordProvider, (String)"passwordProvider");
        this.outputStream = outputStream2;
        this.hasPty = hasPty;
        this.passwordProvider = passwordProvider;
        byte[] byArray = runViaSudoInfo.getSudoPrompt().getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.sudoPromptBytes = byArray;
        byte[] byArray2 = runViaSudoInfo.getSuccessBoundary().getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        this.successBoundaryBytes = byArray2;
        this.state = State.MaybeAskPassword;
        this.prependingInputStream = new PrependingInputStream(inputStream2);
        this.readBuffer = new byte[Math.max(this.sudoPromptBytes.length, Math.max(this.successBoundaryBytes.length, SudoCliInteractionKt.access$getTRY_AGAIN$p().length))];
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final SudoPromptFiniteStateMachineResult doWork() {
        Ref.BooleanRef lastPasswordWasWrong = new Ref.BooleanRef();
        block5: while (this.state != State.Success && this.state != State.Terminated) {
            boolean bl;
            boolean bl2 = bl = this.readBufferSize < this.readBuffer.length;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = this.readBufferSize + " < " + this.readBuffer.length;
                throw new AssertionError((Object)string);
            }
            int readBytesInThisIteration = this.prependingInputStream.read(this.readBuffer, this.readBufferSize, Math.min(Math.max(1, this.prependingInputStream.available()), this.readBuffer.length - this.readBufferSize));
            if (readBytesInThisIteration < 0) {
                this.state = State.Terminated;
                continue;
            }
            this.readBufferSize += readBytesInThisIteration;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.sudoPromptBytes, (Object)new Function0<State>(this, lastPasswordWasWrong){
                        final /* synthetic */ SudoPromptFiniteStateMachine this$0;
                        final /* synthetic */ Ref.BooleanRef $lastPasswordWasWrong;
                        {
                            this.this$0 = $receiver;
                            this.$lastPasswordWasWrong = $lastPasswordWasWrong;
                            super(0);
                        }

                        @NotNull
                        public final State invoke() {
                            State state;
                            String password = SudoPromptFiniteStateMachine.access$getPasswordProvider$p(this.this$0).provide(this.$lastPasswordWasWrong.element);
                            if (password != null) {
                                OutputStream outputStream2 = this.this$0.getOutputStream();
                                String string = password + "\n";
                                byte[] byArray = string.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                                outputStream2.write(byArray);
                                this.this$0.getOutputStream().flush();
                                if (SudoPromptFiniteStateMachine.access$getHasPty$p(this.this$0)) {
                                    SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\r');
                                    SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\n');
                                }
                                state = State.MaybeTryAgain;
                            } else {
                                state = State.Terminated;
                            }
                            return state;
                        }
                    }), TuplesKt.to((Object)this.successBoundaryBytes, (Object)new Function0<State>(this){
                        final /* synthetic */ SudoPromptFiniteStateMachine this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final State invoke() {
                            if (SudoPromptFiniteStateMachine.access$getHasPty$p(this.this$0)) {
                                SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\r');
                            }
                            SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\n');
                            return State.Success;
                        }
                    })};
                    this.matchBytesAndChooseNewState(pairArray);
                    continue block5;
                }
                case 2: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SudoCliInteractionKt.access$getTRY_AGAIN$p(), (Object)new Function0<State>(this, lastPasswordWasWrong){
                        final /* synthetic */ SudoPromptFiniteStateMachine this$0;
                        final /* synthetic */ Ref.BooleanRef $lastPasswordWasWrong;
                        {
                            this.this$0 = $receiver;
                            this.$lastPasswordWasWrong = $lastPasswordWasWrong;
                            super(0);
                        }

                        @NotNull
                        public final State invoke() {
                            SudoPromptFiniteStateMachine.access$getPasswordProvider$p(this.this$0).previousPasswordWasWrong();
                            if (SudoPromptFiniteStateMachine.access$getHasPty$p(this.this$0)) {
                                SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\r');
                            }
                            SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\n');
                            this.$lastPasswordWasWrong.element = true;
                            return State.MaybeAskPassword;
                        }
                    }), TuplesKt.to((Object)this.successBoundaryBytes, (Object)new Function0<State>(this){
                        final /* synthetic */ SudoPromptFiniteStateMachine this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final State invoke() {
                            if (SudoPromptFiniteStateMachine.access$getHasPty$p(this.this$0)) {
                                SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\r');
                            }
                            SudoPromptFiniteStateMachine.access$expectChar(this.this$0, '\n');
                            return State.Success;
                        }
                    })};
                    this.matchBytesAndChooseNewState(pairArray);
                    continue block5;
                }
                case 3: 
                case 4: {
                    throw new IllegalStateException("Bug. This line should not be executed.");
                }
            }
        }
        this.returnBufferBack();
        return new SudoPromptFiniteStateMachineResult(this.state == State.Success, this.prependingInputStream);
    }

    private final void matchBytesAndChooseNewState(Pair<byte[], ? extends Function0<? extends State>> ... cases) {
        boolean anyPartialMatch = false;
        for (Pair<byte[], ? extends Function0<? extends State>> pair : cases) {
            byte[] expectedBytes = (byte[])pair.component1();
            Function0 onMatch = (Function0)pair.component2();
            int equalBytes = this.firstEqualBytes(this.readBuffer, expectedBytes, this.readBufferSize);
            if (equalBytes == expectedBytes.length) {
                this.readBufferSize -= expectedBytes.length;
                System.arraycopy(this.readBuffer, expectedBytes.length, this.readBuffer, 0, this.readBufferSize);
                this.returnBufferBack();
                this.state = (State)((Object)onMatch.invoke());
                return;
            }
            if (equalBytes != this.readBufferSize) continue;
            anyPartialMatch = true;
        }
        if (!anyPartialMatch) {
            this.state = State.Terminated;
        }
    }

    private final int firstEqualBytes(byte[] array1, byte[] array2, int maxBytes) {
        int i;
        int threshold = Math.min(maxBytes, Math.min(array1.length, array2.length));
        for (i = 0; i < threshold && array1[i] == array2[i]; ++i) {
        }
        return i;
    }

    private final void returnBufferBack() {
        while (true) {
            this.readBufferSize += -1;
            if (this.readBufferSize < 0) break;
            this.prependingInputStream.getPrefix().addFirst(this.readBuffer[this.readBufferSize]);
        }
        this.readBufferSize = 0;
    }

    private final void expectChar(char b) {
        byte it = (byte)this.prependingInputStream.read();
        boolean bl = false;
        if (!(it == (byte)b)) {
            boolean bl2 = false;
            String string = "Expected byte " + b + ", got byte " + it + " ";
            throw new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ PasswordStringProvider access$getPasswordProvider$p(SudoPromptFiniteStateMachine $this) {
        return $this.passwordProvider;
    }

    public static final /* synthetic */ boolean access$getHasPty$p(SudoPromptFiniteStateMachine $this) {
        return $this.hasPty;
    }

    public static final /* synthetic */ void access$expectChar(SudoPromptFiniteStateMachine $this, char b) {
        $this.expectChar(b);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ssh/SudoPromptFiniteStateMachine$State;", "", "(Ljava/lang/String;I)V", "MaybeAskPassword", "MaybeTryAgain", "Success", "Terminated", "intellij.platform.ssh"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State MaybeAskPassword = new State();
        public static final /* enum */ State MaybeTryAgain = new State();
        public static final /* enum */ State Success = new State();
        public static final /* enum */ State Terminated = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.MaybeAskPassword, State.MaybeTryAgain, State.Success, State.Terminated};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.MaybeAskPassword.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MaybeTryAgain.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Terminated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

