/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.RemoteCredentialsSshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.interaction.PlatformSshPasswordProvider;
import com.intellij.ssh.process.CommandLineUtil;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a4\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\tH\u0007\u001a:\u0010\u0012\u001a\u00020\u0013*\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0007\u001a.\u0010\u0017\u001a\u00020\u0018*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u001a\u0012\u0010 \u001a\u00020!*\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"JETBRAINS_REMOTE_RUN", "", "declineHostKeyVerifierDialogs", "Lcom/intellij/ssh/config/SshConnectionConfig;", "source", "getCommandLineString", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "checkConnection", "", "Lcom/intellij/remote/RemoteCredentials;", "timeout", "Ljava/time/Duration;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "sshPasswordPrompt", "Lcom/intellij/ssh/ui/SshPasswordPrompt;", "allowDialogs", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "passwordPrompt", "execBuilder", "Lcom/intellij/ssh/ExecBuilder;", "changeDir", "runViaSudoInfo", "Lcom/intellij/ssh/RunViaSudoInfo;", "allocatePty", "getSystemDependentPath", "Ljava/io/File;", "isWindowsPath", "processBuilder", "Lcom/intellij/ssh/ProcessBuilder;", "intellij.platform.ssh"})
@JvmName(name="RemoteCredentialsUtil")
@SourceDebugExtension(value={"SMAP\nremoteCredentialsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 remoteCredentialsUtil.kt\ncom/intellij/ssh/RemoteCredentialsUtil\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,238:1\n35#2:239\n*S KotlinDebug\n*F\n+ 1 remoteCredentialsUtil.kt\ncom/intellij/ssh/RemoteCredentialsUtil\n*L\n206#1:239\n*E\n"})
public final class RemoteCredentialsUtil {
    @NotNull
    private static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project2, @Nullable ProgressIndicator progressIndicator2, boolean allowDialogs, @Nullable SshPasswordPrompt passwordPrompt) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        String string = $this$connectionBuilder.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        return new ConnectionBuilder(string).withSshPasswordProvider(new PlatformSshPasswordProvider($this$connectionBuilder, allowDialogs, passwordPrompt)).withProgressIndicator(progressIndicator2).withSshConnectionConfig((Function1<? super SshConnectionConfig, SshConnectionConfig>)((Function1)new Function1<SshConnectionConfig, SshConnectionConfig>((Object)$this$connectionBuilder){

            @NotNull
            public final SshConnectionConfig invoke(@NotNull SshConnectionConfig p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RemoteCredentialsSshConnectionConfig.changeSshConnectionConfig((RemoteCredentials)this.receiver, p0);
            }
        })).withParsingOpenSSHConfig($this$connectionBuilder.shouldUseOpenSshConfig());
    }

    public static /* synthetic */ ConnectionBuilder connectionBuilder$default(RemoteCredentials remoteCredentials, Project project2, ProgressIndicator progressIndicator2, boolean bl, SshPasswordPrompt sshPasswordPrompt, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = null;
        }
        if ((n & 2) != 0) {
            progressIndicator2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            sshPasswordPrompt = null;
        }
        return RemoteCredentialsUtil.connectionBuilder(remoteCredentials, project2, progressIndicator2, bl, sshPasswordPrompt);
    }

    @NotNull
    public static final ProcessBuilder processBuilder(@NotNull ConnectionBuilder $this$processBuilder, @NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)$this$processBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return new ProcessBuilder($this$processBuilder, commandLine);
    }

    private static final ExecBuilder execBuilder(ConnectionBuilder $this$execBuilder, GeneralCommandLine commandLine, boolean changeDir, RunViaSudoInfo runViaSudoInfo, boolean allocatePty) {
        String inputFile;
        Map map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map map2 = map;
        String string = JETBRAINS_REMOTE_RUN;
        String string2 = "1";
        map2.put(string, string2);
        Object command = RemoteCredentialsUtil.getCommandLineString(commandLine);
        boolean isWindowsPath = RemoteFile.isWindowsPath((String)commandLine.getExePath());
        if (!isWindowsPath) {
            command = CommandLineUtil.addEnvCommand(commandLine, (String)command);
        }
        File file = commandLine.getInputFile();
        String string3 = inputFile = file != null ? RemoteCredentialsUtil.getSystemDependentPath(file, isWindowsPath) : null;
        if (inputFile != null) {
            command = (String)command + " < " + com.intellij.execution.CommandLineUtil.posixQuote((String)inputFile);
        }
        if (!isWindowsPath && runViaSudoInfo != null) {
            command = RunViaSudoInfo.patchCommand$default(runViaSudoInfo, (String)command, null, 2, null);
        }
        if (changeDir && commandLine.getWorkDirectory() != null) {
            File file2 = commandLine.getWorkDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getWorkDirectory(...)");
            String workingDir = RemoteCredentialsUtil.getSystemDependentPath(file2, isWindowsPath);
            command = "cd " + com.intellij.execution.CommandLineUtil.posixQuote((String)workingDir) + "; exec " + (String)command;
        }
        return (ExecBuilder)$this$execBuilder.execBuilder((String)command).withAllocatePty(allocatePty);
    }

    private static final String getSystemDependentPath(File $this$getSystemDependentPath, boolean isWindowsPath) {
        String string = RemoteFile.createRemoteFile((String)$this$getSystemDependentPath.getPath(), (boolean)isWindowsPath).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final String getCommandLineString(GeneralCommandLine commandLine) {
        Boolean value = (Boolean)commandLine.getUserData(Ssh.getDO_NOT_ESCAPE_CMD_ARGS());
        if (value != null && value.booleanValue()) {
            String string = commandLine.getCommandLineString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
            return string;
        }
        List list2 = commandLine.getCommandLineList(null);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCommandLineList(...)");
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, (Function1)getCommandLineString.1.INSTANCE, (int)30, null);
    }

    @ApiStatus.Experimental
    public static final boolean checkConnection(@NotNull RemoteCredentials $this$checkConnection, @NotNull Duration timeout, @Nullable ProgressIndicator progressIndicator2, @Nullable SshPasswordPrompt sshPasswordPrompt, boolean allowDialogs) throws TimeoutException, ProcessCanceledException, RuntimeException {
        ConnectionBuilder connectionBuilder2;
        Object[] $this$applyIf$iv;
        Intrinsics.checkNotNullParameter((Object)$this$checkConnection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        long finishBefore = System.currentTimeMillis() + timeout.toMillis();
        ErrorMessageAndField validationResult = SshCredentialsVerifier.validate(SshCredentialsVerifier.ValidationMode.WITHOUT_SLOW_KEY_CHECKS, $this$checkConnection, timeout.toMillis(), SshBackendLibrary.Companion.get());
        if (validationResult != null) {
            throw new RuntimeException(validationResult.getErrorMessage());
        }
        long timeoutMsLeft = finishBefore - System.currentTimeMillis();
        if (timeoutMsLeft <= 0L) {
            throw new TimeoutException("Timeout occurred during credentials check");
        }
        EventDispatcher eventDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        EventDispatcher forceDisconnectDispatcher = eventDispatcher;
        ConnectionBuilder connectionBuilder3 = RemoteCredentialsUtil.connectionBuilder$default($this$checkConnection, null, progressIndicator2, allowDialogs, sshPasswordPrompt, 1, null).withDisconnectTrigger((EventDispatcher<ForceDisconnectListener>)forceDisconnectDispatcher).withConnectionTimeout(timeoutMsLeft, TimeUnit.MILLISECONDS);
        boolean condition$iv = !allowDialogs;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$checkConnection_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            connectionBuilder2 = $this$checkConnection_u24lambda_u240.withSshConnectionConfig((Function1<? super SshConnectionConfig, SshConnectionConfig>)((Function1)checkConnection.connectionBuilder.1.1.INSTANCE));
        } else {
            connectionBuilder2 = $this$applyIf$iv;
        }
        void connectionBuilder4 = connectionBuilder2;
        ProgressIndicator progressIndicator3 = progressIndicator2;
        if (progressIndicator3 != null) {
            $this$applyIf$iv = new Object[]{connectionBuilder4.getUserHostPort()};
            progressIndicator3.setText(IdeCoreBundle.message((String)"progress.message.connecting.to", (Object[])$this$applyIf$iv));
        }
        CompletableFuture<Boolean> checkResult = CompletableFuture.supplyAsync(() -> RemoteCredentialsUtil.checkConnection$lambda$1((ConnectionBuilder)connectionBuilder4));
        try {
            Object object = ProgressIndicatorUtils.awaitWithCheckCanceled((Future)checkResult, (ProgressIndicator)progressIndicator2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"awaitWithCheckCanceled(...)");
            return (Boolean)object;
        }
        catch (ProcessCanceledException e) {
            ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
            throw e;
        }
    }

    public static /* synthetic */ boolean checkConnection$default(RemoteCredentials remoteCredentials, Duration duration, ProgressIndicator progressIndicator2, SshPasswordPrompt sshPasswordPrompt, boolean bl, int n, Object object) throws TimeoutException, ProcessCanceledException, RuntimeException {
        if ((n & 4) != 0) {
            sshPasswordPrompt = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return RemoteCredentialsUtil.checkConnection(remoteCredentials, duration, progressIndicator2, sshPasswordPrompt, bl);
    }

    private static final SshConnectionConfig declineHostKeyVerifierDialogs(SshConnectionConfig source) {
        List list2 = null;
        String string = null;
        List list3 = null;
        boolean bl = false;
        Duration duration = null;
        boolean bl2 = false;
        List list4 = null;
        AuthMethods authMethods2 = null;
        SshConnectionConfig sshConnectionConfig = source;
        boolean bl3 = false;
        SshHostKeyVerifier sshHostKeyVerifier = source.getHostKeyVerifier() instanceof OpenSshLikeHostKeyVerifier ? (SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier(((OpenSshLikeHostKeyVerifier)source.getHostKeyVerifier()).getKnownHostsFiles(), ((OpenSshLikeHostKeyVerifier)source.getHostKeyVerifier()).getStrictHostKeyChecking(), ((OpenSshLikeHostKeyVerifier)source.getHostKeyVerifier()).getHashKnownHosts(), false) : source.getHostKeyVerifier();
        return SshConnectionConfig.copy$default(sshConnectionConfig, authMethods2, list4, bl2, duration, bl, list3, string, list2, sshHostKeyVerifier, null, null, null, null, null, 0, null, null, null, null, 524031, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project2, @Nullable ProgressIndicator progressIndicator2, boolean allowDialogs) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project2, progressIndicator2, allowDialogs, null, 8, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project2, @Nullable ProgressIndicator progressIndicator2) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project2, progressIndicator2, false, null, 12, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, project2, null, false, null, 14, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials $this$connectionBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionBuilder, (String)"<this>");
        return RemoteCredentialsUtil.connectionBuilder$default($this$connectionBuilder, null, null, false, null, 15, null);
    }

    private static final Boolean checkConnection$lambda$1(ConnectionBuilder $connectionBuilder) {
        Intrinsics.checkNotNullParameter((Object)$connectionBuilder, (String)"$connectionBuilder");
        return $connectionBuilder.checkCanAuthenticate(true);
    }

    public static final /* synthetic */ ExecBuilder access$execBuilder(ConnectionBuilder $receiver, GeneralCommandLine commandLine, boolean changeDir, RunViaSudoInfo runViaSudoInfo, boolean allocatePty) {
        return RemoteCredentialsUtil.execBuilder($receiver, commandLine, changeDir, runViaSudoInfo, allocatePty);
    }

    public static final /* synthetic */ SshConnectionConfig access$declineHostKeyVerifierDialogs(SshConnectionConfig source) {
        return RemoteCredentialsUtil.declineHostKeyVerifierDialogs(source);
    }
}

