/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MavenVersionUtils {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(.+)-\\d{8}\\.\\d{6}-\\d+");

    public static String inferStatusFromEffectiveVersion(String effectiveVersion) {
        return effectiveVersion != null && effectiveVersion.endsWith("SNAPSHOT") ? "integration" : "release";
    }

    public static String inferStatusFromVersionNumber(String version) {
        return MavenVersionUtils.inferStatusFromEffectiveVersion(MavenVersionUtils.toEffectiveVersion(version));
    }

    public static String toEffectiveVersion(String version) {
        Matcher matcher;
        String effectiveVersion = version;
        if (version != null && (matcher = TIMESTAMP_PATTERN.matcher(version)).matches()) {
            effectiveVersion = matcher.group(1) + "-SNAPSHOT";
        }
        return effectiveVersion;
    }
}

