/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0002J\u0006\u0010-\u001a\u00020#J\b\u0010.\u001a\u00020*H\u0016R$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR.\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001e0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\r\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/Map;)V", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "upValues", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getUpValues", "createToStringIrCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getEqualsFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getHashCodeFunction", "getIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "method", "Ljava/lang/reflect/Method;", "getKotlinName", "", "declaringClassName", "methodName", "getToStringFunction", "toString", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Common.kt\norg/jetbrains/kotlin/ir/interpreter/state/Common\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n661#2,11:79\n346#3,12:90\n346#3,12:103\n346#3,12:115\n1#4:102\n*S KotlinDebug\n*F\n+ 1 Common.kt\norg/jetbrains/kotlin/ir/interpreter/state/Common\n*L\n42#1:79,11\n51#1:90,12\n60#1:103,12\n66#1:115,12\n*E\n"})
public final class Common
implements Complex,
StateWithClosure {
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final Map<IrSymbol, Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;

    private Common(IrClass irClass2, Map<IrSymbol, State> fields2) {
        this.irClass = irClass2;
        this.fields = fields2;
        this.upValues = new LinkedHashMap();
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Map<IrSymbol, Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    public Common(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this(irClass2, new LinkedHashMap());
    }

    private final String getKotlinName(String declaringClassName, String methodName) {
        return Intrinsics.areEqual((Object)declaringClassName, (Object)"java.lang.CharSequence") && Intrinsics.areEqual((Object)methodName, (Object)"charAt") ? "get" : methodName;
    }

    @Nullable
    public final IrFunction getIrFunction(@NotNull Method method) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String string2 = method.getDeclaringClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.declaringClass.name");
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"method.name");
            String methodName = this.getKotlinName(string2, string3);
            Iterable $this$singleOrNull$iv = this.getIrClass().getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)((IrDeclarationWithName)it).getName().asString(), (Object)methodName))) continue;
                if (found$iv) {
                    v2 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrDeclaration declaration = v2;
        return declaration instanceof IrProperty ? (IrFunction)((IrProperty)declaration).getGetter() : (declaration instanceof IrFunction ? (IrFunction)declaration : null);
    }

    @NotNull
    public final IrSimpleFunction getEqualsFunction() {
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals") && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().size() == 1 && IrTypePredicatesKt.isNullableAny(it.getValueParameters().get(0).getType());
            if (!bl2) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction it = single$iv;
        boolean bl = false;
        IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(it, false, null, 3, null);
        Intrinsics.checkNotNull((Object)irOverridableDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return (IrSimpleFunction)irOverridableDeclaration;
    }

    @NotNull
    public final IrSimpleFunction getHashCodeFunction() {
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"hashCode") && it.getValueParameters().isEmpty() && it.getExtensionReceiverParameter() == null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction it = single$iv;
        boolean bl = false;
        IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(it, false, null, 3, null);
        Intrinsics.checkNotNull((Object)irOverridableDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return (IrSimpleFunction)irOverridableDeclaration;
    }

    @NotNull
    public final IrSimpleFunction getToStringFunction() {
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(this.getIrClass());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"toString") && it.getValueParameters().isEmpty() && it.getExtensionReceiverParameter() == null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction it = single$iv;
        boolean bl = false;
        IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(it, false, null, 3, null);
        Intrinsics.checkNotNull((Object)irOverridableDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return (IrSimpleFunction)irOverridableDeclaration;
    }

    @NotNull
    public final IrCall createToStringIrCall() {
        return IrTreeBuildUtilsKt.createCall$default(this.getToStringFunction(), null, 1, null);
    }

    @NotNull
    public String toString() {
        return "Common(obj='" + UtilsKt.getFqName(this.getIrClass()) + "', values=" + this.getFields() + ')';
    }
}

