/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.FastMethodAnalyzer;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "boxingInterpreter", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;)V", "newFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "nLocals", "", "nStack", "BoxingFrame", "backend"})
public final class BoxingAnalyzer
extends FastMethodAnalyzer<BasicValue> {
    @NotNull
    private final BoxingInterpreter boxingInterpreter;

    public BoxingAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull BoxingInterpreter boxingInterpreter) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)boxingInterpreter, (String)"boxingInterpreter");
        super(owner, method, boxingInterpreter, false, 8, null);
        this.boxingInterpreter = boxingInterpreter;
    }

    @Override
    @NotNull
    protected Frame<BasicValue> newFrame(int nLocals, int nStack) {
        return new BoxingFrame(nLocals, nStack);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingAnalyzer$BoxingFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingAnalyzer;II)V", "merge", "", "frame", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "backend"})
    private final class BoxingFrame
    extends Frame<BasicValue> {
        public BoxingFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }

        @Override
        public boolean merge(@NotNull Frame<? extends BasicValue> frame, @NotNull Interpreter<BasicValue> interpreter2) {
            BasicValue merged;
            int i;
            Intrinsics.checkNotNullParameter(frame, (String)"frame");
            Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
            if (this.getStackSize() != frame.getStackSize()) {
                throw new AnalyzerException(null, "Incompatible stack heights");
            }
            boolean changed = false;
            int n = this.getLocals();
            for (i = 0; i < n; ++i) {
                BasicValue local = (BasicValue)this.getLocal(i);
                BoxingInterpreter boxingInterpreter = BoxingAnalyzer.this.boxingInterpreter;
                Intrinsics.checkNotNullExpressionValue((Object)local, (String)"local");
                BasicValue basicValue = frame.getLocal(i);
                Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"frame.getLocal(i)");
                merged = boxingInterpreter.mergeLocalVariableValues(local, basicValue);
                if (Intrinsics.areEqual((Object)local, (Object)merged)) continue;
                this.setLocal(i, (Value)merged);
                changed = true;
            }
            n = this.getStackSize();
            for (i = 0; i < n; ++i) {
                BasicValue onStack = (BasicValue)this.getStack(i);
                BoxingInterpreter boxingInterpreter = BoxingAnalyzer.this.boxingInterpreter;
                Intrinsics.checkNotNullExpressionValue((Object)onStack, (String)"onStack");
                BasicValue basicValue = frame.getStack(i);
                Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"frame.getStack(i)");
                merged = boxingInterpreter.mergeStackValues(onStack, basicValue);
                if (Intrinsics.areEqual((Object)onStack, (Object)merged)) continue;
                this.setStack(i, (Value)merged);
                changed = true;
            }
            return changed;
        }
    }
}

