/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.util.CollectionUtils;

public class TypeCountMap<T extends FreeColSpecObjectType> {
    private final Map<T, Integer> values = new HashMap<T, Integer>();

    public Map<T, Integer> getValues() {
        return this.values;
    }

    public int getCount(T key) {
        Integer value = this.values.get(key);
        return value == null ? 0 : value;
    }

    public Integer incrementCount(T key, int newCount) {
        Integer oldValue = this.values.get(key);
        if (oldValue == null) {
            return this.values.put(key, newCount);
        }
        if (oldValue == -newCount) {
            this.values.remove(key);
            return null;
        }
        return this.values.put(key, oldValue + newCount);
    }

    public void add(TypeCountMap<T> other) {
        CollectionUtils.forEachMapEntry(other.values, e -> this.incrementCount((FreeColSpecObjectType)e.getKey(), (Integer)e.getValue()));
    }

    public void clear() {
        this.values.clear();
    }

    public Set<T> keySet() {
        return this.values.keySet();
    }

    public Collection<Integer> values() {
        return this.values.values();
    }

    public boolean containsKey(T key) {
        return this.values.containsKey(key);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    public void putAll(TypeCountMap<T> other) {
        this.values.putAll(other.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getClass().getName());
        CollectionUtils.forEachMapEntry(this.values, e -> sb.append(" [").append(((FreeColSpecObjectType)e.getKey()).getIndex()).append(',').append(e.getValue()).append(']'));
        sb.append(']');
        return sb.toString();
    }
}

