/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.PropertyList;
import net.sf.freecol.common.resources.ResourceManager;

public final class CornerMapControls
extends MapControls {
    private static final Logger logger = Logger.getLogger(CornerMapControls.class.getName());
    private final ImageLibrary lib;
    private final JLabel compassRose;
    private final JPanel miniMapPanel;
    private Image miniMapSkin;
    private MiniMapPanelSkin miniMapPanelSkin;

    public CornerMapControls(FreeColClient freeColClient) {
        super(freeColClient, true);
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.compassRose = this.lib.getCompassRose();
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Unit unit = CornerMapControls.this.getGUI().getActiveUnit();
                if (unit == null) {
                    return;
                }
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                CornerMapControls.this.igc().moveUnit(unit, Direction.angleToDirection(theta));
            }
        });
        this.miniMapPanel = new JPanel();
        this.miniMapPanel.setFocusable(false);
        this.miniMapPanel.setLayout(null);
        this.miniMapPanelSkin = new MiniMapPanelSkin();
        this.miniMapPanel.add(this.miniMapToggleBorders);
        this.miniMapPanel.add(this.miniMapToggleFogOfWarButton);
        this.miniMapPanel.add(this.miniMapZoomInButton);
        this.miniMapPanel.add(this.miniMapZoomOutButton);
        this.miniMapPanel.add(this.miniMapPanelSkin);
        this.miniMapPanel.add(this.miniMap);
        this.updateLayoutIfNeeded();
    }

    @Override
    public void updateLayoutIfNeeded() {
        super.updateLayoutIfNeeded();
        BufferedImage newMinimapSkin = this.lib.getMiniMapSkin();
        if (this.miniMapSkin == newMinimapSkin) {
            return;
        }
        this.miniMapSkin = newMinimapSkin;
        int width = this.lib.scaleInt(220);
        int height = this.lib.scaleInt(128);
        this.miniMap.setSize(width, height);
        if (this.miniMapSkin != null) {
            width = this.miniMapSkin.getWidth(null);
            height = this.miniMapSkin.getHeight(null);
            this.miniMapPanel.setBorder(null);
            this.miniMapPanel.setSize(width, height);
            this.miniMapPanelSkin.setSize(width, height);
            this.miniMapPanel.setOpaque(false);
        } else {
            this.miniMapPanel.setOpaque(true);
            this.miniMap.setBorder(new BevelBorder(0));
        }
        PropertyList pl = ResourceManager.getPropertyList("image.skin.MiniMap.properties");
        this.miniMap.setLocation(this.lib.scaleInt(pl.getInt("minimap.x")), this.lib.scaleInt(pl.getInt("minimap.y")));
        this.miniMap.setSize(this.lib.scaleInt(pl.getInt("minimap.width")), this.lib.scaleInt(pl.getInt("minimap.height")));
        this.centerComponentOnCoordinate(this.miniMapToggleBorders, pl, "politicalButton");
        this.centerComponentOnCoordinate(this.miniMapToggleFogOfWarButton, pl, "fogOfWarButton");
        this.centerComponentOnCoordinate(this.miniMapZoomInButton, pl, "zoomInButton");
        this.centerComponentOnCoordinate(this.miniMapZoomOutButton, pl, "zoomOutButton");
        this.miniMapPanel.revalidate();
        this.miniMapPanel.repaint();
    }

    private void centerComponentOnCoordinate(JComponent component, PropertyList pl, String key) {
        int x = this.lib.scaleInt(pl.getInt(key + ".x"));
        int y = this.lib.scaleInt(pl.getInt(key + ".y"));
        component.setLocation(x - component.getWidth() / 2, y - component.getHeight() / 2);
    }

    @Override
    public List<Component> getComponentsToAdd(Dimension newSize) {
        boolean rose;
        ArrayList<Component> ret = new ArrayList<Component>();
        if (this.getGame() == null) {
            return ret;
        }
        int cw = newSize.width;
        int ch = newSize.height;
        if (!this.infoPanel.isShowing()) {
            this.infoPanel.setLocation(cw - this.infoPanel.getWidth(), ch - this.infoPanel.getHeight());
            this.infoPanel.refresh();
            ret.add(this.infoPanel);
        }
        if (!this.miniMapPanel.isShowing()) {
            this.miniMapPanel.setLocation(0, ch - this.miniMapPanel.getHeight());
            ret.add(this.miniMapPanel);
        }
        if ((rose = this.getClientOptions().getBoolean("model.option.displayCompassRose")) && !this.compassRose.isShowing()) {
            this.compassRose.setLocation(cw - this.compassRose.getWidth() - 20, 20);
            ret.add(this.compassRose);
        }
        ret.addAll(this.unitButtons.stream().filter(b -> !b.isShowing()).collect(Collectors.toList()));
        if (!this.unitButtons.isEmpty() && !this.getFreeColClient().isMapEditor()) {
            int UNSCALED_SPACE_BETWEEN_BUTTONS = 5;
            int spaceBetweenButtons = this.lib.scaleInt(5);
            Dimension buttonsDimension = CornerMapControls.calculateTotalDimension(this.unitButtons, spaceBetweenButtons);
            int totalWidth = buttonsDimension.width + this.miniMapPanel.getWidth() + this.infoPanel.getWidth();
            if (totalWidth < newSize.width) {
                Point firstButtonPoint = this.calculateFirstPosition(newSize, this.unitButtons, spaceBetweenButtons, buttonsDimension);
                this.layoutUnitButtons(this.unitButtons, buttonsDimension, firstButtonPoint, spaceBetweenButtons);
            } else {
                int numberInTopRow = this.unitButtons.size() / 2;
                List<UnitButton> bottomRowButtons = this.unitButtons.subList(numberInTopRow, this.unitButtons.size());
                Dimension buttonsBottomRowDimension = CornerMapControls.calculateTotalDimension(bottomRowButtons, spaceBetweenButtons);
                Point firstButtonBottomRowPoint = this.calculateFirstPosition(newSize, bottomRowButtons, spaceBetweenButtons, buttonsBottomRowDimension);
                this.layoutUnitButtons(bottomRowButtons, buttonsDimension, firstButtonBottomRowPoint, spaceBetweenButtons);
                List<UnitButton> topRowButtons = this.unitButtons.subList(0, numberInTopRow);
                Dimension buttonsTopRowDimension = CornerMapControls.calculateTotalDimension(topRowButtons, spaceBetweenButtons);
                Point firstButtonTopRowPoint = this.calculateFirstPosition(newSize, bottomRowButtons, spaceBetweenButtons, buttonsTopRowDimension);
                this.layoutUnitButtons(topRowButtons, buttonsDimension, new Point(firstButtonTopRowPoint.x, firstButtonBottomRowPoint.y - buttonsTopRowDimension.height - spaceBetweenButtons), spaceBetweenButtons);
            }
        }
        return ret;
    }

    private static Dimension calculateTotalDimension(List<UnitButton> unitButtons, int spaceBetweenButtons) {
        int width = -spaceBetweenButtons;
        int height = 0;
        for (UnitButton ub : unitButtons) {
            if (ub.isShowing()) continue;
            height = Math.max(height, ub.getHeight());
            width += spaceBetweenButtons + ub.getWidth();
        }
        return new Dimension(width, height);
    }

    private Point calculateFirstPosition(Dimension newSize, List<UnitButton> unitButtons, int spaceBetweenButtons, Dimension buttonsDimension) {
        int x = this.miniMapPanel.getWidth() + 1 + (this.infoPanel.getX() - this.miniMapPanel.getWidth() - buttonsDimension.width) / 2;
        int y = newSize.height - buttonsDimension.height - spaceBetweenButtons;
        return new Point(x, y);
    }

    private void layoutUnitButtons(List<UnitButton> unitButtons, Dimension buttonsDimension, Point firstButtonPoint, int spaceBetweenButtons) {
        int x = firstButtonPoint.x;
        int y = firstButtonPoint.y;
        for (UnitButton ub : unitButtons) {
            if (ub.isShowing()) continue;
            ub.setLocation(x, y);
            x += spaceBetweenButtons + ub.getWidth();
            ub.refreshAction();
        }
    }

    @Override
    public List<Component> getComponentsPresent() {
        boolean rose;
        ArrayList<Component> ret = new ArrayList<Component>();
        if (this.infoPanel.isShowing()) {
            ret.add(this.infoPanel);
        }
        if (this.miniMapPanel.isShowing()) {
            ret.add(this.miniMapPanel);
        }
        if ((rose = this.getClientOptions().getBoolean("model.option.displayCompassRose")) && this.compassRose.isShowing()) {
            ret.add(this.compassRose);
        }
        for (UnitButton ub : this.unitButtons) {
            if (!ub.isShowing()) continue;
            ret.add(ub);
        }
        return ret;
    }

    private class MiniMapPanelSkin
    extends JPanel {
        MiniMapPanelSkin() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (CornerMapControls.this.miniMapSkin != null) {
                graphics.drawImage(CornerMapControls.this.miniMapSkin, 0, 0, null);
            }
        }
    }
}

