/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifndef lint
static const char *rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/prepatch.c,v 1.1 2005/05/28 22:27:52 beebe Exp $";
#endif

/*
 * see if patch exists on this system
 * if patch exists, return false.
 * if argc == 1, return true.
 * if patch doesn't exist, return true.
 */
#include "args.h"
#include "config.h"
#include "osfiles.h"
#include "compat.h"

int main ARGS((int argc, char **argv, char **envp));
static int dopatch ARGS((int count, char **files));
static int inpath ARGS((const char *fname));

int
#if HAVE_STDC
main(int argc, char **argv, char **envp)
#else /* K&R style */
main(argc, argv, envp)
int argc;
char **argv, **envp;
#endif /* HAVE_STDC */
{
    int i;
    struct stat sb;

    if (argc == 1)			/* success.   no need to do more */
	return(0);

    if (argc == 2)
	if (strcmp(argv[1], "patch.00") == 0 || stat(argv[1], &sb) < 0)
	    return(0);

    if (inpath("patch"))		/* found it.   fail, so patch can */
	return(dopatch(argc-1,argv+1));

    fprintf(stderr,"\
Your system does not seem to have the 'patch' program installed (or at\n\
least it is not in your path.  Hence, the following patch files cannot\n\
be applied.  You should apply them by hand before compiling MM, or\n\
pick up a copy of the patch program.  It is probably available from\n\
the same place you got MM.\n");
    for(i = 1; i < argc; i++)
	fprintf(stderr,"\t%s\n", argv[i]);
    return(1);
}


static int
#if HAVE_STDC
inpath(const char *fname)
#else /* K&R style */
inpath(fname)
const char *fname;
#endif /* HAVE_STDC */
{
    char *path = getenv("PATH");
    char *cp = path;
    char *cp1,c;
    struct stat sb;
    char buf[MAXPATHLEN];

    while((cp1 = index(cp,':')) != NULL) {
	c = *cp1;
	*cp1 = '\0';
	sprintf(buf,"%s/%s",cp,fname);
	if (stat(buf,&sb) == 0)		/* does it exist? */
	    if (sb.st_mode & 0111)
		return(1);
	*cp1 = c;
	cp = cp1+1;
    }
    return(0);
}

static int
#if HAVE_STDC
dopatch(int count, char **files)
#else /* K&R style */
dopatch(count,files)
int count;
char **files;
#endif /* HAVE_STDC */
{
    int i;
    int ret=0;
    char buf[MAXPATHLEN+20];
    for(i = 0; i < count; i++) {
	sprintf(buf,"patch < %s", files[i]);
	fprintf(stderr, "%s\n", buf);
	ret |= system(buf);
    }
    return(ret);
}
