#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

 Author: Andrew Lowry
*/
/* cmcfm
**
** Code to parse command confirmation.  We succeed iff the next
** character is a newline.  Action routines for other confirming
** characters (like carriage return or formfeed) should insert
** a newline character for confirmation.  There is no completion.
** Standard break table breaks on every character.   A successful
** parse does not destroy the atom buffer.
**/

#define	CFMERR			/* confirm error table allocated here */

#include "ccmdlib.h"		/* get standard symbols */
#include "cmfncs.h"		/* and internal symbols */

/* Forward declaration of handler routines */

PASSEDSTATIC int cfmcplt ARGS((char *text, int textlen, fdb *fdbp,
	 int full, const char **cplt, int *cpltlen));
PASSEDSTATIC int cfmhlp ARGS((char *text, int textlen, fdb *fdbp,
	 int cust, int Lines));
PASSEDSTATIC int cfmprs ARGS((char *text, int textlen, fdb *fdbp,
	 int *parselen, pval *value));

#define cfmbrk	cmallbk		/* std break table breaks on everything */

ftspec ft_cfm = { cfmprs, cfmhlp, cfmcplt, FT_DFX, &cfmbrk };

/* cfmprs
**
** Purpose:
**   Attempt to parse a confirmation.  Succeeds if the first character
**   is a newline.  Any other character causes failure.  Returns no
**   value.  A successful parse turns off the CM_CFM flag, as a side-
**   effect.
**/

PASSEDSTATIC int
#if HAVE_STDC
cfmprs(char *text, int textlen, fdb *fdbp, int *parselen, pval *value)
#else /* K&R style */
cfmprs(text,textlen,fdbp,parselen,value)
char *text;
int textlen;
fdb *fdbp;
int *parselen;
pval *value;
#endif /* HAVE_STDC */
{
  if (textlen == 0)			/* nothing to parse... */
    return(CMxINC);			/* incomplete */
  else if ((*text & CC_CHR) == NEWLINE) { /* found a newline... */
    *parselen = 1;			/* consume one char */
    cmcsb._cmflg |= CM_NAC;		/* no copy to atom buffer */
    cmcsb._cmflg &= ~(CM_CFM|CM_ACT);	/* no longer confirmed, no pending
					   action */
    return(CMxOK);			/* and return success */
  }
  else
    return(CFMxNOC);			/* anything else... error */
}

/* cfmhlp
**
** Purpose:
**   Give standard help for a confirmation parse... always the same thing.
**/

PASSEDSTATIC int
#if HAVE_STDC
cfmhlp(char *text, int textlen, fdb *fdbp, int cust, int Lines)
#else /* K&R style */
cfmhlp(text,textlen,fdbp,cust,Lines)
char *text;
int textlen,cust;
fdb *fdbp;
int Lines;
#endif /* HAVE_STDC */
{
  cmxputs("confirm with carriage return");
  return(Lines-1);
}


/* cfmcplt
**
** Purpose:
**   Completion for confirmation parse.  We always just beep at the user.
**/

PASSEDSTATIC int
#if HAVE_STDC
cfmcplt(char *text, int textlen, fdb *fdbp, int full, const char **cplt, int *cpltlen)
#else /* K&R style */
cfmcplt(text,textlen,fdbp,full,cplt,cpltlen)
char *text;
const char **cplt;
int textlen,full,*cpltlen;
fdb *fdbp;
#endif /* HAVE_STDC */
{
  *cplt = NULL;				/* no completion text */
  return(CMP_BEL);		    	/* beep, no wakeup */
}
