/* $XFree86: xc/programs/Xserver/iplan2p4/iplpack.c,v 3.0 1996/08/18 01:54:56 dawes Exp $ */
/* Modified nov 94 by Martin Schaller (Martin_Schaller@maus.r.de) for use with
interleaved planes */

/* abcd abcd abcd abcd abcd abcd abcd abcd */
/* aaaa aaaa bbbb bbbb cccc cccc dddd dddd */

unsigned long tabi[256] = {
	0x00000000,0x00001000,0x10000000,0x10001000,
	0x00002000,0x00003000,0x10002000,0x10003000,
	0x20000000,0x20001000,0x30000000,0x30001000,
	0x20002000,0x20003000,0x30002000,0x30003000,
	0x00004000,0x00005000,0x10004000,0x10005000,
	0x00006000,0x00007000,0x10006000,0x10007000,
	0x20004000,0x20005000,0x30004000,0x30005000,
	0x20006000,0x20007000,0x30006000,0x30007000,
	0x40000000,0x40001000,0x50000000,0x50001000,
	0x40002000,0x40003000,0x50002000,0x50003000,
	0x60000000,0x60001000,0x70000000,0x70001000,
	0x60002000,0x60003000,0x70002000,0x70003000,
	0x40004000,0x40005000,0x50004000,0x50005000,
	0x40006000,0x40007000,0x50006000,0x50007000,
	0x60004000,0x60005000,0x70004000,0x70005000,
	0x60006000,0x60007000,0x70006000,0x70007000,
	0x00008000,0x00009000,0x10008000,0x10009000,
	0x0000a000,0x0000b000,0x1000a000,0x1000b000,
	0x20008000,0x20009000,0x30008000,0x30009000,
	0x2000a000,0x2000b000,0x3000a000,0x3000b000,
	0x0000c000,0x0000d000,0x1000c000,0x1000d000,
	0x0000e000,0x0000f000,0x1000e000,0x1000f000,
	0x2000c000,0x2000d000,0x3000c000,0x3000d000,
	0x2000e000,0x2000f000,0x3000e000,0x3000f000,
	0x40008000,0x40009000,0x50008000,0x50009000,
	0x4000a000,0x4000b000,0x5000a000,0x5000b000,
	0x60008000,0x60009000,0x70008000,0x70009000,
	0x6000a000,0x6000b000,0x7000a000,0x7000b000,
	0x4000c000,0x4000d000,0x5000c000,0x5000d000,
	0x4000e000,0x4000f000,0x5000e000,0x5000f000,
	0x6000c000,0x6000d000,0x7000c000,0x7000d000,
	0x6000e000,0x6000f000,0x7000e000,0x7000f000,
	0x80000000,0x80001000,0x90000000,0x90001000,
	0x80002000,0x80003000,0x90002000,0x90003000,
	0xa0000000,0xa0001000,0xb0000000,0xb0001000,
	0xa0002000,0xa0003000,0xb0002000,0xb0003000,
	0x80004000,0x80005000,0x90004000,0x90005000,
	0x80006000,0x80007000,0x90006000,0x90007000,
	0xa0004000,0xa0005000,0xb0004000,0xb0005000,
	0xa0006000,0xa0007000,0xb0006000,0xb0007000,
	0xc0000000,0xc0001000,0xd0000000,0xd0001000,
	0xc0002000,0xc0003000,0xd0002000,0xd0003000,
	0xe0000000,0xe0001000,0xf0000000,0xf0001000,
	0xe0002000,0xe0003000,0xf0002000,0xf0003000,
	0xc0004000,0xc0005000,0xd0004000,0xd0005000,
	0xc0006000,0xc0007000,0xd0006000,0xd0007000,
	0xe0004000,0xe0005000,0xf0004000,0xf0005000,
	0xe0006000,0xe0007000,0xf0006000,0xf0007000,
	0x80008000,0x80009000,0x90008000,0x90009000,
	0x8000a000,0x8000b000,0x9000a000,0x9000b000,
	0xa0008000,0xa0009000,0xb0008000,0xb0009000,
	0xa000a000,0xa000b000,0xb000a000,0xb000b000,
	0x8000c000,0x8000d000,0x9000c000,0x9000d000,
	0x8000e000,0x8000f000,0x9000e000,0x9000f000,
	0xa000c000,0xa000d000,0xb000c000,0xb000d000,
	0xa000e000,0xa000f000,0xb000e000,0xb000f000,
	0xc0008000,0xc0009000,0xd0008000,0xd0009000,
	0xc000a000,0xc000b000,0xd000a000,0xd000b000,
	0xe0008000,0xe0009000,0xf0008000,0xf0009000,
	0xe000a000,0xe000b000,0xf000a000,0xf000b000,
	0xc000c000,0xc000d000,0xd000c000,0xd000d000,
	0xc000e000,0xc000f000,0xd000e000,0xd000f000,
	0xe000c000,0xe000d000,0xf000c000,0xf000d000,
	0xe000e000,0xe000f000,0xf000e000,0xf000f000,
	};
static unsigned long tabp[256] = {
	0x00000000,0x00020000,0x00080000,0x000a0000,
	0x00200000,0x00220000,0x00280000,0x002a0000,
	0x00800000,0x00820000,0x00880000,0x008a0000,
	0x00a00000,0x00a20000,0x00a80000,0x00aa0000,
	0x02000000,0x02020000,0x02080000,0x020a0000,
	0x02200000,0x02220000,0x02280000,0x022a0000,
	0x02800000,0x02820000,0x02880000,0x028a0000,
	0x02a00000,0x02a20000,0x02a80000,0x02aa0000,
	0x08000000,0x08020000,0x08080000,0x080a0000,
	0x08200000,0x08220000,0x08280000,0x082a0000,
	0x08800000,0x08820000,0x08880000,0x088a0000,
	0x08a00000,0x08a20000,0x08a80000,0x08aa0000,
	0x0a000000,0x0a020000,0x0a080000,0x0a0a0000,
	0x0a200000,0x0a220000,0x0a280000,0x0a2a0000,
	0x0a800000,0x0a820000,0x0a880000,0x0a8a0000,
	0x0aa00000,0x0aa20000,0x0aa80000,0x0aaa0000,
	0x20000000,0x20020000,0x20080000,0x200a0000,
	0x20200000,0x20220000,0x20280000,0x202a0000,
	0x20800000,0x20820000,0x20880000,0x208a0000,
	0x20a00000,0x20a20000,0x20a80000,0x20aa0000,
	0x22000000,0x22020000,0x22080000,0x220a0000,
	0x22200000,0x22220000,0x22280000,0x222a0000,
	0x22800000,0x22820000,0x22880000,0x228a0000,
	0x22a00000,0x22a20000,0x22a80000,0x22aa0000,
	0x28000000,0x28020000,0x28080000,0x280a0000,
	0x28200000,0x28220000,0x28280000,0x282a0000,
	0x28800000,0x28820000,0x28880000,0x288a0000,
	0x28a00000,0x28a20000,0x28a80000,0x28aa0000,
	0x2a000000,0x2a020000,0x2a080000,0x2a0a0000,
	0x2a200000,0x2a220000,0x2a280000,0x2a2a0000,
	0x2a800000,0x2a820000,0x2a880000,0x2a8a0000,
	0x2aa00000,0x2aa20000,0x2aa80000,0x2aaa0000,
	0x80000000,0x80020000,0x80080000,0x800a0000,
	0x80200000,0x80220000,0x80280000,0x802a0000,
	0x80800000,0x80820000,0x80880000,0x808a0000,
	0x80a00000,0x80a20000,0x80a80000,0x80aa0000,
	0x82000000,0x82020000,0x82080000,0x820a0000,
	0x82200000,0x82220000,0x82280000,0x822a0000,
	0x82800000,0x82820000,0x82880000,0x828a0000,
	0x82a00000,0x82a20000,0x82a80000,0x82aa0000,
	0x88000000,0x88020000,0x88080000,0x880a0000,
	0x88200000,0x88220000,0x88280000,0x882a0000,
	0x88800000,0x88820000,0x88880000,0x888a0000,
	0x88a00000,0x88a20000,0x88a80000,0x88aa0000,
	0x8a000000,0x8a020000,0x8a080000,0x8a0a0000,
	0x8a200000,0x8a220000,0x8a280000,0x8a2a0000,
	0x8a800000,0x8a820000,0x8a880000,0x8a8a0000,
	0x8aa00000,0x8aa20000,0x8aa80000,0x8aaa0000,
	0xa0000000,0xa0020000,0xa0080000,0xa00a0000,
	0xa0200000,0xa0220000,0xa0280000,0xa02a0000,
	0xa0800000,0xa0820000,0xa0880000,0xa08a0000,
	0xa0a00000,0xa0a20000,0xa0a80000,0xa0aa0000,
	0xa2000000,0xa2020000,0xa2080000,0xa20a0000,
	0xa2200000,0xa2220000,0xa2280000,0xa22a0000,
	0xa2800000,0xa2820000,0xa2880000,0xa28a0000,
	0xa2a00000,0xa2a20000,0xa2a80000,0xa2aa0000,
	0xa8000000,0xa8020000,0xa8080000,0xa80a0000,
	0xa8200000,0xa8220000,0xa8280000,0xa82a0000,
	0xa8800000,0xa8820000,0xa8880000,0xa88a0000,
	0xa8a00000,0xa8a20000,0xa8a80000,0xa8aa0000,
	0xaa000000,0xaa020000,0xaa080000,0xaa0a0000,
	0xaa200000,0xaa220000,0xaa280000,0xaa2a0000,
	0xaa800000,0xaa820000,0xaa880000,0xaa8a0000,
	0xaaa00000,0xaaa20000,0xaaa80000,0xaaaa0000,
	};

void
iplUnpackLine(int planes, int longs, unsigned int *psrc, unsigned short *ipsrc)
{
	unsigned long temp,m,*temp2;
	unsigned char *t=(unsigned char *) &temp;
	unsigned char *i=(unsigned char *) ipsrc;
	unsigned char *s=(unsigned char *) psrc;
	int j,off;
	switch (planes) {
	case 2:
		for (j = 0 ; j < longs ; j++)
		{
			temp2=(unsigned long *) ipsrc;
			*temp2=(tabi[s[0]] >>  0) 	|
			       (tabi[s[1]] >>  4) 	|
			       (tabi[s[2]] >>  8) 	|
			       (tabi[s[3]] >> 12);
			temp2++;
			ipsrc=(unsigned short *) temp2;
			s+=4;
		}
		break;
	case 4:
		for (j = 0 ; j < longs ; j++)
		{
			temp=	(tabi[s[0]] >>  0) 	|
			        (tabi[s[1]] >>  4) 	|
				(tabi[s[2]] >>  8) 	|
				(tabi[s[3]] >> 12);
			temp=	(tabi[t[0]] >>  0) 	|
			        (tabi[t[1]] >>  4) 	|
				(tabi[t[2]] >>  8) 	|
				(tabi[t[3]] >> 12);
			s+=4;
			if (j & 1) {
				i[7]=t[0];
				i[5]=t[1];
				i[3]=t[2];
				i[1]=t[3];
				i += 8;
			}	
			else {
				i[6]=t[0];
				i[4]=t[1];
				i[2]=t[2];
				i[0]=t[3];
			}
		}
		break;
	case 8:
		for (j = 0 ; j < longs ; j++)
		{
			temp=   (tabi[s[0]] >>  0) 	|
			        (tabi[s[1]] >>  4) 	|
				(tabi[s[2]] >>  8) 	|
				(tabi[s[3]] >> 12);

			temp=   (tabi[t[0]] >>  0) 	|
			        (tabi[t[1]] >>  4) 	|
				(tabi[t[2]] >>  8) 	|
				(tabi[t[3]] >> 12);

			temp=   (tabi[t[0]] >>  0) 	|
			        (tabi[t[1]] >>  4) 	|
				(tabi[t[2]] >>  8) 	|
				(tabi[t[3]] >> 12);

			off=12-(j & 3)*4;
			m=0xf << off;
			ipsrc[7]=(ipsrc[7] & ~m) | (((temp >> 28) << off) & m); 
			ipsrc[6]=(ipsrc[6] & ~m) | (((temp >> 24) << off) & m); 
			ipsrc[5]=(ipsrc[5] & ~m) | (((temp >> 20) << off) & m); 
			ipsrc[4]=(ipsrc[4] & ~m) | (((temp >> 16) << off) & m); 
			ipsrc[3]=(ipsrc[3] & ~m) | (((temp >> 12) << off) & m); 
			ipsrc[2]=(ipsrc[2] & ~m) | (((temp >>  8) << off) & m); 
			ipsrc[1]=(ipsrc[1] & ~m) | (((temp >>  4) << off) & m); 
			ipsrc[0]=(ipsrc[0] & ~m) | (((temp >>  0) << off) & m); 
			if (! off)
				ipsrc +=8; 
			s+=4;
		}
	}
}

void
iplPackLine(int planes, int longs, unsigned short *ipdst, unsigned int *pdst)
{
	unsigned long temp,m;
	unsigned char *t=(unsigned char *) &temp;
	unsigned char *i=(unsigned char *) ipdst;
	int j,off;
	switch (planes) {
	case 2:
		for (j = 0 ; j < longs ; j++)
		{
			*pdst++=(tabp[i[2]] >>  0) 	|
			        (tabp[i[0]] >>  1) 	|
				(tabp[i[3]] >> 16) 	|
				(tabp[i[1]] >> 17);
			i+=4;
		}
		break;
	case 4:
		for (j = 0 ; j < longs ; j++)
		{
			if (j & 1) {
				temp=	(tabp[i[7]] >>  0) 	|
				        (tabp[i[3]] >>  1) 	|
					(tabp[i[5]] >> 16) 	|
					(tabp[i[1]] >> 17);
				i += 8;
			}	
			else {
				temp=	(tabp[i[6]] >>  0) 	|
				        (tabp[i[2]] >>  1) 	|
					(tabp[i[4]] >> 16) 	|
					(tabp[i[0]] >> 17);
			}
			*pdst++=(tabp[t[0]] >>  0) 	|
			        (tabp[t[2]] >>  1) 	|
				(tabp[t[1]] >> 16) 	|
				(tabp[t[3]] >> 17);
		}
		break;
	case 8:
		for (j = 0 ; j < longs ; j++)
		{
			off=12-(j & 3)*4;
			m=0xf;
			temp=(((ipdst[7] >> off) & m) << 28)    | 
			     (((ipdst[6] >> off) & m) << 24)    | 
			     (((ipdst[5] >> off) & m) << 20)    |
			     (((ipdst[4] >> off) & m) << 16)    |
			     (((ipdst[3] >> off) & m) << 12)    | 
			     (((ipdst[2] >> off) & m) <<  8)    |
			     (((ipdst[1] >> off) & m) <<  4)    |
			     (((ipdst[0] >> off) & m) <<  0);

			if (! off)
				ipdst +=8; 

			temp=   (tabp[t[0]] >>  0) 	|
			        (tabp[t[2]] >>  1) 	|
				(tabp[t[1]] >> 16) 	|
				(tabp[t[3]] >> 17);

			temp=   (tabp[t[0]] >>  0) 	|
			        (tabp[t[2]] >>  1) 	|
				(tabp[t[1]] >> 16) 	|
				(tabp[t[3]] >> 17);

			*pdst++=(tabp[t[0]] >>  0) 	|
			        (tabp[t[2]] >>  1) 	|
				(tabp[t[1]] >> 16) 	|
				(tabp[t[3]] >> 17);
		}
	}
}

unsigned long
iplpack(unsigned long ipl)
{
	unsigned char *ic=(unsigned char *) &ipl;
	return  (tabp[ic[0]]) 		| /* a0a0a0a0a0a0a0a00000000000000000 */
		(tabp[ic[2]] >> 1)	| /* abababababababab0000000000000000 */
		(tabp[ic[1]] >> 16)	| /* ababababababababa0a0a0a0a0a0a0a0 */
		(tabp[ic[3]] >> 17);      /* abababababababababababababababab */
}

unsigned long
iplunpack(unsigned long pack)
{
	unsigned char *ip=(unsigned char *) &pack;
	return  (tabi[ip[0]])		| /* aaaa000000000000bbbb000000000000 */
		(tabi[ip[1]] >>  4)	| /* aaaaaaaa00000000bbbbbbbb00000000 */
		(tabi[ip[2]] >>  8)     | /* aaaaaaaaaaaa0000bbbbbbbbbbbb0000 */
		(tabi[ip[3]] >> 12);	  /* aaaaaaaaaaaaaaaabbbbbbbbbbbbbbbb */
}	

