/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class EnforcerRuleCache {
    private final Logger logger = LoggerFactory.getLogger(EnforcerRuleCache.class);
    private final Map<Class<? extends AbstractEnforcerRule>, List<String>> cache = new HashMap<Class<? extends AbstractEnforcerRule>, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(AbstractEnforcerRule rule) {
        String cacheId = rule.getCacheId();
        if (cacheId == null) {
            return false;
        }
        Class<?> ruleClass = rule.getClass();
        this.logger.debug("Check cache for {} with id {}", ruleClass, (Object)cacheId);
        EnforcerRuleCache enforcerRuleCache = this;
        synchronized (enforcerRuleCache) {
            List cacheIdList = this.cache.computeIfAbsent(ruleClass, k -> new ArrayList());
            if (cacheIdList.contains(cacheId)) {
                this.logger.debug("Already cached {} with id {}", ruleClass, (Object)cacheId);
                return true;
            }
            this.logger.debug("Add cache {} with id {}", ruleClass, (Object)cacheId);
            cacheIdList.add(cacheId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void cleanup() {
        EnforcerRuleCache enforcerRuleCache = this;
        synchronized (enforcerRuleCache) {
            this.cache.clear();
        }
    }
}

