/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.SipInitialLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class SipMessageBuilder<T extends SipMessage>
implements SipMessage.Builder<T> {
    private final List<SipHeader> headers;
    private Predicate<SipHeader> filter;
    private Function<SipURI, SipURI> onRequestURIFunction;
    private CSeqHeader cseq;
    private CSeqHeader.Builder cseqBuilder;
    private Consumer<MaxForwardsHeader.Builder> onMaxForwardsBuilder;
    private Consumer<AddressParametersHeader.Builder<ToHeader>> onToBuilder;
    private Consumer<AddressParametersHeader.Builder<FromHeader>> onFromBuilder;
    private Consumer<AddressParametersHeader.Builder<ContactHeader>> onContactBuilder;
    private List<ViaHeader> viaHeaders;
    private Consumer<ViaHeader.Builder> onTopMostViaBuilder;
    private BiConsumer<Integer, ViaHeader.Builder> onViaBuilder;
    private List<RecordRouteHeader> recordRouteHeaders;
    private Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> onTopMostRecordRouteBuilder;
    private Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> onRecordRouteBuilder;
    private List<RouteHeader> routeHeaders;
    private Consumer<AddressParametersHeader.Builder<RouteHeader>> onTopMostRouteBuilder;
    private Consumer<AddressParametersHeader.Builder<RouteHeader>> onRouteBuilder;
    private Function<SipHeader, SipHeader> onHeaderFunction;
    private Buffer body;
    private SipHeader toHeader;
    private SipHeader fromHeader;
    private SipHeader cSeqHeader;
    private SipHeader callIdHeader;
    private SipHeader maxForwardsHeader;
    private SipHeader viaHeader;
    private SipHeader routeHeader;
    private SipHeader recordRouteHeader;
    private SipHeader contactHeader;
    private boolean useDefaults = true;

    protected SipMessageBuilder(int headerSizeHint) {
        this.headers = new ArrayList<SipHeader>(headerSizeHint);
    }

    protected SipMessageBuilder() {
        this(15);
    }

    @Override
    public SipMessage.Builder<T> withNoDefaults() {
        this.useDefaults = false;
        return this;
    }

    @Override
    public SipMessage.Builder<T> onHeader(Function<SipHeader, SipHeader> f) throws IllegalStateException {
        this.onHeaderFunction = this.onHeaderFunction == null ? f : this.onHeaderFunction.andThen(f);
        return this;
    }

    private void processHeader(SipHeader header) {
        if (header.isContactHeader()) {
            this.addHeader(header);
            this.contactHeader = header;
        } else if (header.isCSeqHeader()) {
            this.addHeader(header);
            this.cSeqHeader = header;
        } else if (header.isMaxForwardsHeader()) {
            this.addHeader(header);
            this.maxForwardsHeader = header;
        } else if (header.isFromHeader()) {
            this.addHeader(header);
            this.fromHeader = header;
        } else if (header.isToHeader()) {
            this.addHeader(header);
            this.toHeader = header;
        } else if (header.isViaHeader()) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.add(header.ensure().toViaHeader());
            this.viaHeader = header;
        } else if (header.isCallIdHeader()) {
            this.addHeader(header);
            this.callIdHeader = header;
        } else if (header.isRouteHeader()) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.add(header.ensure().toRouteHeader());
            this.routeHeader = header;
        } else if (header.isRecordRouteHeader()) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.add(header.ensure().toRecordRouteHeader());
            this.recordRouteHeader = header;
        } else {
            this.addHeader(header);
        }
    }

    private short addHeader(SipHeader header) {
        this.headers.add(header);
        return (short)(this.headers.size() - 1);
    }

    @Override
    public SipMessage.Builder<T> withHeader(SipHeader header) {
        if (header != null) {
            this.processHeader(header);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withHeaders(List<SipHeader> headers) {
        if (headers != null) {
            headers.forEach(this::processHeader);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPushHeader(SipHeader header) {
        return this;
    }

    @Override
    public SipMessage.Builder<T> onFromHeader(Consumer<AddressParametersHeader.Builder<FromHeader>> f) {
        this.onFromBuilder = this.onFromBuilder != null ? this.onFromBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withFromHeader(FromHeader from) {
        if (from != null) {
            this.addHeader(from);
            this.fromHeader = from;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withFromHeader(String from) {
        return this.withFromHeader(FromHeader.frame(Buffers.wrap((String)from)));
    }

    @Override
    public SipMessage.Builder<T> onToHeader(Consumer<AddressParametersHeader.Builder<ToHeader>> f) {
        this.onToBuilder = this.onToBuilder != null ? this.onToBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withToHeader(ToHeader to) {
        if (to != null) {
            this.addHeader(to);
            this.toHeader = to;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withToHeader(String to) {
        return this.withToHeader(ToHeader.frame(Buffers.wrap((String)to)));
    }

    @Override
    public SipMessage.Builder<T> onContactHeader(Consumer<AddressParametersHeader.Builder<ContactHeader>> f) {
        this.onContactBuilder = this.onContactBuilder != null ? this.onContactBuilder.andThen(f) : f;
        return this;
    }

    @Override
    public SipMessage.Builder<T> withContactHeader(ContactHeader contact) {
        if (contact != null) {
            this.addHeader(contact);
            this.contactHeader = contact;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onCSeqHeader(Consumer<CSeqHeader.Builder> f) {
        return this;
    }

    @Override
    public SipMessage.Builder<T> withCSeqHeader(CSeqHeader cseq) {
        if (cseq != null) {
            this.addHeader(cseq);
            this.cSeqHeader = cseq;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withCallIdHeader(CallIdHeader callID) {
        if (callID != null) {
            this.addHeader(callID);
            this.callIdHeader = callID;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onMaxForwardsHeader(Consumer<MaxForwardsHeader.Builder> f) {
        if (this.onMaxForwardsBuilder != null) {
            this.onMaxForwardsBuilder.andThen(f);
        } else {
            this.onMaxForwardsBuilder = f;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withMaxForwardsHeader(MaxForwardsHeader maxForwards) {
        this.addHeader(maxForwards);
        this.maxForwardsHeader = maxForwards;
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostViaHeader(Consumer<ViaHeader.Builder> f) {
        this.onTopMostViaBuilder = this.chainConsumers(this.onTopMostViaBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onViaHeader(BiConsumer<Integer, ViaHeader.Builder> f) {
        this.onViaBuilder = this.chainConsumers(this.onViaBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> f) {
        this.onTopMostRouteBuilder = this.chainConsumers(this.onTopMostRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> f) {
        this.onRouteBuilder = this.chainConsumers(this.onRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeader(RouteHeader route) {
        if (route != null) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            this.routeHeaders.add(route);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeaders(RouteHeader ... routes) {
        if (routes != null && routes.length > 0) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            this.routeHeader = routes[0];
            this.routeHeaders.addAll(Arrays.asList(routes));
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRouteHeaders(List<RouteHeader> routes) {
        if (routes != null && !routes.isEmpty()) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.clear();
            this.routeHeader = routes.get(0);
            this.routeHeaders.addAll(routes);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostRouteHeader(RouteHeader route) {
        if (route != null) {
            this.routeHeaders = this.ensureList(this.routeHeaders);
            this.routeHeaders.add(0, route);
            this.routeHeader = route;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPoppedRoute() {
        if (this.routeHeaders != null) {
            this.routeHeaders.remove(0);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withNoRoutes() {
        if (this.routeHeaders != null) {
            this.routeHeaders.clear();
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> onTopMostRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> f) {
        this.onTopMostRecordRouteBuilder = this.chainConsumers(this.onTopMostRecordRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> onRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> f) {
        this.onRecordRouteBuilder = this.chainConsumers(this.onRecordRouteBuilder, f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeader(RecordRouteHeader recordRoute) {
        if (recordRoute != null) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            this.recordRouteHeaders.add(recordRoute);
            this.recordRouteHeader = recordRoute;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeaders(RecordRouteHeader ... recordRoutes) {
        if (recordRoutes != null && recordRoutes.length > 0) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            this.recordRouteHeader = recordRoutes[0];
            this.recordRouteHeaders.addAll(Arrays.asList(recordRoutes));
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withRecordRouteHeaders(List<RecordRouteHeader> recordRoutes) {
        if (recordRoutes != null && !recordRoutes.isEmpty()) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.clear();
            this.recordRouteHeader = recordRoutes.get(0);
            this.recordRouteHeaders.addAll(recordRoutes);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostRecordRouteHeader(RecordRouteHeader recordRoute) {
        if (recordRoute != null) {
            this.recordRouteHeaders = this.ensureList(this.recordRouteHeaders);
            this.recordRouteHeaders.add(0, recordRoute);
            this.recordRouteHeader = recordRoute;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeader(ViaHeader via) {
        if (via != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            this.viaHeaders.add(via);
            this.viaHeader = via;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeaders(ViaHeader ... vias) {
        if (vias != null && vias.length > 0) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            this.viaHeader = vias[0];
            this.viaHeaders.addAll(Arrays.asList(vias));
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withViaHeaders(List<ViaHeader> vias) {
        if (vias != null && !vias.isEmpty()) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.clear();
            this.viaHeader = vias.get(0);
            this.viaHeaders.addAll(vias);
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostViaHeader(ViaHeader via) {
        if (via != null) {
            this.viaHeaders = this.ensureList(this.viaHeaders);
            this.viaHeaders.add(0, via);
            this.viaHeader = via;
        }
        return this;
    }

    @Override
    public SipMessage.Builder<T> withTopMostViaHeader() {
        this.viaHeaders = this.ensureList(this.viaHeaders);
        this.viaHeaders.add(0, null);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withPoppedVia() {
        if (this.viaHeaders != null) {
            this.viaHeaders.remove(0);
        }
        return this;
    }

    protected final Function<SipURI, SipURI> getRequestURIFunction() {
        return this.onRequestURIFunction;
    }

    private <T> List<T> ensureList(List<T> list) {
        if (list != null) {
            return list;
        }
        return new ArrayList(4);
    }

    @Override
    public SipMessage.Builder<T> onRequestURI(Function<SipURI, SipURI> f) {
        this.onRequestURIFunction = this.onRequestURIFunction == null ? f : this.onRequestURIFunction.andThen(f);
        return this;
    }

    @Override
    public SipMessage.Builder<T> withBody(Buffer body) {
        if (body != null) {
            this.body = body.slice();
        }
        return this;
    }

    private final int sizeOf(List<?> list) {
        return list == null ? 0 : list.size() - 1;
    }

    private void enforceDefaults() {
        if (this.toHeader == null) {
            this.withToHeader(this.generateDefaultToHeader());
        }
        if (this.isBuildingRequest() && this.maxForwardsHeader == null) {
            this.withMaxForwardsHeader(MaxForwardsHeader.create());
        }
        if (this.callIdHeader == null) {
            this.withCallIdHeader(CallIdHeader.create());
        }
        if (this.cSeqHeader == null) {
            this.withCSeqHeader(this.generateDefaultCSeqHeader());
        }
    }

    protected boolean isBuildingRequest() {
        return false;
    }

    protected boolean isBuildingResponse() {
        return false;
    }

    protected abstract ToHeader generateDefaultToHeader();

    protected abstract CSeqHeader generateDefaultCSeqHeader();

    @Override
    public T build() {
        Consumer<AddressParametersHeader.Builder<Object>> f;
        int j;
        int msgSize = 2;
        int headerCount = this.headers.size() + this.sizeOf(this.viaHeaders) + this.sizeOf(this.recordRouteHeaders) + this.sizeOf(this.routeHeaders);
        HashMap<String, List<SipHeader>> finalHeaders = new HashMap<String, List<SipHeader>>(headerCount);
        SipHeader contentLengthHeader = null;
        if (this.useDefaults) {
            this.enforceDefaults();
        }
        this.toHeader = null;
        this.fromHeader = null;
        this.cSeqHeader = null;
        this.callIdHeader = null;
        this.maxForwardsHeader = null;
        this.viaHeader = null;
        this.routeHeader = null;
        this.recordRouteHeader = null;
        this.contactHeader = null;
        for (int i = 0; i < this.headers.size(); ++i) {
            SipHeader finalHeader;
            SipHeader header = this.headers.get(i);
            if (header == null || (finalHeader = this.processFinalHeader((short)finalHeaders.size(), header)) == null) continue;
            if (finalHeader.isContentLengthHeader()) {
                contentLengthHeader = finalHeader;
                continue;
            }
            msgSize += finalHeader.getBufferSize() + 2;
            finalHeaders.computeIfAbsent(finalHeader.getName().toString(), k -> new ArrayList()).add(finalHeader);
        }
        if (this.viaHeaders != null) {
            for (j = 0; j < this.viaHeaders.size(); ++j) {
                ViaHeader finalVia = this.processVia(j, this.viaHeaders.get(j));
                msgSize += finalVia.getBufferSize() + 2;
                if (this.viaHeader == null) {
                    this.viaHeader = finalVia;
                }
                finalHeaders.computeIfAbsent(finalVia.getName().toString(), k -> new ArrayList()).add(finalVia);
            }
        }
        if (this.recordRouteHeaders != null) {
            for (j = 0; j < this.recordRouteHeaders.size(); ++j) {
                f = j == 0 ? this.onTopMostRecordRouteBuilder : this.onRecordRouteBuilder;
                RecordRouteHeader finalRR = this.invokeAddressBuilderFunction(f, this.recordRouteHeaders.get(j).ensure().toRecordRouteHeader());
                msgSize += finalRR.getBufferSize() + 2;
                if (this.recordRouteHeader == null) {
                    this.recordRouteHeader = finalRR;
                }
                finalHeaders.computeIfAbsent(finalRR.getName().toString(), k -> new ArrayList()).add(finalRR);
            }
        }
        if (this.routeHeaders != null) {
            for (j = 0; j < this.routeHeaders.size(); ++j) {
                f = j == 0 ? this.onTopMostRouteBuilder : this.onRouteBuilder;
                RouteHeader finalRoute = this.invokeAddressBuilderFunction(f, this.routeHeaders.get(j).ensure().toRouteHeader());
                msgSize += finalRoute.getBufferSize() + 2;
                if (this.routeHeader == null) {
                    this.routeHeader = finalRoute;
                }
                finalHeaders.computeIfAbsent(finalRoute.getName().toString(), k -> new ArrayList()).add(finalRoute);
            }
        }
        Buffer body = this.body;
        if (this.isBuildingRequest() && this.useDefaults) {
            contentLengthHeader = ContentLengthHeader.create(body == null ? 0 : body.capacity());
        }
        if (contentLengthHeader != null) {
            msgSize += contentLengthHeader.getBufferSize() + 2;
            finalHeaders.computeIfAbsent(contentLengthHeader.getName().toString(), k -> new ArrayList()).add(contentLengthHeader);
        }
        SipInitialLine initialLine = this.buildInitialLine();
        Buffer initialLineBuffer = initialLine.getBuffer();
        msgSize += initialLineBuffer.getReadableBytes() + 2;
        if (body != null) {
            msgSize += body.getReadableBytes();
        }
        Buffer msg = Buffers.createBuffer((int)msgSize);
        initialLineBuffer.getBytes(msg);
        msg.write((byte)13);
        msg.write((byte)10);
        for (List headerValues : finalHeaders.values()) {
            for (SipHeader header : headerValues) {
                header.getBytes(msg);
                msg.write((byte)13);
                msg.write((byte)10);
            }
        }
        msg.write((byte)13);
        msg.write((byte)10);
        if (body != null) {
            body.getBytes(msg);
        }
        return this.internalBuild(msg, initialLine, finalHeaders, this.toHeader, this.fromHeader, this.cSeqHeader, this.callIdHeader, this.maxForwardsHeader, this.viaHeader, this.routeHeader, this.recordRouteHeader, this.contactHeader, body);
    }

    private ViaHeader processVia(int index, SipHeader header) throws SipParseException {
        ViaHeader.Builder builder;
        if (index > 0 && this.onViaBuilder == null) {
            if (header == null) {
                throw new SipParseException("You cannot register an empty Via-header and then not also register a function for that via. Please refer to javadoc");
            }
            return header.ensure().toViaHeader();
        }
        if (index == 0 && this.onTopMostViaBuilder == null) {
            if (header == null) {
                throw new SipParseException("You cannot register an empty top-most Via-header and then not also register a function for that top-most via. Please refer to the javadoc");
            }
            return header.ensure().toViaHeader();
        }
        ViaHeader.Builder builder2 = builder = header == null ? ViaHeader.builder() : header.ensure().toViaHeader().copy();
        if (index == 0) {
            this.onTopMostViaBuilder.accept(builder);
        } else {
            this.onViaBuilder.accept(index, builder);
        }
        return builder.build();
    }

    protected abstract SipInitialLine buildInitialLine() throws SipParseException;

    protected abstract T internalBuild(Buffer var1, SipInitialLine var2, Map<String, List<SipHeader>> var3, SipHeader var4, SipHeader var5, SipHeader var6, SipHeader var7, SipHeader var8, SipHeader var9, SipHeader var10, SipHeader var11, SipHeader var12, Buffer var13);

    private SipHeader processFinalHeader(short index, SipHeader header) {
        SipHeader finalHeader;
        if (header.isContactHeader()) {
            finalHeader = this.invokeContactHeaderFunction(header.ensure().toContactHeader());
            this.contactHeader = finalHeader;
        } else if (header.isCSeqHeader()) {
            finalHeader = header.ensure().toCSeqHeader();
            this.cSeqHeader = finalHeader;
        } else if (header.isMaxForwardsHeader()) {
            finalHeader = this.invokeMaxForwardsFunction(header.ensure().toMaxForwardsHeader());
            this.maxForwardsHeader = finalHeader;
        } else if (header.isFromHeader()) {
            finalHeader = this.invokeFromHeaderFunction(header.ensure().toFromHeader());
            this.fromHeader = finalHeader;
        } else if (header.isToHeader()) {
            finalHeader = this.invokeToHeaderFunction(header.ensure().toToHeader());
            this.toHeader = finalHeader;
        } else if (header.isCallIdHeader()) {
            finalHeader = header.ensure().toCallIdHeader();
            this.callIdHeader = finalHeader;
        } else {
            finalHeader = this.processGenericHeader(header);
        }
        return finalHeader;
    }

    private <T extends SipHeader> T invokeSipHeaderBuilderFunction(Consumer<SipHeader.Builder<T>> f, T header) {
        if (header != null && f != null) {
            SipHeader.Builder b = header.copy();
            f.accept(b);
            return (T)b.build();
        }
        return header;
    }

    private <T extends AddressParametersHeader> T invokeAddressBuilderFunction(Consumer<AddressParametersHeader.Builder<T>> f, T header) {
        if (header != null && f != null) {
            AddressParametersHeader.Builder b = header.copy();
            f.accept(b);
            return (T)b.build();
        }
        return header;
    }

    private SipHeader processGenericHeader(SipHeader header) {
        if (this.onHeaderFunction != null) {
            return this.onHeaderFunction.apply(header);
        }
        return header;
    }

    private ToHeader invokeToHeaderFunction(ToHeader to) {
        if (to != null && this.onToBuilder != null) {
            ToHeader.Builder b = to.copy();
            this.onToBuilder.accept(b);
            return (ToHeader)b.build();
        }
        return to;
    }

    private ContactHeader invokeContactHeaderFunction(ContactHeader contact) {
        if (contact != null && this.onContactBuilder != null) {
            ContactHeader.Builder b = contact.copy();
            this.onContactBuilder.accept(b);
            return (ContactHeader)b.build();
        }
        return contact;
    }

    private FromHeader invokeFromHeaderFunction(FromHeader from) {
        if (from != null && this.onFromBuilder != null) {
            SipHeader.Builder b = from.copy();
            this.onFromBuilder.accept((AddressParametersHeader.Builder<FromHeader>)b);
            return (FromHeader)((AddressParametersHeader.Builder)b).build();
        }
        return from;
    }

    private MaxForwardsHeader invokeMaxForwardsFunction(MaxForwardsHeader max) {
        if (max != null && this.onMaxForwardsBuilder != null) {
            MaxForwardsHeader.Builder b = max.copy();
            this.onMaxForwardsBuilder.accept(b);
            return b.build();
        }
        return max;
    }

    @Override
    public SipMessage.Builder<T> onCommit(Consumer<SipMessage> f) {
        return this;
    }

    private <T> Consumer<T> chainConsumers(Consumer<T> currentConsumer, Consumer<T> consumer) {
        if (currentConsumer != null) {
            return currentConsumer.andThen(consumer);
        }
        return consumer;
    }

    private <T, S> BiConsumer<T, S> chainConsumers(BiConsumer<T, S> currentConsumer, BiConsumer<T, S> consumer) {
        if (currentConsumer != null) {
            return currentConsumer.andThen(consumer);
        }
        return consumer;
    }
}

