/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.MaxForwardsHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import java.io.IOException;

public interface MaxForwardsHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Max-Forwards");

    public int getMaxForwards();

    public static MaxForwardsHeader frame(Buffer buffer) throws SipParseException {
        try {
            int value = buffer.parseToInt();
            return new MaxForwardsHeaderImpl(value);
        }
        catch (NumberFormatException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Max-Forwards header. Value is not an integer");
        }
        catch (IOException e) {
            throw new SipParseException(buffer.getReaderIndex(), "Unable to parse the Max-Forwards header. Got an IOException", e);
        }
    }

    @Override
    public MaxForwardsHeader clone();

    @Override
    default public boolean isMaxForwardsHeader() {
        return true;
    }

    @Override
    default public MaxForwardsHeader toMaxForwardsHeader() {
        return this;
    }

    public static MaxForwardsHeader create(int max) {
        PreConditions.assertArgument(max >= 0, "The value must be greater or equal to zero");
        return new MaxForwardsHeaderImpl(max);
    }

    public static MaxForwardsHeader create() {
        return new MaxForwardsHeaderImpl(70);
    }

    @Override
    public Builder copy();

    public static class Builder
    implements SipHeader.Builder<MaxForwardsHeader> {
        private int value;

        public Builder() {
            this(70);
        }

        public Builder(int value) {
            this.value = value;
        }

        public Builder withValue(int value) {
            this.value = value;
            return this;
        }

        public Builder decrement() {
            --this.value;
            return this;
        }

        @Override
        public SipHeader.Builder<MaxForwardsHeader> withValue(Buffer value) {
            try {
                this.value = value.parseToInt();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract out the value from the buffer due to IOException");
            }
            return this;
        }

        @Override
        public MaxForwardsHeader build() throws SipParseException {
            PreConditions.assertArgument(this.value >= 0, "The value must be greater or equal to zero");
            return new MaxForwardsHeaderImpl(this.value);
        }
    }
}

