/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.version;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.version.AbstractVersionEnforcer;
import org.apache.maven.rtinfo.RuntimeInformation;

@Named(value="requireMavenVersion")
public final class RequireMavenVersion
extends AbstractVersionEnforcer {
    private final RuntimeInformation runtimeInformation;

    @Inject
    public RequireMavenVersion(RuntimeInformation runtimeInformation) {
        this.runtimeInformation = Objects.requireNonNull(runtimeInformation);
    }

    public void execute() throws EnforcerRuleException {
        String mavenVersion = this.runtimeInformation.getMavenVersion();
        this.getLog().debug((CharSequence)("Detected Maven Version: " + mavenVersion));
        if (mavenVersion == null) {
            throw new EnforcerRuleException("Unable to detect Maven Version");
        }
        DefaultArtifactVersion detectedVersion = new DefaultArtifactVersion(mavenVersion);
        this.enforceVersion("Maven", this.getVersion(), (ArtifactVersion)detectedVersion);
    }

    public String toString() {
        return String.format("%s[message=%s, version=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getMessage(), this.getVersion());
    }
}

